/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.reflect.MIHandler;
import org.bbop.reflect.MultipleInheritanceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleInheritanceUtil {
    protected static final Logger logger = Logger.getLogger(MultipleInheritanceUtil.class);
    private static Class<?>[] emptyClassArr = new Class[0];

    public static MultipleInheritanceProxy create(Class<?> ... classes) {
        return MultipleInheritanceUtil.create(ClassLoader.getSystemClassLoader(), true, classes);
    }

    public static MultipleInheritanceProxy create(ClassLoader loader, boolean assignDefaultDelegates, Class<?> ... classes) {
        Constructor<Object> emptyConstructor;
        LinkedList temp = new LinkedList();
        HashMap classMap = null;
        if (assignDefaultDelegates) {
            classMap = new HashMap();
        }
        for (Class<?> c : classes) {
            if (!c.isInterface()) {
                for (Class<?> i : c.getInterfaces()) {
                    if (assignDefaultDelegates && !classMap.containsKey(i)) {
                        try {
                            emptyConstructor = c.getConstructor(emptyClassArr);
                            classMap.put(i, c);
                        }
                        catch (NoSuchMethodException ex) {
                            // empty catch block
                        }
                    }
                    temp.add(i);
                }
                continue;
            }
            temp.add(c);
        }
        Class[] interfaces = new Class[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            interfaces[i] = (Class)temp.get(i);
        }
        MultipleInheritanceProxy out = MultipleInheritanceUtil.createFromInterfaces(ClassLoader.getSystemClassLoader(), interfaces);
        if (assignDefaultDelegates) {
            Object[] emptyObjectArr = new Object[]{};
            for (Class i : interfaces) {
                Class con = (Class)classMap.get(i);
                if (con == null) continue;
                try {
                    emptyConstructor = con.getConstructor(emptyClassArr);
                    Object o = emptyConstructor.newInstance(emptyObjectArr);
                    out.setDelegate(i, o);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return out;
    }

    public static MultipleInheritanceProxy createFromInterfaces(ClassLoader loader, Class<?> ... c) {
        Class[] classes = new Class[c.length + 1];
        classes[0] = MultipleInheritanceProxy.class;
        for (int i = 0; i < c.length; ++i) {
            classes[i + 1] = c[i];
        }
        MIHandler handler = new MIHandler();
        MultipleInheritanceProxy out = (MultipleInheritanceProxy)Proxy.newProxyInstance(loader, classes, (InvocationHandler)handler);
        handler.setProxyObject(out);
        return out;
    }
}

