/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;
import org.bbop.swing.PluggableImageHTMLEditorKit;

public abstract class AbstractIconView
extends View {
    protected static final Logger logger = Logger.getLogger(AbstractIconView.class);
    private static Icon sMissingImageIcon;
    private static final String MISSING_IMAGE_SRC = "icons/image-failed.gif";
    private static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static final int DEFAULT_WIDTH = 38;
    private static final int DEFAULT_HEIGHT = 38;
    private static final int DEFAULT_BORDER = 2;
    private static final int LOADING_FLAG = 1;
    private static final int LINK_FLAG = 2;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private static final int SYNC_LOAD_FLAG = 64;
    private AttributeSet attr;
    private int width;
    private int height;
    private int state;
    private Container container;
    private Rectangle fBounds = new Rectangle();
    private Color borderColor;
    private short borderSize;
    private short leftInset;
    private short rightInset;
    private short topInset;
    private short bottomInset;
    private float vAlign;
    private View altView;
    protected Icon icon;
    protected static JTextComponent holder;

    public AbstractIconView(Element elem) {
        super(elem);
        this.width = this.getIntAttr(HTML.Attribute.WIDTH, -1);
        this.height = this.getIntAttr(HTML.Attribute.HEIGHT, -1);
        this.icon = this.createIcon(PluggableImageHTMLEditorKit.getImageURL(elem), this.width, this.height);
        this.width = this.icon.getIconWidth();
        this.height = this.icon.getIconHeight();
        this.setPropertiesFromAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertiesFromAttributes() {
        AttributeSet anchorAttr;
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.borderSize = (short)this.getIntAttr(HTML.Attribute.BORDER, this.isLink() ? 2 : 0);
        this.leftInset = this.rightInset = (short)(this.getIntAttr(HTML.Attribute.HSPACE, 0) + this.borderSize);
        this.topInset = this.bottomInset = (short)(this.getIntAttr(HTML.Attribute.VSPACE, 0) + this.borderSize);
        this.borderColor = ((StyledDocument)this.getDocument()).getForeground(this.getAttributes());
        AttributeSet attr = this.getElement().getAttributes();
        Object alignment = attr.getAttribute(HTML.Attribute.ALIGN);
        this.vAlign = 1.0f;
        if (alignment != null) {
            if ("top".equals(alignment = alignment.toString())) {
                this.vAlign = 0.0f;
            } else if ("middle".equals(alignment)) {
                this.vAlign = 0.5f;
            }
        }
        if ((anchorAttr = (AttributeSet)attr.getAttribute(HTML.Tag.A)) != null && anchorAttr.isDefined(HTML.Attribute.HREF)) {
            AbstractIconView abstractIconView = this;
            synchronized (abstractIconView) {
                this.state |= 2;
            }
        }
        AbstractIconView abstractIconView = this;
        synchronized (abstractIconView) {
            this.state = (this.state | 2) ^ 2;
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    private int getIntAttr(HTML.Attribute name, int deflt) {
        AttributeSet attr = this.getElement().getAttributes();
        if (attr.isDefined(name)) {
            int i;
            String val = (String)attr.getAttribute(name);
            if (val == null) {
                i = deflt;
            } else {
                try {
                    i = Math.max(0, Integer.parseInt(val));
                }
                catch (NumberFormatException x) {
                    i = deflt;
                }
            }
            return i;
        }
        return deflt;
    }

    private boolean isLink() {
        return (this.state & 2) == 2;
    }

    public abstract Icon createIcon(URL var1, int var2, int var3);

    public void paint(Graphics g, Shape a) {
        this.setPropertiesFromAttributes();
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle clip = g.getClipBounds();
        this.fBounds.setBounds(rect);
        this.paintHighlights(g, a);
        this.paintBorder(g, rect);
        if (clip != null) {
            g.clipRect(rect.x + this.leftInset, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset, rect.height - this.topInset - this.bottomInset);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
        } else {
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
            }
        }
        if (clip != null) {
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }

    protected static JTextComponent getDefaultHolder() {
        if (holder == null) {
            holder = new JTextField();
        }
        return holder;
    }

    private void paintHighlights(Graphics g, Shape shape) {
        JTextComponent tc = this.container instanceof JTextComponent ? (JTextComponent)this.container : AbstractIconView.getDefaultHolder();
        Highlighter h = tc.getHighlighter();
        if (h instanceof LayeredHighlighter) {
            ((LayeredHighlighter)h).paintLayeredHighlights(g, this.getStartOffset(), this.getEndOffset(), shape, tc, this);
        }
    }

    public Icon getNoImageIcon() {
        this.loadDefaultIconsIfNecessary();
        return sMissingImageIcon;
    }

    private void loadDefaultIconsIfNecessary() {
        try {
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
            }
        }
        catch (Exception x) {
            logger.info((Object)"ImageView: Couldn't load image icons");
        }
    }

    private Icon makeIcon(String gifFile) throws IOException {
        int n;
        InputStream resource = this.getClass().getResourceAsStream(gifFile);
        if (resource == null) {
            logger.info((Object)(ImageView.class.getName() + "/" + gifFile + " not found."));
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.flush();
        buffer = out.toByteArray();
        if (buffer.length == 0) {
            logger.info((Object)("warning: " + gifFile + " is zero-length"));
            return null;
        }
        return new ImageIcon(buffer);
    }

    private void paintBorder(Graphics g, Rectangle rect) {
        Color color = this.borderColor;
        if ((this.borderSize > 0 || this.icon == null) && color != null) {
            int xOffset = this.leftInset - this.borderSize;
            int yOffset = this.topInset - this.borderSize;
            g.setColor(color);
            int n = this.icon == null ? 1 : this.borderSize;
            for (int counter = 0; counter < n; ++counter) {
                g.drawRect(rect.x + xOffset + counter, rect.y + yOffset + counter, rect.width - counter - counter - xOffset - xOffset - 1, rect.height - counter - counter - yOffset - yOffset - 1);
            }
        }
    }

    public float getPreferredSpan(int axis) {
        this.setPropertiesFromAttributes();
        switch (axis) {
            case 0: {
                return this.width + this.leftInset + this.rightInset;
            }
            case 1: {
                return this.height + this.topInset + this.bottomInset;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }
}

