/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.TaskDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundEventQueue {
    protected static final Logger logger = Logger.getLogger(BackgroundEventQueue.class);
    private static int idgen = 0;
    private int id = idgen++;
    protected BackgroundEventThread thread;
    protected static BackgroundEventQueue queue;

    public void cancelAll() {
        this.getBackgroundEventThread().cancelAll();
    }

    public void addStartupNotifier(Runnable r) {
        this.getBackgroundEventThread().addStartupNotifier(r);
    }

    public void removeStartupNotifier(Runnable r) {
        this.getBackgroundEventThread().removeStartupNotifier(r);
    }

    public static BackgroundEventQueue getGlobalQueue() {
        if (queue == null) {
            queue = new BackgroundEventQueue();
        }
        return queue;
    }

    public void scheduleTask(TaskDelegate<?> t) {
        BackgroundEventThread thread = this.getBackgroundEventThread();
        thread.scheduleTask(t);
    }

    public void scheduleTasks(TaskDelegate<?> ... tasks) {
        BackgroundEventThread thread = this.getBackgroundEventThread();
        for (TaskDelegate<?> task : tasks) {
            thread.scheduleTask(task);
        }
    }

    public void scheduleDependentTasks(TaskDelegate<?> ... tasks) {
        BackgroundEventThread thread = this.getBackgroundEventThread();
        thread.scheduleTask(new TaskGroup(tasks));
    }

    protected BackgroundEventThread getBackgroundEventThread() {
        if (this.thread == null) {
            this.thread = new BackgroundEventThread();
            this.thread.start();
        }
        return this.thread;
    }

    public TaskDelegate<?> getCurrentTask() {
        return this.thread.getCurrentTask();
    }

    public int getPendingTaskCount() {
        return this.thread.getTaskQueue().size();
    }

    protected void finalize() throws Throwable {
        this.die();
        super.finalize();
    }

    public void die() {
        if (this.thread != null) {
            this.thread.kill();
        }
    }

    public String toString() {
        return "Background Event Queue " + this.id;
    }

    public <T> T runTaskNow(TaskDelegate<T> task) {
        BackgroundEventThread thread = this.getBackgroundEventThread();
        final Thread currentThread = Thread.currentThread();
        Runnable r = new Runnable(){

            public void run() {
                currentThread.interrupt();
            }
        };
        thread.addSleepNotifier(r);
        thread.scheduleTask(task);
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        thread.removeSleepNotifier(r);
        return task.getResults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BackgroundEventThread
    extends Thread {
        protected LinkedList<TaskDelegate<?>> l = new LinkedList();
        protected TaskDelegate<?> currentTask;
        protected List<Runnable> startupNotifiers = new LinkedList<Runnable>();
        protected List<Runnable> sleepNotifiers = new LinkedList<Runnable>();
        protected boolean kill = false;
        protected StackTraceElement[] trace;

        public BackgroundEventThread() {
            this.setDaemon(true);
            this.trace = new Exception().getStackTrace();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.kill) {
                TaskDelegate<?> t;
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                for (Runnable r : this.startupNotifiers) {
                    r.run();
                }
                while ((t = this.l.poll()) != null) {
                    this.executeTask(t);
                }
                this.currentTask = null;
                for (Runnable r : new ArrayList<Runnable>(this.sleepNotifiers)) {
                    r.run();
                }
            }
        }

        public void cancelAll() {
            LinkedList cancelUs = new LinkedList(this.l);
            if (this.currentTask != null) {
                cancelUs.add(0, this.currentTask);
            }
            try {
                for (TaskDelegate taskDelegate : cancelUs) {
                    taskDelegate.cancel();
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Exception while cancelling talk: " + e.getStackTrace()));
            }
        }

        protected void addSleepNotifier(Runnable r) {
            this.sleepNotifiers.add(r);
        }

        public void removeSleepNotifier(Runnable r) {
            this.sleepNotifiers.remove(r);
        }

        protected void addStartupNotifier(Runnable r) {
            this.startupNotifiers.add(r);
        }

        protected void removeStartupNotifier(Runnable r) {
            this.startupNotifiers.remove(r);
        }

        protected boolean executeTask(TaskGroup g) {
            for (TaskDelegate<?> t : g.getTasks()) {
                boolean cancelled = this.executeTask(t);
                if (!cancelled) continue;
                g.cancel();
                return true;
            }
            return false;
        }

        protected boolean executeTask(TaskDelegate<?> t) {
            if (t instanceof TaskGroup) {
                return this.executeTask((TaskGroup)t);
            }
            try {
                if (t.isCancelled()) {
                    return true;
                }
                this.currentTask = t;
                this.currentTask.run();
                return this.currentTask.isCancelled();
            }
            catch (Throwable error) {
                return true;
            }
        }

        protected void scheduleTask(TaskDelegate<?> t) {
            this.l.add(t);
            this.interrupt();
        }

        protected TaskDelegate<?> getCurrentTask() {
            return this.currentTask;
        }

        protected LinkedList<TaskDelegate<?>> getTaskQueue() {
            return this.l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaskGroup
    extends AbstractTaskDelegate<Void> {
        protected TaskDelegate<?>[] tasks;

        public TaskGroup(TaskDelegate<?>[] tasks) {
            this.tasks = tasks;
        }

        public TaskDelegate<?>[] getTasks() {
            return this.tasks;
        }

        @Override
        public void execute() {
        }

        @Override
        public void cancel() {
            super.cancel();
            for (TaskDelegate<?> t : this.getTasks()) {
                t.cancel();
            }
        }
    }
}

