/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.bbop.swing.AbstractTreeModel;
import org.bbop.util.VectorFilter;
import org.bbop.util.VectorUtil;

public class FileSystemTreeModel
extends AbstractTreeModel {
    protected static final Logger logger = Logger.getLogger(FileSystemTreeModel.class);
    protected static Comparator defaultComparator = new Comparator(){

        public int compare(Object obja, Object objb) {
            File a = (File)obja;
            File b = (File)objb;
            if (a.isDirectory() && !b.isDirectory()) {
                return -1;
            }
            if (b.isDirectory() && !a.isDirectory()) {
                return 1;
            }
            if (b.isHidden() && !a.isHidden()) {
                return 1;
            }
            int compVal = a.getName().compareToIgnoreCase(b.getName());
            if (compVal < 0) {
                return -1;
            }
            if (compVal > 0) {
                return 1;
            }
            return 0;
        }
    };
    protected FilenameFilter showFoldersWrapperFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                return true;
            }
            return FileSystemTreeModel.this.filter.accept(dir, name);
        }
    };
    protected FilenameFilter defaultFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return true;
        }
    };
    protected VectorFilter hiddenFilter = new VectorFilter(){
        private static final long serialVersionUID = -627211135110757782L;

        public boolean satisfies(Object o) {
            return !((File)o).isHidden() && !((File)o).getName().startsWith(".");
        }
    };
    protected Object root;
    protected HashMap childCache = new HashMap();
    protected boolean showHidden = false;
    protected FilenameFilter filter;

    public FileSystemTreeModel() {
        this(null, null);
    }

    public FileSystemTreeModel(FilenameFilter filter) {
        this(null, filter);
    }

    public FileSystemTreeModel(File root) {
        this(root, null);
    }

    public FileSystemTreeModel(File root, FilenameFilter filter) {
        this.setRoot(root, false);
        this.setFilter(filter, false);
        this.reload();
    }

    public void setRoot(Object root) {
        this.setRoot(root, true);
    }

    protected void setRoot(Object root, boolean reload) {
        this.root = root == null ? this.getDefaultRoot() : root;
        if (reload) {
            this.reload();
        }
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FilenameFilter filter) {
        this.setFilter(filter, true);
    }

    protected void setFilter(FilenameFilter filter, boolean reload) {
        this.filter = filter == null ? this.getDefaultFilter() : filter;
        if (reload) {
            this.reload();
        }
    }

    protected Comparator getDefaultComparator() {
        return defaultComparator;
    }

    protected FilenameFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    public boolean getShowHidden() {
        return this.showHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public Object getDefaultRoot() {
        File[] fileRoots = File.listRoots();
        if (fileRoots.length == 1) {
            return fileRoots[0];
        }
        return new DummyRoot("My computer");
    }

    protected Vector getChildren(Object parent) {
        Vector out = (Vector)this.childCache.get(parent);
        if (out == null) {
            File parentFile;
            out = new Vector();
            File[] files = null;
            if (parent instanceof DummyRoot) {
                files = File.listRoots();
            }
            if ((parentFile = (File)parent).isDirectory()) {
                files = parentFile.listFiles(this.showFoldersWrapperFilter);
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    out.add(files[i]);
                }
                if (!this.showHidden) {
                    out = VectorUtil.filter(this.hiddenFilter, out);
                }
                Collections.sort(out, this.getDefaultComparator());
            }
            this.childCache.put(parent, out);
        }
        return out;
    }

    public void reload() {
        this.childCache.clear();
        super.reload();
    }

    public TreePath getTreePath(File file) {
        Vector<Object> out = new Vector<Object>();
        do {
            out.insertElementAt(file, 0);
        } while ((file = file.getParentFile()) != null && !file.equals(this.root));
        if (file == null && this.root instanceof DummyRoot || file != null && file.equals(this.root)) {
            out.insertElementAt(this.root, 0);
        }
        Object[] nodes = new Object[out.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = out.elementAt(i);
        }
        return new TreePath(nodes);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return this.getChildren(parent).elementAt(index);
    }

    public int getChildCount(Object parent) {
        return this.getChildren(parent).size();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildren(parent).indexOf(child);
    }

    public void valueForPathChanged(TreePath path, Object o) {
    }

    public class DummyRoot {
        protected String name;

        public DummyRoot(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

