/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.swing.IconFactory;
import org.bbop.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconFactoryRegistry {
    protected static final Logger logger = Logger.getLogger(IconFactoryRegistry.class);
    protected static Map<String, IconFactory> iconFactoryMap = new HashMap<String, IconFactory>();
    protected static List<IconRegistryListener> listeners = new ArrayList<IconRegistryListener>();

    private IconFactoryRegistry() {
    }

    public static void addListener(IconRegistryListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IconRegistryListener listener) {
        listeners.remove(listener);
    }

    public static Collection<String> getSuffixes() {
        return iconFactoryMap.keySet();
    }

    public static IconFactory getFactory(String suffix) {
        return iconFactoryMap.get(suffix);
    }

    public static void installFactory(String suffix, IconFactory factory) {
        iconFactoryMap.put(suffix, factory);
        for (IconRegistryListener listener : listeners) {
            listener.factoryInstalled(suffix, factory);
        }
    }

    public static void uninstallFactory(String suffix, IconFactory factory) {
        if (ObjectUtil.equals(iconFactoryMap.get(suffix), factory)) {
            iconFactoryMap.remove(suffix);
            for (IconRegistryListener listener : listeners) {
                listener.factoryRemoved(suffix, factory);
            }
        }
    }

    public static interface IconRegistryListener
    extends EventListener {
        public void factoryInstalled(String var1, IconFactory var2);

        public void factoryRemoved(String var1, IconFactory var2);
    }
}

