/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class MinusIcon
implements Icon {
    protected static final Logger logger = Logger.getLogger(MinusIcon.class);
    protected Color color;
    protected float linewidth;
    protected int margin;
    protected BasicStroke stroke;
    protected int width;
    protected int height;

    public MinusIcon() {
        this(null, 2.0f, 0, 10, 10);
    }

    public MinusIcon(float linewidth, int width, int height) {
        this(null, linewidth, 0, width, height);
    }

    public MinusIcon(int width, int height) {
        this(null, 2.0f, 0, width, height);
    }

    public MinusIcon(Color color, float linewidth, int margin, int width, int height) {
        this.color = color;
        this.linewidth = linewidth;
        this.margin = margin;
        this.height = height;
        this.width = width;
        this.stroke = new BasicStroke(linewidth);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color = this.color;
        if (color == null) {
            color = c.getForeground();
        }
        if (!c.isEnabled()) {
            color = c.getBackground().darker();
        }
        g.setColor(color);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(this.stroke);
        }
        int ycenter = this.height / 2;
        g.drawLine(x + this.margin, y + this.height / 2, x + this.width - this.margin, y + this.height / 2);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

