/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class MultiIcon
implements Icon {
    protected static final Logger logger = Logger.getLogger(MultiIcon.class);
    protected Vector icons = new Vector();
    protected int iconSpacing = 5;
    static int i;

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int height = this.getIconHeight();
        for (Icon icon : this.icons) {
            icon.paintIcon(c, g, x, y + (height - icon.getIconHeight()) / 2);
            x += icon.getIconWidth() + this.iconSpacing;
        }
        ++i;
    }

    public int getIconWidth() {
        int totalWidth = 0;
        for (int i = 0; i < this.icons.size(); ++i) {
            Icon icon = (Icon)this.icons.get(i);
            if (i > 0) {
                totalWidth += this.iconSpacing;
            }
            totalWidth += icon.getIconWidth();
        }
        return totalWidth;
    }

    public int getIconHeight() {
        int maxHeight = 0;
        for (Icon icon : this.icons) {
            if (icon.getIconHeight() <= maxHeight) continue;
            maxHeight = icon.getIconHeight();
        }
        return maxHeight;
    }

    public void addIcon(Icon icon) {
        this.icons.add(icon);
    }

    public void removeIcon(Icon icon) {
        this.icons.remove(icon);
    }

    public void clearIcons() {
        this.icons.clear();
    }
}

