/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.bbop.swing.AbstractPeriodicUpdateRunnable;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.util.TaskDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressBarUpdateRunnable
extends AbstractPeriodicUpdateRunnable {
    protected static final Logger logger = Logger.getLogger(ProgressBarUpdateRunnable.class);
    protected JProgressBar progressBar;

    public ProgressBarUpdateRunnable(BackgroundEventQueue queue, JProgressBar progressBar) {
        super(queue, true);
        this.progressBar = progressBar;
    }

    @Override
    protected void cleanupUpdate() {
    }

    @Override
    protected void doUpdate(TaskDelegate<?> task) {
        Number n = task.getProgressValue();
        if (n != null) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(n.intValue());
        } else {
            this.progressBar.setIndeterminate(true);
        }
        String s = task.getProgressString();
        if (s != null) {
            this.progressBar.setString(s);
        }
        this.progressBar.repaint();
    }

    @Override
    protected boolean isCancelled() {
        return false;
    }

    @Override
    protected void setupUpdate() {
    }
}

