/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.bbop.swing.AbstractPeriodicUpdateRunnable;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.swing.SwingUtil;
import org.bbop.util.TaskDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenLockRunnable
extends AbstractPeriodicUpdateRunnable {
    protected static final Logger logger = Logger.getLogger(ScreenLockRunnable.class);
    protected JButton cancelButton = new JButton("Cancel");
    protected JProgressBar progressBar = new JProgressBar();
    protected JLabel messageLabel = new JLabel();
    protected JDialog dialog;
    protected Frame frame;
    protected boolean modal;
    protected boolean cancelled;

    public ScreenLockRunnable(BackgroundEventQueue queue, Frame frame, boolean modal) {
        super(queue, true);
        this.frame = frame;
        this.modal = modal;
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLockRunnable.this.cancelled = true;
            }
        });
    }

    @Override
    protected void setupUpdate() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.cancelled = false;
        this.progressBar.setString("0 %");
        this.progressBar.setIndeterminate(true);
        this.progressBar.setValue(0);
        this.messageLabel.setText("");
        this.dialog.setSize(400, 200);
        SwingUtil.center(this.frame, this.dialog);
        this.dialog.toFront();
        this.dialog.setVisible(true);
    }

    protected JDialog createDialog() {
        JDialog dialog = new JDialog(this.frame, "Progress...", this.modal);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)this.progressBar, "Center");
        southPanel.add((Component)this.cancelButton, "South");
        contentPane.add((Component)this.messageLabel, "Center");
        contentPane.add((Component)southPanel, "South");
        dialog.setContentPane(contentPane);
        return dialog;
    }

    @Override
    protected void cleanupUpdate() {
        if (this.dialog != null) {
            this.dialog.setFocusable(true);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    @Override
    protected boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    protected void doUpdate(TaskDelegate<?> currentTask) {
        String s;
        Number n = currentTask.getProgressValue();
        if (n != null) {
            int val = n.intValue();
            if (val < 0) {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setStringPainted(false);
            } else {
                this.progressBar.setValue(val);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setString(val + " %");
                this.progressBar.setStringPainted(true);
            }
        }
        if ((s = currentTask.getProgressString()) != null) {
            this.messageLabel.setText(s);
        }
    }
}

