/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.swing.ComponentNameResolver;
import org.bbop.swing.XMLLayout;
import org.bbop.swing.XMLLayoutRoot;

public class XMLLayoutPanel
extends JPanel
implements XMLLayoutRoot {
    protected static final Logger logger = Logger.getLogger(XMLLayoutPanel.class);
    private static final long serialVersionUID = 4373420458011869480L;
    protected XMLLayout layout = new XMLLayout();
    protected JPanel windowButtonPanel;
    protected Exception parseException;
    protected LinkedList windowList = new LinkedList();

    public XMLLayoutPanel() {
        this.setLayout(new BorderLayout());
        this.layout.setLayoutRoot(this);
    }

    public void setIsLayoutRoot(boolean isLayoutRoot) {
        if (isLayoutRoot) {
            this.windowButtonPanel = new JPanel();
            TitledBorder titledBorder = new TitledBorder("Minimized Application Windows");
            if (this.layout.getDefaultFont() != null) {
                titledBorder.setTitleFont(this.layout.getDefaultFont());
            }
            this.windowButtonPanel.setBorder(titledBorder);
        }
    }

    public void minimizeWindow(final Window window) {
        if (this.windowButtonPanel != null) {
            window.setVisible(false);
            String title = null;
            if (window instanceof Dialog) {
                title = ((Dialog)window).getTitle();
            } else if (window instanceof Frame) {
                title = ((Frame)window).getTitle();
            }
            if (title == null || title.length() == 0) {
                title = "Window";
            }
            final JButton maximizeButton = new JButton(title);
            if (this.layout.getDefaultTabColor() != null) {
                maximizeButton.setBackground(this.layout.getDefaultTabColor());
            }
            if (this.layout.getDefaultFont() != null) {
                maximizeButton.setFont(this.layout.getDefaultFont());
            }
            this.windowButtonPanel.add(maximizeButton);
            maximizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XMLLayoutPanel.this.maximizeWindow(window, maximizeButton);
                }
            });
            if (this.windowList.size() == 0) {
                this.add((Component)this.windowButtonPanel, "South");
                this.validate();
            }
            this.windowList.add(window);
        } else {
            window.dispose();
        }
    }

    protected void maximizeWindow(Window window, JButton maximizeButton) {
        window.setVisible(true);
        this.windowButtonPanel.remove(maximizeButton);
        this.windowList.remove(window);
        if (this.windowList.size() == 0) {
            this.remove(this.windowButtonPanel);
        }
    }

    public void guiupdate() throws ExpressionException {
    }

    public boolean reload() {
        try {
            if (this.windowButtonPanel != null) {
                this.windowButtonPanel.setBackground(this.layout.getDefaultBGColor());
            }
            this.windowList.clear();
            this.windowButtonPanel.removeAll();
            for (XMLLayout.WindowElement window : this.layout.windows) {
                window.clear();
            }
            this.removeAll();
            this.layout.cached = false;
            this.layout.resolver.startParseNotify();
            if (this.layout.getRoot().getComponents().size() > 0) {
                this.add((Component)this.layout.getRoot().getComponents().get(0), "Center");
            }
            this.layout.resolver.endParseNotify();
            this.parseException = null;
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.parseException = ex;
            return false;
        }
    }

    public Exception getParseException() {
        return this.parseException;
    }

    public boolean setXMLLayout(String xmllayout) {
        this.layout.setLayout(xmllayout);
        return this.setXMLLayout(this.layout);
    }

    public void setDefaultTabColor(Color defaultTabColor) {
        this.layout.setDefaultTabColor(defaultTabColor);
    }

    public void setDefaultBGColor(Color defaultBGColor) {
        this.layout.setDefaultBGColor(defaultBGColor);
    }

    public void setDefaultFont(Font defaultFont) {
        this.layout.setDefaultFont(defaultFont);
    }

    public void setComponentNameResolver(ComponentNameResolver resolver) {
        this.layout.setComponentNameResolver(resolver);
    }

    public boolean setXMLLayout(XMLLayout layout) {
        this.layout = layout;
        layout.setLayoutRoot(this);
        return this.reload();
    }

    public XMLLayout getXMLLayout() {
        return this.layout;
    }
}

