/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.dropbox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.bbop.swing.DragImageGenerator;
import org.bbop.swing.SwingUtil;
import org.bbop.swing.dropbox.DropBoxContents;
import org.bbop.swing.dropbox.DropBoxContentsTransferable;

public class DropBoxWrapper
extends JPanel
implements DropBoxContents {
    protected static final Logger logger = Logger.getLogger(DropBoxWrapper.class);
    protected Component contents;
    protected JComponent dragHandle;
    protected DragSourceListener dragListener = new DragSourceListener(){

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                // empty if block
            }
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    };
    protected Container startParent;
    protected DragGestureRecognizer currentRecognizer;
    protected int startIndex = -1;
    protected DragGestureListener dragGestureListener = new DragGestureListener(){

        public void dragGestureRecognized(DragGestureEvent dge) {
            try {
                DropBoxContentsTransferable t = new DropBoxContentsTransferable(DropBoxWrapper.this);
                dge.startDrag(DragSource.DefaultCopyNoDrop, t, DropBoxWrapper.this.dragListener);
            }
            catch (InvalidDnDOperationException e2) {
                e2.printStackTrace();
            }
        }
    };

    public DropBoxWrapper() {
        this((Component)null);
    }

    protected JComponent createDefaultDragComponent() {
        DragButton out = new DragButton("drag");
        return out;
    }

    public void setDragHandle(JComponent c) {
        DragSource ds = DragSource.getDefaultDragSource();
        if (this.dragHandle != null) {
            this.remove(this.dragHandle);
        }
        this.dragHandle = c;
        this.add((Component)this.dragHandle, "West");
        this.currentRecognizer = ds.createDefaultDragGestureRecognizer(this.dragHandle, 3, this.dragGestureListener);
        this.validate();
    }

    public JComponent getHandle() {
        return this.dragHandle;
    }

    public DropBoxWrapper(Component contents) {
        this.setLayout(new BorderLayout());
        if (contents != null) {
            this.setContents(contents);
        }
        this.dragHandle = this.createDefaultDragComponent();
    }

    public Component getContents() {
        return this.contents;
    }

    public void setContents(Component contents) {
        this.contents = contents;
        this.add(contents, "Center");
    }

    public static class DragButton
    extends JButton
    implements DragImageGenerator {
        protected static final float Y_MARGIN = 2.0f;
        protected static final float X_MARGIN = 2.0f;

        public DragButton(String text) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setMinimumSize(new Dimension(10, 0));
            this.setPreferredSize(this.getMinimumSize());
        }

        public Icon getImage(DragSourceDragEvent event) {
            return new ImageIcon(SwingUtil.getImage(this.getParent()));
        }

        protected void paintComponent(Graphics g) {
            float curveXDepth;
            float height = (float)this.getHeight() - 2.0f;
            float width = (float)this.getWidth() - 2.0f;
            Graphics2D g2 = (Graphics2D)g;
            Object oldAI = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float curveYDepth = curveXDepth = Math.min(height, width) / 3.0f;
            GeneralPath p = new GeneralPath();
            p.moveTo(curveXDepth / 2.0f + 1.0f, height + 1.0f);
            p.lineTo(width - 1.0f, height + 1.0f);
            p.lineTo(width - 1.0f, 1.0f);
            p.lineTo(width - 1.0f - curveXDepth, 1.0f);
            p.curveTo(curveXDepth / 2.0f + 1.0f, 1.0f, 1.0f, 1.0f + curveYDepth / 2.0f, 1.0f, 1.0f + curveYDepth);
            p.lineTo(1.0f, 1.0f + height - curveYDepth);
            p.curveTo(1.0f, 1.0f + height - curveYDepth / 2.0f, 1.0f + curveXDepth / 2.0f, height + 1.0f, curveXDepth + 1.0f, height + 1.0f);
            p.closePath();
            g2.setColor(this.getBackground());
            g2.fill(p);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAI);
        }
    }
}

