/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.widget;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.SwingUtil;

public class FontChooser
extends JPanel {
    protected static final Logger logger = Logger.getLogger(FontChooser.class);
    private static final long serialVersionUID = 1000072409873550558L;
    JComboBox fontList;
    JComboBox sizeList;
    JComboBox styleList;
    JLabel fontLabel = new JLabel("Name");
    JLabel sizeLabel = new JLabel("Size");
    JLabel styleLabel = new JLabel("Style");
    protected int defaultSize = 12;
    protected Vector listeners = new Vector();
    protected boolean fireEvents = true;
    protected ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FontChooser.this.handleAction();
        }
    };
    protected ListCellRenderer renderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = 2779389008687649515L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            int size = list.getFont().getSize();
            Font f = new Font((String)value, FontChooser.this.getStyleForString((String)FontChooser.this.styleList.getSelectedItem()), size);
            c.setFont(f);
            return c;
        }
    };

    public void addActionListener(ActionListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void fireActionEvent(ActionEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener listener = (ActionListener)this.listeners.elementAt(i);
            listener.actionPerformed(e);
        }
    }

    public FontChooser() {
        this(false);
    }

    public FontChooser(boolean scaleableOnly) {
        Object[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (scaleableOnly) {
            Vector<Object> allowed = new Vector<Object>();
            for (int i = 0; i < names.length; ++i) {
                Font f = new Font(names[i], 0, 10);
                if (!SwingUtil.isVectorFont(f)) continue;
                allowed.add(names[i]);
            }
            names = new String[allowed.size()];
            allowed.copyInto(names);
        }
        String[] sizes = new String[]{"8", "10", "12", "14", "18", "24", "36", "48"};
        String[] styles = new String[]{"normal", "italic", "bold", "bold-italic"};
        this.fontList = new JComboBox<Object>(names);
        this.sizeList = new JComboBox<String>(sizes);
        this.sizeList.setEditable(true);
        this.styleList = new JComboBox<String>(styles);
        Box nameBox = new Box(1);
        Box sizeBox = new Box(1);
        Box styleBox = new Box(1);
        this.fontLabel.setAlignmentX(0.0f);
        this.sizeLabel.setAlignmentX(0.0f);
        this.styleLabel.setAlignmentX(0.0f);
        this.fontList.setAlignmentX(0.0f);
        this.sizeList.setAlignmentX(0.0f);
        this.styleList.setAlignmentX(0.0f);
        nameBox.add(this.fontLabel);
        nameBox.add(this.fontList);
        sizeBox.add(this.sizeLabel);
        sizeBox.add(this.sizeList);
        styleBox.add(this.styleLabel);
        styleBox.add(this.styleList);
        this.add(nameBox);
        this.add(sizeBox);
        this.add(styleBox);
        this.fontList.setRenderer(this.renderer);
        this.fontList.addActionListener(this.actionListener);
        this.sizeList.addActionListener(this.actionListener);
        this.styleList.addActionListener(this.actionListener);
        this.setFontListFont();
    }

    public void setDefaultFontSize(int size) {
        this.defaultSize = size;
    }

    public int getDefaultFontSize() {
        return this.defaultSize;
    }

    protected void setFontListFont() {
        int size = this.getFont().getSize();
        Font f = new Font((String)this.fontList.getSelectedItem(), this.getStyleForString((String)this.styleList.getSelectedItem()), size);
        this.fontList.setFont(f);
    }

    protected void handleAction() {
        this.verify();
        this.setFontListFont();
        if (this.fireEvents) {
            this.fireActionEvent(new ActionEvent(this, 1201, "FontChosen"));
        }
    }

    protected void verify() {
        try {
            int size = Integer.parseInt((String)this.sizeList.getSelectedItem());
        }
        catch (Exception e) {
            this.selectOrAddFontSize(this.defaultSize);
        }
    }

    protected void selectOrAddFontSize(int newSize) {
        for (int i = 0; i < this.sizeList.getItemCount(); ++i) {
            String size = (String)this.sizeList.getItemAt(i);
            int sizeInt = -1;
            try {
                sizeInt = Integer.parseInt(size);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            if (sizeInt == newSize) break;
            if (sizeInt <= newSize) continue;
            this.styleList.insertItemAt(newSize + "", i);
        }
        this.sizeList.setSelectedItem(newSize + "");
    }

    protected String getStringForStyle(int style) {
        if (style == 3) {
            return "bold-italic";
        }
        if (style == 1) {
            return "bold";
        }
        if (style == 2) {
            return "italic";
        }
        return "normal";
    }

    protected int getStyleForString(String styleName) {
        int style = 0;
        if (styleName.equals("bold")) {
            style = 1;
        } else if (styleName.equals("italic")) {
            style = 2;
        } else if (styleName.equals("bold-italic")) {
            style = 3;
        }
        return style;
    }

    public void setChosenFont(Font font) {
        this.fireEvents = false;
        this.fontList.setSelectedItem(font.getFamily());
        this.styleList.setSelectedItem(this.getStringForStyle(font.getStyle()));
        this.selectOrAddFontSize(font.getSize());
        this.fireEvents = true;
    }

    public Font getChosenFont() {
        int style = this.getStyleForString((String)this.styleList.getSelectedItem());
        int size = this.defaultSize;
        try {
            size = Integer.parseInt((String)this.sizeList.getSelectedItem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font((String)this.fontList.getSelectedItem(), style, size);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.sizeList != null) {
            this.sizeList.setFont(font);
        }
        if (this.styleList != null) {
            this.styleList.setFont(font);
        }
        if (this.fontLabel != null) {
            this.fontLabel.setFont(font);
        }
        if (this.sizeLabel != null) {
            this.sizeLabel.setFont(font);
        }
        if (this.styleLabel != null) {
            this.styleLabel.setFont(font);
        }
    }
}

