/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import org.apache.log4j.Logger;
import org.bbop.util.TagSpec;

public class ArgumentSpec {
    protected static final Logger logger = Logger.getLogger(ArgumentSpec.class);
    protected int cardinality;
    protected TagSpec tagSpec;
    protected String documentation;

    public ArgumentSpec(TagSpec tagSpec, int cardinality) {
        this(tagSpec, cardinality, null);
    }

    public ArgumentSpec(TagSpec tagSpec, int cardinality, String documentation) {
        this.tagSpec = tagSpec;
        this.cardinality = cardinality;
        if (documentation == null) {
            if (tagSpec != null) {
                this.documentation = tagSpec.getDocumentation();
            } else if (cardinality == -1) {
                this.documentation = "arg1 arg2 ...";
            } else {
                for (int i = 0; i < cardinality; ++i) {
                    this.documentation = this.documentation + (i > 0 ? " " : "") + "arg" + (i + 1);
                }
            }
        }
    }

    public String getDocumenation() {
        if (this.tagSpec == null) {
            return "none";
        }
        return this.tagSpec.getDocumentation();
    }

    public String getSummaryDocumentation() {
        return this.documentation;
    }

    public TagSpec getTagSpec() {
        return this.tagSpec;
    }

    public int getCardinality() {
        return this.cardinality;
    }
}

