/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bbop.util.VectorFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    protected static final Logger logger = Logger.getLogger(ClassUtil.class);

    public static List<URL> getResources(String path, String ... suffix) {
        return ClassUtil.getResources(ClassUtil.class.getClassLoader(), path, suffix);
    }

    public static List<URL> getResources(ClassLoader classLoader, String path, String ... suffix) {
        List<URL> resources;
        try {
            resources = ClassUtil.getResources(classLoader);
        }
        catch (MalformedURLException e) {
            resources = new ArrayList<URL>();
        }
        catch (IOException e) {
            resources = new ArrayList<URL>();
        }
        Iterator<URL> it = resources.iterator();
        String regexp = path.replaceAll("\\*\\*", ".`").replaceAll("\\*", "[^/]`").replace('`', '*');
        Pattern p = Pattern.compile(regexp);
        while (it.hasNext()) {
            URL url = it.next();
            String upath = ClassUtil.getFilePath(url);
            File file = new File(upath);
            String filePath = file.getPath();
            Matcher m = p.matcher(filePath = filePath.replace("\\", "/"));
            if (!m.matches()) {
                it.remove();
                continue;
            }
            boolean matches = suffix.length == 0;
            for (String s : suffix) {
                if (!file.getName().endsWith(s)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            it.remove();
        }
        return resources;
    }

    public static String getFilePath(URL url) {
        if (url.getProtocol().equals("jar")) {
            String urlStr = url.toString();
            int excIndex = urlStr.indexOf(33);
            if (excIndex >= 0) {
                return urlStr.substring(excIndex + 1, urlStr.length());
            }
        } else if (url.getProtocol().equals("file")) {
            return url.getPath();
        }
        return null;
    }

    public static List<URL> getResources(VectorFilter<URL> filter) {
        List<URL> resources = ClassUtil.getResources();
        Iterator<URL> it = resources.iterator();
        while (it.hasNext()) {
            URL url = it.next();
            if (filter.satisfies(url)) continue;
            it.remove();
        }
        return resources;
    }

    public static List<URL> getResources() {
        try {
            return ClassUtil.getResources(ClassUtil.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<URL> getResources(ClassLoader cl) throws IOException, MalformedURLException {
        ArrayList<URL> resources = new ArrayList<URL>();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)cl;
                URL[] urls = ucl.getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    File file;
                    URL url = urls[i];
                    if (url.getFile().endsWith(".jar")) {
                        ClassUtil.listJarResources(new URL("jar:" + url.toExternalForm() + "!/"), resources);
                        continue;
                    }
                    if (!url.getProtocol().equals("file") || !(file = new File(url.getFile())).isDirectory()) continue;
                    ClassUtil.listDirResources(file, resources);
                }
            }
            cl = cl.getParent();
        }
        return resources;
    }

    protected static void listDirResources(File dir, List<URL> resources) throws MalformedURLException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            resources.add(file.toURL());
            if (!file.isDirectory()) continue;
            ClassUtil.listDirResources(file, resources);
        }
    }

    protected static void listJarResources(URL jarUrl, List<URL> resources) throws IOException, MalformedURLException {
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            resources.add(new URL(jarUrl, entry.getName()));
        }
    }

    protected static String readAFewChars(URL url) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer(10);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        for (int i = 0; i < 10 && (c = ((Reader)reader).read()) != -1; ++i) {
            buf.append((char)c);
        }
        ((Reader)reader).close();
        return buf.toString();
    }
}

