/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FixedMap
implements Map {
    protected static final Logger logger = Logger.getLogger(FixedMap.class);
    protected HashMap map = new HashMap();
    protected LinkedList keyList = new LinkedList();
    protected int maxSize;

    public FixedMap() {
        this(20);
    }

    public FixedMap(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public FixedMap(Map values) {
        this(values, 20);
    }

    public FixedMap(Map values, int maxSize) {
        this.setMaxSize(maxSize);
        this.putAll(values);
    }

    public void setMaxSize(int newSize) {
        for (int i = 0; i < this.maxSize - newSize && i < this.keyList.size(); ++i) {
            this.map.remove(this.keyList.removeLast());
        }
        this.maxSize = newSize;
    }

    public boolean containsKey(Object key) {
        this.keyList.remove(key);
        this.keyList.addFirst(key);
        return this.map.containsKey(key);
    }

    public Object get(Object key) {
        this.keyList.remove(key);
        this.keyList.addFirst(key);
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.keyList.remove(key);
        this.keyList.addFirst(key);
        if (this.keyList.size() > this.maxSize) {
            for (int i = 0; i < this.keyList.size() - this.maxSize; ++i) {
                Object discard = this.keyList.removeLast();
                this.map.remove(discard);
            }
        }
        return this.map.put(key, value);
    }

    public Object remove(Object key) {
        this.keyList.remove(key);
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public void putAll(Map t) {
        Set s = t.keySet();
        for (Object key : s) {
            this.put(key, t.get(key));
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

