/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.ImprovedHashMap;
import org.bbop.util.ImprovedMap;
import org.bbop.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHashMap<K, V>
implements MultiMap<K, V> {
    protected static final Logger logger = Logger.getLogger(MultiHashMap.class);
    protected ImprovedMap<K, Collection<V>> map = new ImprovedHashMap<K, Collection<V>>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsSingleValue(Object value) {
        return this.singleValues().contains(value);
    }

    @Override
    public Collection<V> singleValues() {
        Collection<V> out = this.createCollection();
        for (Collection<V> values : this.values()) {
            out.addAll(values);
        }
        return out;
    }

    @Override
    public K getKey(Object key) {
        return this.map.getKey(key);
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public Collection<V> get(Object key) {
        Collection<V> out = (Collection<V>)this.map.get(key);
        if (out == null) {
            out = this.createEmptyCollection();
        }
        return out;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V add(K key, V value) {
        Collection<V> vals = (Collection<V>)this.map.get(key);
        if (vals == null) {
            vals = this.createCollection();
            this.map.put(key, vals);
        }
        vals.add(value);
        return value;
    }

    @Override
    public V remove(K key, V value) {
        Collection vals = (Collection)this.map.get(key);
        if (vals != null) {
            vals.remove(value);
            if (vals.size() == 0) {
                this.map.remove(key);
            }
        }
        return value;
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public Collection<V> remove(Object key) {
        return (Collection)this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> t) {
        this.map.putAll(t);
    }

    public String toString() {
        return this.map.toString();
    }
}

