/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class MultiIterator
implements Iterator {
    protected static final Logger logger = Logger.getLogger(MultiIterator.class);
    protected List iterators = new LinkedList();

    public void addIterator(Iterator it) {
        this.iterators.add(it);
    }

    public boolean hasNext() {
        if (this.iterators.size() == 0) {
            return false;
        }
        Iterator it = this.iterators.iterator();
        while (it.hasNext()) {
            Iterator current = (Iterator)it.next();
            if (current.hasNext()) {
                return true;
            }
            it.remove();
        }
        return false;
    }

    public Object next() {
        if (this.iterators.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator it = this.iterators.iterator();
        while (it.hasNext()) {
            Iterator current = (Iterator)it.next();
            if (current.hasNext()) {
                return current.next();
            }
            it.remove();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException("Multi-iterators are read only");
    }

    public static void main(String[] args) {
        LinkedList<String> a = new LinkedList<String>();
        LinkedList<String> b = new LinkedList<String>();
        a.add("do");
        a.add("re");
        a.add("mi");
        a.add("fa");
        b.add("so");
        b.add("la");
        b.add("ti");
        b.add("do");
        MultiIterator it = new MultiIterator();
        it.addIterator(a.iterator());
        it.addIterator(b.iterator());
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

