/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.util.ReferenceCleanupEvent;
import org.bbop.util.ReferenceCleanupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQueueCleanupThread<T>
extends Thread
implements Cloneable {
    protected static final Logger logger = Logger.getLogger(ReferenceQueueCleanupThread.class);
    protected boolean halt = false;
    protected ReferenceQueue<T> queue;
    protected Collection<ReferenceCleanupListener> listeners;

    public ReferenceQueueCleanupThread(ReferenceQueue<T> queue) {
        this.queue = queue;
    }

    public void addCleanupListener(ReferenceCleanupListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<ReferenceCleanupListener>();
        }
        this.listeners.add(listener);
    }

    public void removeCleanupListener(ReferenceCleanupListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    protected void fireCleanup(Reference<? extends T> ref) {
        ReferenceCleanupEvent<? extends T> event = new ReferenceCleanupEvent<T>(this.queue, ref);
        for (ReferenceCleanupListener listener : this.listeners) {
            listener.cleanup(event);
        }
    }

    @Override
    public Object clone() {
        ReferenceQueueCleanupThread<T> out = new ReferenceQueueCleanupThread<T>(this.queue);
        if (this.listeners != null) {
            for (ReferenceCleanupListener listener : this.listeners) {
                out.addCleanupListener(listener);
            }
        }
        return out;
    }

    @Override
    public void run() {
        logger.info((Object)"starting cleanup thread...");
        this.halt = false;
        while (!this.halt) {
            try {
                Reference<T> r = this.queue.remove();
                logger.info((Object)("Cleaning up reference " + r));
                this.fireCleanup(r);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void halt() {
        this.halt = true;
    }
}

