/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    protected static final Logger logger = Logger.getLogger(StringUtil.class);
    public static final String LINE_BREAK = System.getProperty("line.separator");
    protected static Pattern p = Pattern.compile("[A-Za-z0-9%_\\-!.~\\\\'\\(\\)\\*,;#:\\$&\\+=\\?/\\[\\]@]*");

    public static boolean equals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        return StringUtil.unicodeIndexOf(a, b) == 0;
    }

    public static int unicodeIndexOf(String string, String findme) {
        return StringUtil.unicodeIndexOf(string, findme, 0);
    }

    public static int[] getWordIndicesSurrounding(String str, int startIndex, int endIndex) {
        while (startIndex >= 0 && !Character.isWhitespace(str.charAt(startIndex))) {
            --startIndex;
        }
        while (endIndex < str.length() && !Character.isWhitespace(str.charAt(endIndex))) {
            ++endIndex;
        }
        int[] out = new int[]{startIndex + 1, endIndex};
        return out;
    }

    public static String getWordSurrounding(String str, int startIndex, int endIndex) {
        int[] indices = StringUtil.getWordIndicesSurrounding(str, startIndex, endIndex);
        return str.substring(indices[0], indices[1]);
    }

    public static int unicodeIndexOf(String string, String findme, int startPos) {
        RuleBasedCollator c = (RuleBasedCollator)Collator.getInstance();
        c.setDecomposition(0);
        CollationElementIterator stringIterator = c.getCollationElementIterator(string.substring(startPos));
        CollationElementIterator findmeIterator = c.getCollationElementIterator(findme);
        while (true) {
            int sc;
            int startOffset = stringIterator.getOffset();
            findmeIterator.reset();
            while (true) {
                int fc;
                sc = stringIterator.next();
                if (CollationElementIterator.primaryOrder(sc) == 0) {
                    if (CollationElementIterator.secondaryOrder(sc) > 1) continue;
                }
                do {
                    fc = findmeIterator.next();
                    if (CollationElementIterator.primaryOrder(fc) != 0) break;
                } while (CollationElementIterator.secondaryOrder(fc) > 1);
                if (fc == -1) {
                    return startOffset;
                }
                if (sc == -1) {
                    return -1;
                }
                if (CollationElementIterator.primaryOrder(fc) != CollationElementIterator.primaryOrder(sc)) break;
            }
            if (sc == -1) {
                return -1;
            }
            stringIterator.setOffset(startOffset + 1);
        }
    }

    public static int compareToIgnoreCase(String a, String b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int length = a.length();
        if (b.length() < length) {
            length = b.length();
        }
        for (int i = 0; i < length; ++i) {
            char bchar;
            char achar = Character.toUpperCase(a.charAt(i));
            if (achar < (bchar = Character.toUpperCase(b.charAt(i)))) {
                return -1;
            }
            if (achar <= bchar) continue;
            return 1;
        }
        if (a.length() < b.length()) {
            return -1;
        }
        if (a.length() > b.length()) {
            return 1;
        }
        return 0;
    }

    public static String toTitleCase(String s) {
        StringBuffer out = new StringBuffer();
        char last = ' ';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(last)) {
                out.append(Character.toTitleCase(c));
            } else {
                out.append(c);
            }
            last = c;
        }
        return out.toString();
    }

    public static String wordToTitleCase(String s) {
        StringBuffer out = new StringBuffer();
        out.append(Character.toTitleCase(s.charAt(0)));
        out.append(s.substring(1, s.length()));
        return out.toString();
    }

    public static String pad(String s, char padChar, int size) {
        return StringUtil.pad(s, padChar, size, false);
    }

    public static String pad(String s, char padChar, int size, boolean padLeft) {
        StringBuffer out = new StringBuffer();
        if (!padLeft) {
            out.append(s);
        }
        for (int i = s.length(); i < size; ++i) {
            out.append(padChar);
        }
        if (padLeft) {
            out.append(s);
        }
        return out.toString();
    }

    public static String wrap(String text, int screenWidth) {
        return StringUtil.wrap(text, screenWidth, 0, 0, LINE_BREAK, false);
    }

    public static String wrap(String text, int screenWidth, String lineBreak) {
        return StringUtil.wrap(text, screenWidth, 0, 0, lineBreak, false);
    }

    public static String wrap(String text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        return StringUtil.wrap(new StringBuffer(text), screenWidth, firstIndent, indent, lineBreak, traceMode).toString();
    }

    public static StringBuffer wrap(StringBuffer text, int screenWidth, int firstIndent, int indent, String lineBreak, boolean traceMode) {
        if (firstIndent < 0 || indent < 0 || screenWidth < 0) {
            throw new IllegalArgumentException("Negative dimension");
        }
        int allowedCols = screenWidth - 1;
        if (allowedCols - indent < 2 || allowedCols - firstIndent < 2) {
            throw new IllegalArgumentException("Usable columns < 2");
        }
        int ln = text.length();
        int defaultNextLeft = allowedCols - indent;
        int b = 0;
        int e = 0;
        StringBuffer res = new StringBuffer((int)((double)ln * 1.2));
        int left = allowedCols - firstIndent;
        for (int i = 0; i < firstIndent; ++i) {
            res.append(' ');
        }
        StringBuffer tempb = new StringBuffer(indent + 2);
        tempb.append(lineBreak);
        for (int i = 0; i < indent; ++i) {
            tempb.append(' ');
        }
        String defaultBreakAndIndent = tempb.toString();
        boolean firstSectOfSrcLine = true;
        boolean firstWordOfSrcLine = true;
        int traceLineState = 0;
        int nextLeft = defaultNextLeft;
        String breakAndIndent = defaultBreakAndIndent;
        int wln = 0;
        while (true) {
            char c2;
            char c;
            if (e <= ln) {
                c = e != ln ? (char)text.charAt(e) : (char)' ';
                if (traceLineState > 0 && e > b) {
                    if (c == '.' && traceLineState == 1) {
                        c = ' ';
                    } else {
                        c2 = text.charAt(e - 1);
                        if (c2 == ':') {
                            c = ' ';
                        } else if (c2 == '(') {
                            traceLineState = 2;
                            c = ' ';
                        }
                    }
                }
                if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                    ++e;
                    continue;
                }
                wln = e - b;
                if (left >= wln) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    int x;
                    wln = e - b;
                    if (wln > nextLeft || firstWordOfSrcLine) {
                        int ob = b;
                        while (wln > left) {
                            if (left > 2 || left == 2 && (firstWordOfSrcLine || b != ob || nextLeft <= 2)) {
                                res.append(text.substring(b, b + left - 1));
                                res.append("-");
                                res.append(breakAndIndent);
                                wln -= left - 1;
                                b += left - 1;
                                left = nextLeft;
                                continue;
                            }
                            x = res.length() - 1;
                            if (x >= 0 && res.charAt(x) == ' ') {
                                res.delete(x, x + 1);
                            }
                            res.append(breakAndIndent);
                            left = nextLeft;
                        }
                        res.append(text.substring(b, b + wln));
                        b += wln;
                        left -= wln;
                    } else {
                        x = res.length() - 1;
                        if (x >= 0 && res.charAt(x) == ' ') {
                            res.delete(x, x + 1);
                        }
                        res.append(breakAndIndent);
                        res.append(text.substring(b, e));
                        left = nextLeft - wln;
                        b = e;
                    }
                }
                firstSectOfSrcLine = false;
                firstWordOfSrcLine = false;
            }
            int extra = 0;
            while (e < ln) {
                c = text.charAt(e);
                if (c == ' ') {
                    ++e;
                    continue;
                }
                if (c == '\t') {
                    ++e;
                    extra += 7;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    nextLeft = defaultNextLeft;
                    breakAndIndent = defaultBreakAndIndent;
                    res.append(breakAndIndent);
                    if (++e >= ln || (c2 = text.charAt(e)) != '\n' && c2 != '\r' || c != c2) {
                        // empty if block
                    }
                    left = nextLeft;
                    b = ++e;
                    firstSectOfSrcLine = true;
                    firstWordOfSrcLine = true;
                    traceLineState = 0;
                    continue;
                }
                wln = e - b + extra;
                if (firstSectOfSrcLine) {
                    int y = allowedCols - indent - wln;
                    if (traceMode && ln > e + 2 && text.charAt(e) == 'a' && text.charAt(e + 1) == 't' && text.charAt(e + 2) == ' ') {
                        if (y > 8) {
                            y -= 3;
                        }
                        traceLineState = 1;
                    }
                    if (y > 5) {
                        y = allowedCols - y;
                        nextLeft = allowedCols - y;
                        tempb = new StringBuffer(indent + 2);
                        tempb.append(lineBreak);
                        for (int i = 0; i < y; ++i) {
                            tempb.append(' ');
                        }
                        breakAndIndent = tempb.toString();
                    }
                }
                if (wln <= left) {
                    res.append(text.substring(b, e));
                    left -= wln;
                    b = e;
                } else {
                    res.append(breakAndIndent);
                    left = nextLeft;
                    b = e;
                }
                firstSectOfSrcLine = false;
                break;
            }
            if (e >= ln) break;
        }
        return res;
    }

    public static String createRandomString(int maxLength) {
        int length = (int)(Math.random() * (double)maxLength) + 1;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = (char)(97 + (int)(Math.random() * 26.0));
            out.append(c);
        }
        return out.toString();
    }

    public static String repeat(String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char c, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static Map<String, int[]> getMatchMap(String str, List<String> vals, boolean matchAll, boolean ignoreCase) {
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        LinkedList<Integer> temp = new LinkedList<Integer>();
        for (String val : vals) {
            if (ignoreCase) {
                val = val.toLowerCase();
            }
            int index = -str.length();
            while ((index = str.indexOf(val, index + str.length())) != -1) {
                temp.add(index);
            }
            if (temp.size() == 0) {
                if (!matchAll) continue;
                map.clear();
                return map;
            }
            int[] ints = new int[temp.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = (Integer)temp.removeFirst();
            }
            map.put(val, ints);
        }
        return map;
    }

    public static double score(String str, List<String> tokens, Map<String, int[]> hits) {
        return StringUtil.score(str, tokens, hits, 1.0, 2.0, 5.0, 4.0, 10.0);
    }

    public static double score(String str, List<String> tokens, Map<String, int[]> hits, double basicMatchWeight, double startMatchMultiplier, double fullMatchMultiplier, double inOrderMultiplier, double matchesAllMultiplier) {
        double score = 0.0;
        boolean matchesAll = true;
        int hitIndex = 0;
        int[] firstIndices = new int[hits.size()];
        for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            String s = tokens.get(tokenIndex);
            int[] hitIndices = hits.get(s);
            if (hitIndices == null) {
                matchesAll = false;
                continue;
            }
            for (int i = 0; i < hitIndices.length; ++i) {
                int charIndex = hitIndices[i];
                if (i == 0) {
                    firstIndices[hitIndex++] = charIndex;
                }
                score += StringUtil.getScore(str, s, charIndex, basicMatchWeight, startMatchMultiplier, fullMatchMultiplier);
            }
        }
        boolean inOrder = true;
        if (firstIndices.length > 0) {
            int lastVal = firstIndices[0];
            for (int i = 1; i < firstIndices.length; ++i) {
                if (firstIndices[i] < lastVal) {
                    inOrder = false;
                    break;
                }
                lastVal = firstIndices[i];
            }
        }
        if (inOrder) {
            score *= inOrderMultiplier;
        }
        if (matchesAll) {
            score *= matchesAllMultiplier;
        }
        return score;
    }

    protected static double getScore(String str, String token, int charIndex, double basicMatchWeight, double startMatchMultiplier, double fullMatchMultiplier) {
        double score = basicMatchWeight;
        if (charIndex == 0 || Character.isWhitespace(str.charAt(charIndex - 1))) {
            score = str.substring(charIndex, charIndex + token.length()).equals(token) ? (score *= fullMatchMultiplier) : (score *= startMatchMultiplier);
        }
        return score;
    }

    public static boolean isValidURICharacter(char c) {
        return p.matcher(c + "").matches();
    }

    public static boolean containsOnlyValidURICharacters(String s) {
        return p.matcher(s).matches();
    }

    public static boolean requals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int n = a.length();
        if (n == b.length()) {
            for (int i = n - 1; i >= 0; --i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
        }
        return true;
    }

    public static String replace(String string, String original, String replacement) {
        int index = 0;
        while ((index = string.indexOf(original, index)) != -1) {
            string = string.substring(0, index) + replacement + string.substring(index + original.length());
            index += replacement.length();
        }
        return string;
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String join(String c, String[] tokens, int p) {
        StringBuffer s = new StringBuffer();
        while (p < tokens.length) {
            s.append(tokens[p]);
            if (++p >= tokens.length) continue;
            s.append(c);
        }
        return s.toString();
    }
}

