/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.api;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.api.Rule;
import org.biopax.validator.api.ValidatorUtils;
import org.biopax.validator.api.beans.ErrorType;
import org.biopax.validator.api.beans.Validation;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRule<T>
implements Rule<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    protected ValidatorUtils utils;

    @Override
    public void error(Validation validation, Object object, String code, boolean setFixed, Object ... args) {
        if (object == null) {
            this.logger.warn((Object)"The 'thing' (the error is about) is NULL! Skipping.");
            return;
        }
        String thingId = validation.identify(object);
        args = this.parseArgs(validation, args);
        ErrorType error = this.utils != null ? this.utils.createError(thingId, code, this.getClass().getName(), validation.getProfile(), setFixed, args) : ValidatorUtils.createError(null, null, thingId, code, this.getClass().getName(), null, setFixed, args);
        validation.addError(error);
        this.logger.info((Object)((setFixed ? "FIXED " : "") + " " + code + " in " + thingId));
    }

    private String[] parseArgs(Validation v, Object ... args) {
        String[] newArgs = new String[args.length];
        int i = 0;
        for (Object a : args) {
            StringBuilder sb = new StringBuilder();
            if (a instanceof Collection) {
                for (Object o : (Collection)a) {
                    sb.append(v.identify(o)).append("; ");
                }
            } else if (a instanceof Object[]) {
                for (Object o : (Object[])a) {
                    sb.append(v.identify(o)).append("; ");
                }
            } else {
                sb.append(v.identify(a));
            }
            String s = sb.toString();
            if (s.contains("{") || s.contains("}")) {
                s.replaceAll("\\}", ")");
                s.replaceAll("\\{", "(");
            }
            newArgs[i] = s;
            ++i;
        }
        return newArgs;
    }
}

