/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.api.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.Category;
import org.biopax.validator.api.beans.ErrorCaseType;

@XmlType(name="ErrorType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ErrorType
implements Serializable,
Comparable<ErrorType> {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private final Set<ErrorCaseType> errorCase;
    @XmlAttribute
    private String code = null;
    @XmlAttribute
    private String message = null;
    @XmlAttribute
    private Behavior type = Behavior.ERROR;
    @XmlAttribute
    private Category category = Category.INFORMATION;
    @XmlAttribute
    private int notFixedCases = 0;
    @XmlAttribute
    private int totalCases = 0;

    public ErrorType() {
        this.errorCase = new TreeSet<ErrorCaseType>();
    }

    public ErrorType(String code, Behavior type) {
        this();
        this.code = code.toLowerCase();
        this.type = type;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public synchronized Collection<ErrorCaseType> getErrorCase() {
        return Collections.unmodifiableSet(this.errorCase);
    }

    public synchronized void setErrorCase(Collection<ErrorCaseType> errorCases) {
        this.errorCase.clear();
        this.errorCase.addAll(errorCases);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String newCode) {
        this.code = newCode.toLowerCase();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public synchronized void addErrorCase(ErrorCaseType newCase) {
        ErrorCaseType ect = this.findErrorCase(newCase);
        if (ect != null) {
            ect.setFixed(newCase.fixed);
            if (!newCase.fixed) {
                ect.setMessage(newCase.getMessage());
            }
        } else {
            this.errorCase.add(newCase);
        }
    }

    public void addCases(Collection<ErrorCaseType> cases) {
        for (ErrorCaseType errorCase : cases) {
            this.addErrorCase(errorCase);
        }
    }

    public synchronized void removeErrorCase(ErrorCaseType eCase) {
        this.errorCase.remove(eCase);
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ErrorType) {
            ErrorType that = (ErrorType)obj;
            return this.type.equals((Object)that.type) && this.code.equals(that.code);
        }
        return false;
    }

    public int hashCode() {
        int result = 31 + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ErrorType et) {
        return this.toString().compareToIgnoreCase(et.toString());
    }

    public Behavior getType() {
        return this.type;
    }

    public void setType(Behavior type) {
        this.type = type;
    }

    public int getTotalCases() {
        return this.totalCases;
    }

    public void setTotalCases(int n) {
        this.totalCases = n;
    }

    public int getNotFixedCases() {
        return this.notFixedCases;
    }

    public void setNotFixedCases(int n) {
        this.notFixedCases = n;
    }

    public int countErrors(String forObject, String reportedBy, boolean ignoreFixed) {
        int count = 0;
        for (ErrorCaseType ec : this.errorCase) {
            if (forObject != null && !forObject.equals(ec.getObject()) || reportedBy != null && !reportedBy.equals(ec.getReportedBy()) || ignoreFixed && ec.isFixed()) continue;
            ++count;
        }
        return count;
    }

    public synchronized ErrorCaseType findErrorCase(ErrorCaseType searchBy) {
        if (this.errorCase.contains(searchBy)) {
            for (ErrorCaseType ec : this.getErrorCase()) {
                if (!ec.equals(searchBy)) continue;
                return ec;
            }
        }
        return null;
    }
}

