/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.DataPropertyEditor;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.PropertyFilterBilinked;
import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.TraverserBilinked;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.EquivalenceGrouper;
import org.biopax.paxtools.util.Filter;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.biopax.paxtools.util.SetEquivalenceChecker;

public final class ModelUtils {
    private static final Log LOG = LogFactory.getLog(ModelUtils.class);
    static final MessageDigest MD5_DIGEST;
    private static final BioPAXFactory factory;
    private static final EditorMap em;
    private static final BioPAXIOHandler io;

    ModelUtils() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static void replace(Model model, final Map<? extends BioPAXElement, ? extends BioPAXElement> subs) {
        Visitor visitor = new Visitor(){

            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
                if (editor instanceof ObjectPropertyEditor && range != null && subs.containsKey(range)) {
                    BioPAXElement value = (BioPAXElement)range;
                    BioPAXElement replacement = (BioPAXElement)subs.get(range);
                    if (replacement != null && !editor.getRange().isInstance(replacement)) {
                        throw new IllegalBioPAXArgumentException("Incompatible type! Attempted to replace " + value.getRDFId() + " (" + value.getModelInterface().getSimpleName() + ") with " + replacement.getRDFId() + " (" + replacement.getModelInterface().getSimpleName() + "); " + "property: " + editor.getProperty() + " of bean: " + domain.getRDFId() + " (" + domain.getModelInterface().getSimpleName() + ")");
                    }
                    if (replacement != value) {
                        editor.removeValueFromBean(value, domain);
                        editor.setValueToBean(replacement, domain);
                    } else {
                        LOG.debug((Object)("replace: skipped the identical: " + replacement.getRDFId()));
                    }
                }
            }
        };
        Traverser traverser = new Traverser(em, visitor, new Filter[0]);
        for (BioPAXElement bpe : new HashSet<BioPAXElement>(model.getObjects())) {
            traverser.traverse(bpe, null);
        }
    }

    public static <T extends BioPAXElement> Set<T> getRootElements(Model model, final Class<T> filterClass) {
        final HashSet<T> result = new HashSet<T>(model.getObjects(filterClass));
        Traverser traverser = new Traverser(em, new Visitor(){

            @Override
            public void visit(BioPAXElement parent, Object value, Model model, PropertyEditor<?, ?> editor) {
                if (filterClass.isInstance(value)) {
                    result.remove(value);
                }
            }
        }, new Filter<PropertyEditor>(){

            @Override
            public boolean filter(PropertyEditor pe) {
                return pe instanceof ObjectPropertyEditor;
            }
        });
        for (BioPAXElement e : model.getObjects()) {
            traverser.traverse(e, null);
        }
        return result;
    }

    public static <T extends BioPAXElement> Set<BioPAXElement> removeObjectsIfDangling(Model model, Class<T> clazz) {
        HashSet<BioPAXElement> removed = new HashSet<BioPAXElement>();
        if (Entity.class.equals(clazz)) {
            LOG.warn((Object)"Ignored removeObjectsIfDangling call for: Entity.class (it would delete all)");
            return removed;
        }
        if (UtilityClass.class.equals(clazz) && ModelUtils.getRootElements(model, Entity.class).isEmpty()) {
            LOG.warn((Object)"Ignored removeObjectsIfDangling call: no root entities model; UtilityClass.class");
            return removed;
        }
        Set<BioPAXElement> dangling = ModelUtils.getRootElements(model, clazz);
        if (!dangling.isEmpty()) {
            LOG.info((Object)(dangling.size() + " " + clazz.getSimpleName() + " dangling objects will be deleted..."));
            for (BioPAXElement thing : dangling) {
                model.remove(thing);
                removed.add(thing);
                LOG.debug((Object)("removed (dangling) " + thing.getRDFId() + " (" + thing.getModelInterface().getSimpleName() + ") " + thing));
            }
            removed.addAll(ModelUtils.removeObjectsIfDangling(model, clazz));
        }
        return removed;
    }

    public static Model writeRead(Model model) {
        SimpleIOHandler io = new SimpleIOHandler(model.getLevel());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        io.convertToOWL(model, baos);
        return io.convertFromOWL(new ByteArrayInputStream(baos.toByteArray()));
    }

    public static Model getDirectChildren(BioPAXElement bpe) {
        Model m = factory.createModel();
        Traverser traverser = new Traverser(em, new Visitor(){

            @Override
            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor<?, ?> editor) {
                if (range instanceof BioPAXElement && !model.containsID(((BioPAXElement)range).getRDFId())) {
                    model.add((BioPAXElement)range);
                }
            }
        }, new Filter[0]);
        traverser.traverse(bpe, m);
        return m;
    }

    public static Model getAllChildren(BioPAXElement bpe, Filter<PropertyEditor> ... filters) {
        Model m = factory.createModel();
        if (filters.length == 0) {
            new Fetcher(em, Fetcher.nextStepFilter).fetch(bpe, m);
        } else {
            new Fetcher(em, filters).fetch(bpe, m);
        }
        m.remove(bpe);
        return m;
    }

    public static Set<BioPAXElement> getDirectChildrenAsSet(BioPAXElement bpe) {
        final HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        Traverser traverser = new Traverser(em, new Visitor(){

            @Override
            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor<?, ?> editor) {
                if (range instanceof BioPAXElement) {
                    toReturn.add((BioPAXElement)range);
                }
            }
        }, new Filter[0]);
        traverser.traverse(bpe, null);
        return toReturn;
    }

    public static Map<Class<? extends BioPAXElement>, Integer> generateClassMetrics(Model model) {
        HashMap<Class<? extends BioPAXElement>, Integer> metrics = new HashMap<Class<? extends BioPAXElement>, Integer>();
        for (BioPAXElement bpe : model.getObjects()) {
            Integer count = (Integer)metrics.get(bpe.getModelInterface());
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            metrics.put(bpe.getModelInterface(), count);
        }
        return metrics;
    }

    public static <T extends BioPAXElement> T getObject(Model model, String uri, Class<T> clazz) {
        BioPAXElement bpe = model.getByID(uri);
        if (clazz.isInstance(bpe)) {
            return (T)bpe;
        }
        return null;
    }

    public static String md5hex(String id) {
        byte[] digest = MD5_DIGEST.digest(id.getBytes());
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
        }
        String hex = sb.toString();
        return hex;
    }

    public static void fixDanglingObjectProperties(BioPAXElement bpe, Model model) {
        Visitor visitor = new Visitor(){

            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
                BioPAXElement value;
                if (editor instanceof ObjectPropertyEditor && (value = (BioPAXElement)range) != null && !model.containsID(value.getRDFId())) {
                    editor.removeValueFromBean(value, domain);
                }
            }
        };
        Traverser traverser = new Traverser(em, visitor, new Filter[0]);
        traverser.traverse(bpe, model);
    }

    public static void fixDanglingInverseProperties(BioPAXElement bpe, Model model) {
        Visitor visitor = new Visitor(){

            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
                BioPAXElement value = (BioPAXElement)range;
                if (value != null && !model.containsID(value.getRDFId())) {
                    editor.removeValueFromBean(domain, value);
                }
            }
        };
        TraverserBilinked traverser = new TraverserBilinked(em, visitor, new PropertyFilterBilinked[0]);
        traverser.setInverseOnly(true);
        traverser.traverse(bpe, model);
    }

    public static Set<EntityFeature> getFeatureIntersection(PhysicalEntity first, FeatureType firstClass, PhysicalEntity second, FeatureType secondClass) {
        Set<EntityFeature> intersection = ModelUtils.getFeatureSetByType(first, firstClass);
        intersection.removeAll(ModelUtils.getFeatureSetByType(second, secondClass));
        return intersection;
    }

    public static Set<EntityFeature> getFeatureSetByType(PhysicalEntity pe, FeatureType type) {
        HashSet<EntityFeature> modifiableSet = new HashSet<EntityFeature>();
        switch (type) {
            case FEATURE: {
                modifiableSet.addAll(pe.getFeature());
                break;
            }
            case NOT_FEATURE: {
                modifiableSet.addAll(pe.getNotFeature());
                break;
            }
            case UNKNOWN_FEATURE: {
                if (!(pe instanceof SimplePhysicalEntity)) break;
                modifiableSet.addAll(((SimplePhysicalEntity)pe).getEntityReference().getEntityFeature());
                modifiableSet.removeAll(pe.getFeature());
                modifiableSet.removeAll(pe.getNotFeature());
            }
        }
        return modifiableSet;
    }

    public static boolean checkERFeatureSet(EntityReference er, boolean fix) {
        boolean check = true;
        for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
            for (EntityFeature ef : spe.getFeature()) {
                check = ModelUtils.scanAndAddToFeatureSet(er, fix, check, ef);
                if (fix || check) continue;
                return check;
            }
            for (EntityFeature ef : spe.getNotFeature()) {
                check = ModelUtils.scanAndAddToFeatureSet(er, fix, check, ef);
                if (fix || check) continue;
                return check;
            }
        }
        return check;
    }

    private static boolean scanAndAddToFeatureSet(EntityReference er, boolean fix, boolean check, EntityFeature ef) {
        if (!er.getEntityFeature().contains(ef)) {
            check = false;
            if (fix) {
                er.addEntityFeature(ef);
            }
        }
        return check;
    }

    public static Set<EntityFeature> findFeaturesAddedToSecond(PhysicalEntity first, PhysicalEntity second, boolean fix) {
        if (ModelUtils.checkCommonEntityReferenceForTwoPEs(first, second, fix)) {
            return null;
        }
        Set<EntityFeature> explicit = ModelUtils.getFeatureIntersection(first, FeatureType.NOT_FEATURE, second, FeatureType.FEATURE);
        Set<EntityFeature> implicit = ModelUtils.getFeatureIntersection(first, FeatureType.UNKNOWN_FEATURE, second, FeatureType.FEATURE);
        Set<EntityFeature> negativeImplicit = ModelUtils.getFeatureIntersection(first, FeatureType.NOT_FEATURE, second, FeatureType.UNKNOWN_FEATURE);
        if (fix) {
            for (EntityFeature implied : implicit) {
                LOG.info((Object)("The feature " + implied + "implied as a not-feature of " + first + ". " + "Adding it to the not-feature list"));
                first.addNotFeature(implied);
            }
            for (EntityFeature implied : negativeImplicit) {
                LOG.info((Object)("The feature " + implied + "implied as a feature of " + second + ". " + "Adding it to the feature list"));
                second.addFeature(implied);
            }
        }
        explicit.retainAll(implicit);
        explicit.retainAll(negativeImplicit);
        return explicit;
    }

    private static boolean checkCommonEntityReferenceForTwoPEs(PhysicalEntity first, PhysicalEntity second, boolean fix) {
        if (first instanceof SimplePhysicalEntity) {
            EntityReference er = ((SimplePhysicalEntity)first).getEntityReference();
            if (!er.getEntityReferenceOf().contains(second)) {
                LOG.warn((Object)"These two physicalEntities do not share an EntityReference. They can not be compared! Skipping");
                return false;
            }
            if (!ModelUtils.checkERFeatureSet(er, fix)) {
                LOG.warn((Object)"ER feature set is incomplete!");
                if (!fix) {
                    LOG.warn((Object)"fixing...");
                } else {
                    LOG.warn((Object)"skipping");
                    return false;
                }
            }
            return true;
        }
        LOG.warn((Object)"These two physicalEntities do not share an EntityReference. They can not be compared! Skipping");
        return false;
    }

    public static void normalizeGenerics(Model model) {
        HashMap<Set<EntityReference>, EntityReference> memberMap = new HashMap<Set<EntityReference>, EntityReference>();
        Set<SimplePhysicalEntity> pes = model.getObjects(SimplePhysicalEntity.class);
        HashSet<SimplePhysicalEntity> pesToBeNormalized = new HashSet<SimplePhysicalEntity>();
        for (SimplePhysicalEntity pe : pes) {
            if (pe.getEntityReference() != null || pe.getMemberPhysicalEntity().isEmpty()) continue;
            pesToBeNormalized.add(pe);
        }
        for (SimplePhysicalEntity pe : pesToBeNormalized) {
            try {
                ModelUtils.createNewERandAddMembers(model, pe, memberMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void createNewERandAddMembers(Model model, SimplePhysicalEntity pe, HashMap<Set<EntityReference>, EntityReference> memberMap) {
        EntityReference firstEntityReference;
        SimplePhysicalEntity first = (SimplePhysicalEntity)pe.getMemberPhysicalEntity().iterator().next();
        Set<EntityReference> members = pe.getGenericEntityReferences();
        EntityReference er = memberMap.get(members);
        if (er == null && (firstEntityReference = first.getEntityReference()) != null) {
            String syntheticId = model.getXmlBase() + ModelUtils.md5hex(pe.getRDFId());
            er = (EntityReference)model.addNew(firstEntityReference.getModelInterface(), syntheticId);
            ModelUtils.copySimplePointers(model, pe, er);
            er.addComment("auto-generated by Paxtools from generic " + pe.getModelInterface().getSimpleName() + ", uri=" + pe.getRDFId() + "");
            for (EntityReference member : members) {
                er.addMemberEntityReference(member);
            }
            memberMap.put(members, er);
        }
        pe.setEntityReference(er);
    }

    public static void copySimplePointers(Model model, Named source, Named target) {
        target.setDisplayName(source.getDisplayName());
        target.setStandardName(source.getStandardName());
        for (String name : source.getName()) {
            target.addName(name);
        }
        for (Xref xref2 : source.getXref()) {
            if (xref2 instanceof UnificationXref) {
                String id = model.getXmlBase() + ModelUtils.md5hex(xref2.getDb() + xref2.getRDFId());
                Xref byID = (Xref)model.getByID(id);
                if (byID == null) {
                    RelationshipXref rref = model.addNew(RelationshipXref.class, id);
                    rref.setDb(xref2.getDb());
                    rref.setId(xref2.getId());
                    rref.setDbVersion(xref2.getDbVersion());
                    rref.setIdVersion(xref2.getDbVersion());
                    xref2 = rref;
                } else {
                    xref2 = byID;
                }
            }
            target.addXref(xref2);
        }
    }

    public static void resolveFeatures(Model model) {
        if (!model.getLevel().equals((Object)BioPAXLevel.L3)) {
            throw new UnsupportedOperationException("resolveFeatures method does not work with " + (Object)((Object)model.getLevel()));
        }
        ModelUtils.resolveBindingFeatures(model);
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                for (Interaction interaction2 : spe.getParticipantOf()) {
                    Conversion cnv;
                    if (!(interaction2 instanceof Conversion) || !(cnv = (Conversion)interaction2).getLeft().contains(spe)) continue;
                    for (PhysicalEntity physicalEntity2 : cnv.getRight()) {
                        SimplePhysicalEntity otherSPE;
                        if (!(physicalEntity2 instanceof SimplePhysicalEntity) || !(otherSPE = (SimplePhysicalEntity)physicalEntity2).getEntityReference().equals(spe.getEntityReference())) continue;
                        Set<EntityFeature> added = ModelUtils.findFeaturesAddedToSecond(physicalEntity2, otherSPE, true);
                        Set<EntityFeature> set = ModelUtils.findFeaturesAddedToSecond(otherSPE, physicalEntity2, true);
                    }
                }
            }
        }
    }

    private static void resolveBindingFeatures(Model model) {
        ShallowCopy copier = new ShallowCopy(BioPAXLevel.L3);
        Set<Complex> complexes = model.getObjects(Complex.class);
        for (Complex complex2 : complexes) {
            ModelUtils.resolveBindingFeatures(model, complex2, copier);
        }
    }

    private static void resolveBindingFeatures(Model model, Complex complex2, ShallowCopy copier) {
        Set<PhysicalEntity> components = complex2.getComponent();
        for (PhysicalEntity component : components) {
            ModelUtils.resolveFeaturesOfComponent(model, complex2, component, copier);
        }
    }

    private static void resolveFeaturesOfComponent(Model model, Complex complex2, PhysicalEntity component, ShallowCopy copier) {
        boolean connected = false;
        Set<EntityFeature> feature = component.getFeature();
        for (EntityFeature entityFeature : feature) {
            if (!(entityFeature instanceof BindingFeature)) continue;
            BindingFeature bindsTo = ((BindingFeature)entityFeature).getBindsTo();
            Set<PhysicalEntity> featureOf = bindsTo.getFeatureOf();
            if (!SetEquivalenceChecker.hasEquivalentIntersection(complex2.getComponent(), featureOf)) {
                System.err.println("The Complex" + complex2.getName() + "(" + complex2.getRDFId() + ") has  component" + component.getDisplayName() + "(" + component.getRDFId() + ") which has" + "a binding feature (" + entityFeature.getRDFId() + "), but none of the bound " + "participants are in this complex");
                return;
            }
            connected = true;
        }
        if (!connected) {
            Set<Interaction> participantOf = component.getParticipantOf();
            for (Interaction interaction2 : participantOf) {
                if (interaction2 instanceof Control) continue;
                component = ModelUtils.createCopy(model, complex2, component, copier);
                break;
            }
            BindingFeature bindingFeature = model.addNew(BindingFeature.class, component.getRDFId() + "bond" + "in_Complex_" + complex2.getRDFId());
            component.addFeature(bindingFeature);
            if (component instanceof SimplePhysicalEntity) {
                ((SimplePhysicalEntity)component).getEntityReference().addEntityFeature(bindingFeature);
            }
        }
    }

    private static PhysicalEntity createCopy(Model model, Complex complex2, PhysicalEntity component, ShallowCopy copier) {
        complex2.removeComponent(component);
        component = copier.copy(model, component, component.getRDFId() + "in_Complex_" + complex2.getRDFId());
        complex2.addComponent(component);
        return component;
    }

    public static void replaceEquivalentFeatures(Model model) {
        EquivalenceGrouper<EntityFeature> equivalents = new EquivalenceGrouper<EntityFeature>();
        HashMap mapped = new HashMap();
        HashSet<EntityFeature> scheduled = new HashSet<EntityFeature>();
        for (EntityFeature entityFeature : model.getObjects(EntityFeature.class)) {
            if (entityFeature.getEntityFeatureOf() == null) {
                ModelUtils.inferEntityFromPE(entityFeature, entityFeature.getFeatureOf());
                if (entityFeature.getEntityFeatureOf() == null) {
                    ModelUtils.inferEntityFromPE(entityFeature, entityFeature.getNotFeatureOf());
                }
            }
            equivalents.add(entityFeature);
        }
        for (List list : equivalents.getBuckets()) {
            for (int i = 1; i < list.size(); ++i) {
                EntityFeature ef = (EntityFeature)list.get(i);
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("removing: " + ef.getRDFId() + " since it is equivalent to: " + list.get(0)));
                }
                scheduled.add(ef);
            }
        }
        for (EntityFeature entityFeature : scheduled) {
            model.remove(entityFeature);
        }
        for (PhysicalEntity physicalEntity2 : model.getObjects(PhysicalEntity.class)) {
            HashSet<EntityFeature> features = new HashSet<EntityFeature>(physicalEntity2.getFeature());
            for (EntityFeature feature : features) {
                EntityFeature that = (EntityFeature)mapped.get(feature);
                if (that == null || that.equals(feature)) continue;
                LOG.debug((Object)(" replacing " + feature + "{" + feature.getRDFId() + "} with " + that + "{" + that.getRDFId() + "}"));
                physicalEntity2.removeFeature(feature);
                physicalEntity2.addFeature(that);
            }
        }
    }

    private static void inferEntityFromPE(EntityFeature ef, Set<PhysicalEntity> pes) {
        for (PhysicalEntity physicalEntity2 : pes) {
            EntityReference er;
            if (!(physicalEntity2 instanceof SimplePhysicalEntity) || (er = ((SimplePhysicalEntity)physicalEntity2).getEntityReference()) == null) continue;
            er.addEntityFeature(ef);
            LOG.debug((Object)("Inferred the ER of " + ef.getRDFId() + " as " + er.getRDFId()));
            return;
        }
    }

    public static Set<String> getKeywords(BioPAXElement biopaxElement, int depth, Filter<DataPropertyEditor> ... dataPropertyFilters) {
        LOG.debug((Object)("getKeywords called: " + biopaxElement.getRDFId()));
        SimpleEditorMap em = SimpleEditorMap.L3;
        HashSet<String> ss = new HashSet<String>();
        HashSet<BioPAXElement> elms = depth > 0 ? new Fetcher(em, Fetcher.nextStepFilter).fetch(biopaxElement, depth) : new HashSet<BioPAXElement>();
        elms.add(biopaxElement);
        for (BioPAXElement bpe : elms) {
            Set<PropertyEditor> props = em.getEditorsOf(bpe);
            for (PropertyEditor pe : props) {
                if (pe instanceof ObjectPropertyEditor || !ModelUtils.filter((DataPropertyEditor)pe, dataPropertyFilters)) continue;
                Set values = pe.getValueFromBean(bpe);
                for (Object v : values) {
                    if (pe.isUnknown(v)) continue;
                    ss.add(v.toString());
                }
            }
        }
        return ss;
    }

    private static <T extends PropertyEditor> boolean filter(T pe, Filter<T> ... propertyFilters) {
        if (propertyFilters.length == 0) {
            return true;
        }
        for (Filter<T> pf : propertyFilters) {
            if (pf.filter(pe)) continue;
            return false;
        }
        return true;
    }

    public static Set<BioSource> getOrganisms(BioPAXElement biopaxElement) {
        HashSet<BioSource> biosources = new HashSet<BioSource>();
        if (biopaxElement == null) {
            return biosources;
        }
        LOG.debug((Object)("getOrganisms called: " + biopaxElement.getRDFId()));
        if (biopaxElement instanceof BioSource) {
            biosources.add((BioSource)biopaxElement);
        } else if (biopaxElement instanceof Pathway) {
            if (((Pathway)biopaxElement).getOrganism() != null) {
                biosources.add(((Pathway)biopaxElement).getOrganism());
            }
        } else if (biopaxElement instanceof Gene) {
            if (((Gene)biopaxElement).getOrganism() != null) {
                biosources.add(((Gene)biopaxElement).getOrganism());
            }
        } else if (biopaxElement instanceof PathwayStep) {
            Pathway pw = ((PathwayStep)biopaxElement).getPathwayOrderOf();
            if (pw != null && pw.getOrganism() != null) {
                biosources.add(pw.getOrganism());
            }
        } else if (biopaxElement instanceof Interaction || biopaxElement instanceof EntityReference || biopaxElement instanceof PhysicalEntity) {
            if (biopaxElement instanceof SequenceEntityReference && ((SequenceEntityReference)biopaxElement).getOrganism() != null) {
                biosources.add(((SequenceEntityReference)biopaxElement).getOrganism());
            }
            biosources.addAll(new Fetcher(em, Fetcher.nextStepFilter).fetch(biopaxElement, BioSource.class));
        }
        return biosources;
    }

    public static Set<Provenance> getDatasources(BioPAXElement biopaxElement) {
        HashSet<Provenance> datasources = new HashSet<Provenance>();
        if (biopaxElement == null) {
            return datasources;
        }
        LOG.debug((Object)("getDatasources called: " + biopaxElement.getRDFId()));
        if (biopaxElement instanceof Provenance) {
            datasources.add((Provenance)biopaxElement);
        } else if (biopaxElement instanceof Entity) {
            datasources.addAll(((Entity)biopaxElement).getDataSource());
        } else if (biopaxElement instanceof EntityReference) {
            for (SimplePhysicalEntity spe : ((EntityReference)biopaxElement).getEntityReferenceOf()) {
                datasources.addAll(ModelUtils.getDatasources(spe));
            }
            for (EntityReference er : ((EntityReference)biopaxElement).getMemberEntityReferenceOf()) {
                datasources.addAll(ModelUtils.getDatasources(er));
            }
        } else if (biopaxElement instanceof PathwayStep) {
            datasources.addAll(ModelUtils.getDatasources(((PathwayStep)biopaxElement).getPathwayOrderOf()));
        }
        return datasources;
    }

    public static Set<Pathway> getParentPathways(BioPAXElement biopaxElement) {
        HashSet<Pathway> pathways;
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            pathways = new HashSet<Pathway>();
                            if (biopaxElement == null) {
                                return pathways;
                            }
                            LOG.debug((Object)("getParentPathways called: " + biopaxElement.getRDFId()));
                            if (!(biopaxElement instanceof Process)) break block11;
                            if (biopaxElement instanceof Pathway) {
                                pathways.add((Pathway)biopaxElement);
                            }
                            for (Pathway pw : ((Process)biopaxElement).getPathwayComponentOf()) {
                                pathways.addAll(ModelUtils.getParentPathways(pw));
                            }
                            for (Interaction it : ((Process)biopaxElement).getParticipantOf()) {
                                pathways.addAll(ModelUtils.getParentPathways(it));
                            }
                            for (PathwayStep pt : ((Process)biopaxElement).getStepProcessOf()) {
                                pathways.addAll(ModelUtils.getParentPathways(pt));
                            }
                            break block12;
                        }
                        if (!(biopaxElement instanceof PathwayStep)) break block13;
                        pathways.addAll(ModelUtils.getParentPathways(((PathwayStep)biopaxElement).getPathwayOrderOf()));
                        break block12;
                    }
                    if (!(biopaxElement instanceof PhysicalEntity)) break block14;
                    for (PhysicalEntity pe : ((PhysicalEntity)biopaxElement).getMemberPhysicalEntityOf()) {
                        pathways.addAll(ModelUtils.getParentPathways(pe));
                    }
                    for (Interaction it : ((Entity)biopaxElement).getParticipantOf()) {
                        pathways.addAll(ModelUtils.getParentPathways(it));
                    }
                    for (Complex c : ((PhysicalEntity)biopaxElement).getComponentOf()) {
                        pathways.addAll(ModelUtils.getParentPathways(c));
                    }
                    break block12;
                }
                if (!(biopaxElement instanceof EntityReference)) break block15;
                for (EntityReference er : ((EntityReference)biopaxElement).getMemberEntityReferenceOf()) {
                    pathways.addAll(ModelUtils.getParentPathways(er));
                }
                for (SimplePhysicalEntity spe : ((EntityReference)biopaxElement).getEntityReferenceOf()) {
                    pathways.addAll(ModelUtils.getParentPathways(spe));
                }
                break block12;
            }
            if (!(biopaxElement instanceof Gene)) break block12;
            for (Interaction it : ((Entity)biopaxElement).getParticipantOf()) {
                pathways.addAll(ModelUtils.getParentPathways(it));
            }
        }
        return pathways;
    }

    public static void mergeEquivalentInteractions(Model model) {
        EquivalenceGrouper<Conversion> groups = new EquivalenceGrouper<Conversion>(model.getObjects(Conversion.class));
        for (List<Conversion> group : groups.getBuckets()) {
            if (group.size() <= 1) continue;
            HashSet<Conversion> tobeRemoved = new HashSet<Conversion>();
            Conversion primus = null;
            for (Conversion conversion2 : group) {
                if (primus == null) {
                    primus = conversion2;
                    continue;
                }
                ModelUtils.copySimplePointers(model, conversion2, primus);
                Set<Control> controlledOf = conversion2.getControlledOf();
                for (Control control2 : controlledOf) {
                    if (control2.getControlled().contains(primus)) continue;
                    control2.addControlled(primus);
                }
                Set<Pathway> owners = conversion2.getPathwayComponentOf();
                for (Pathway pathway2 : owners) {
                    if (pathway2.getPathwayComponent().contains(primus)) continue;
                    pathway2.addPathwayComponent(primus);
                }
                tobeRemoved.add(conversion2);
            }
            for (Conversion conversion2 : tobeRemoved) {
                ModelUtils.cleanAllInverse(conversion2);
                model.remove(conversion2);
            }
        }
    }

    private static void cleanAllInverse(Conversion conversion2) {
        HashSet<PhysicalEntity> concSafe = new HashSet<PhysicalEntity>(conversion2.getLeft());
        for (PhysicalEntity physicalEntity2 : concSafe) {
            conversion2.removeLeft(physicalEntity2);
        }
        concSafe = new HashSet<PhysicalEntity>(conversion2.getRight());
        for (PhysicalEntity physicalEntity3 : concSafe) {
            conversion2.removeRight(physicalEntity3);
        }
        HashSet<Control> controlledOf = new HashSet<Control>(conversion2.getControlledOf());
        for (Control control2 : controlledOf) {
            control2.removeControlled(conversion2);
        }
        HashSet<Pathway> hashSet = new HashSet<Pathway>(conversion2.getPathwayComponentOf());
        for (Pathway pathway2 : hashSet) {
            pathway2.removePathwayComponent(conversion2);
        }
    }

    static {
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate MD5 MessageDigest!", e);
        }
        factory = BioPAXLevel.L3.getDefaultFactory();
        em = SimpleEditorMap.L3;
        io = new SimpleIOHandler(BioPAXLevel.L3);
        ((SimpleIOHandler)io).mergeDuplicates(true);
        ((SimpleIOHandler)io).normalizeNameSpaces(false);
    }

    static enum FeatureType {
        FEATURE,
        NOT_FEATURE,
        UNKNOWN_FEATURE;

    }
}

