/*
 * Decompiled with CFR 0.152.
 */
package org.obo.annotation.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.obo.annotation.datamodel.Annotation;
import org.obo.annotation.datamodel.AnnotationOntology;
import org.obo.annotation.datamodel.impl.AnnotationImpl;
import org.obo.dataadapter.DefaultOBOParser;
import org.obo.dataadapter.OBOConstants;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBOSerializerExtension;
import org.obo.dataadapter.OBO_1_2_Serializer;
import org.obo.dataadapter.ParseEngine;
import org.obo.dataadapter.ParserExtension;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;
import org.obo.util.IDUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParserExtension
implements ParserExtension,
OBOSerializerExtension {
    protected static final Logger logger = Logger.getLogger(AnnotationParserExtension.class);
    protected OBOSession session;
    protected ParseEngine engine;
    protected OBOSerializationEngine sengine;
    protected boolean inAnnotationStanza;
    protected DefaultOBOParser parser;
    protected IdentifiedObject currentObject;
    protected Collection<Annotation> annotations = new LinkedList<Annotation>();
    protected String currentPath;
    protected PrintStream stream;
    protected OBOSerializer serializer;
    protected Annotation currentAnnotation;
    protected static final OBOConstants.TagMapping ASSIGNED_BY_TAG = new OBOConstants.TagMapping("assigned_by", null, null);
    protected static final OBOConstants.TagMapping SUBJECT_TAG = new OBOConstants.TagMapping("subject", null, null);
    protected static final OBOConstants.TagMapping RELATIONSHIP_TAG = new OBOConstants.TagMapping("relation", null, null);
    protected static final OBOConstants.TagMapping OBJECT_TAG = new OBOConstants.TagMapping("object", null, null);
    protected static final OBOConstants.TagMapping EVIDENCE_TAG = new OBOConstants.TagMapping("evidence", null, null);
    protected static final OBOConstants.TagMapping DESCRIPTION_TAG = new OBOConstants.TagMapping("description", null, null);
    protected static final OBOConstants.TagMapping CONTEXT_TAG = new OBOConstants.TagMapping("context", null, null);
    protected static final OBOConstants.TagMapping SOURCE_TAG = new OBOConstants.TagMapping("source", null, null);

    @Override
    public String mapID(String id) {
        return null;
    }

    public static void main(String[] args) throws Exception {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add("/home/jrichter/downloads/ontology/pheno-obd.annotation-obo");
        config.getReadPaths().add("/home/jrichter/downloads/ontology/quality.obo");
        config.setBasicSave(false);
        config.setAllowDangling(true);
        OBOSession session = (OBOSession)adapter.doOperation(OBOFileAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        session.importSession(AnnotationOntology.getSession(), true);
        OBOSerializationEngine sengine = new OBOSerializationEngine();
        sengine.serialize(session, (OBOSerializer)new OBO_1_2_Serializer(), "/home/jrichter/test_instances.obo");
        sengine.addSerializerExtension(new AnnotationParserExtension());
        sengine.serialize(session, (OBOSerializer)new OBO_1_2_Serializer(), "/home/jrichter/test_annotations.obo");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endParse() throws OBOParseException {
        this.parser.setAllowDanglingParents(true);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof Annotation)) continue;
            annotations.add((Annotation)io);
        }
        for (Annotation annotation : annotations) {
            Iterator<PropertyValue> it = annotation.getPropertyValues().iterator();
            while (it.hasNext()) {
                IdentifiedObject object;
                PropertyValue pv = it.next();
                if (pv.getProperty().equals(SOURCE_TAG.getName())) {
                    IdentifiedObject source = this.parser.getObject(pv.getValue());
                    if (source == null) {
                        source = this.session.getObjectFactory().createDanglingObject(pv.getValue(), false);
                        source = TermUtil.castToInstance((LinkedObject)source);
                        ((Instance)source).setType(AnnotationOntology.PUBLICATION());
                    }
                    annotation.addSource((LinkedObject)source);
                    it.remove();
                    continue;
                }
                if (pv.getProperty().equals(ASSIGNED_BY_TAG.getName())) {
                    IdentifiedObject ab = this.parser.getObject(pv.getValue());
                    if (ab == null) {
                        ab = this.session.getObjectFactory().createDanglingObject(pv.getValue(), false);
                        ab = TermUtil.castToInstance((LinkedObject)ab);
                        ((Instance)ab).setType(AnnotationOntology.AGENT());
                    }
                    annotation.setAssignedBy((LinkedObject)ab);
                    continue;
                }
                if (pv.getProperty().equals(DESCRIPTION_TAG.getName())) {
                    annotation.addDescription(pv.getValue());
                    it.remove();
                    continue;
                }
                if (pv.getProperty().equals(SUBJECT_TAG.getName())) {
                    IdentifiedObject subject = this.parser.getObject(pv.getValue());
                    if (subject == null) {
                        if (!this.parser.getAllowDanglingParents()) throw new OBOParseException("Unknown subject ID " + pv.getValue() + " in annotation " + annotation.getID(), this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                        subject = new DanglingObjectImpl(pv.getValue());
                    } else if (!(subject instanceof LinkedObject)) {
                        throw new OBOParseException("Subject " + pv.getValue() + " in annotation " + annotation.getID() + " is a " + subject.getClass() + " not a LinkedObject", this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                    }
                    annotation.setSubject((LinkedObject)subject);
                    it.remove();
                    continue;
                }
                if (pv.getProperty().equals(OBJECT_TAG.getName())) {
                    object = this.parser.getObject(pv.getValue());
                    if (object == null) {
                        if (!this.parser.getAllowDanglingParents()) throw new OBOParseException("Unknown object ID " + pv.getValue() + " in annotation " + annotation.getID(), this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                        object = new DanglingObjectImpl(pv.getValue());
                    } else if (!(object instanceof LinkedObject)) {
                        throw new OBOParseException("Object " + pv.getValue() + " in annotation " + annotation.getID() + " is not a LinkedObject", this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                    }
                    annotation.setObject((LinkedObject)object);
                    it.remove();
                    continue;
                }
                if (pv.getProperty().equals(RELATIONSHIP_TAG.getName())) {
                    object = this.parser.getObject(pv.getValue());
                    if (object == null) {
                        if (!this.parser.getAllowDanglingParents()) throw new OBOParseException("Unknown object ID " + pv.getValue() + " in annotation " + annotation.getID(), this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                        object = new DanglingPropertyImpl(pv.getValue());
                    } else if (!(object instanceof OBOProperty)) {
                        throw new OBOParseException("Object " + pv.getValue() + " in annotation " + annotation.getID() + " is not an OBOProperty", this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                    }
                    annotation.setRelationship((OBOProperty)object);
                    it.remove();
                    continue;
                }
                if (!pv.getProperty().equals(EVIDENCE_TAG.getName())) continue;
                object = this.parser.getObject(pv.getValue());
                if (object == null) {
                    if (!this.parser.getAllowDanglingParents()) throw new OBOParseException("Unknown object ID " + pv.getValue() + " in annotation " + annotation.getID(), this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                    object = new DanglingPropertyImpl(pv.getValue());
                } else if (!(object instanceof LinkedObject)) {
                    throw new OBOParseException("Object " + pv.getValue() + " in annotation " + annotation.getID() + " is not a LinkedObject", this.currentPath, this.engine.getCurrentLine(), this.engine.getLineNum());
                }
                annotation.addEvidence((LinkedObject)object);
                it.remove();
            }
        }
    }

    @Override
    public boolean readTagValue(String tag, String value, NestedValue nv, boolean handled) throws OBOParseException {
        if (this.inAnnotationStanza) {
            if (tag.equals("id")) {
                String id = this.parser.mapID(value);
                this.currentObject = this.fetchObject(id, nv);
                return true;
            }
            if (!this.engine.getReadIDForCurrentBlock()) {
                this.currentObject = this.fetchObject(IDUtil.fetchTemporaryID(this.session), nv);
                this.currentObject.setIsAnonymous(true);
            }
        }
        return false;
    }

    public IdentifiedObject fetchObject(String id, NestedValue nv) {
        this.engine.setReadIDForCurrentBlock(true);
        IdentifiedObject currentObject = this.parser.fetchObject(id);
        currentObject.setName(id);
        currentObject.setIDExtension(nv);
        this.session.addObject(currentObject);
        this.annotations.add((Annotation)currentObject);
        this.parser.setCurrentObject(currentObject);
        return currentObject;
    }

    @Override
    public IdentifiedObject createObject(String stanza, String id) {
        if (stanza.equalsIgnoreCase("annotation")) {
            return new AnnotationImpl(id);
        }
        return null;
    }

    @Override
    public boolean startStanza(String name) throws OBOParseException {
        this.inAnnotationStanza = name.equalsIgnoreCase("annotation");
        return this.inAnnotationStanza;
    }

    @Override
    public void setParseEngine(ParseEngine engine) {
        this.engine = engine;
    }

    @Override
    public void setSession(OBOSession session) {
        this.session = session;
    }

    @Override
    public void cancel() {
        this.session = null;
    }

    @Override
    public void startParse() throws OBOParseException {
        this.inAnnotationStanza = false;
    }

    @Override
    public void endFileParse(String uri) throws OBOParseException {
    }

    @Override
    public void readBangComment(String comment) throws OBOParseException {
    }

    @Override
    public void startFileParse(String uri) throws OBOParseException {
        this.currentPath = uri;
    }

    @Override
    public void startSerialize() throws IOException {
    }

    @Override
    public void setParser(DefaultOBOParser parser) {
        this.parser = parser;
    }

    @Override
    public void endSerialize() throws IOException {
    }

    @Override
    public void setOutputStream(PrintStream stream) throws IOException {
        this.stream = stream;
    }

    @Override
    public void setSerializer(OBOSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public String mapIDforWrite(IdentifiedObject io, String id) {
        return null;
    }

    @Override
    public boolean writeObject(LinkDatabase linkDatabase, IdentifiedObject obj) throws IOException {
        return false;
    }

    @Override
    public void changeHeaderTagOrder(List headerTagOrder) {
    }

    @Override
    public void changeStanzaOrder(List stanzaOrder) {
    }

    @Override
    public void changeTagOrder(List<OBOConstants.TagMapping> tagOrder) {
        OBOConstants.TagMapping mapping;
        int index = -1;
        Iterator<OBOConstants.TagMapping> it = tagOrder.iterator();
        index = 0;
        while (it.hasNext() && !(mapping = it.next()).equals(OBOConstants.ALT_ID_TAG)) {
            ++index;
        }
        int n = ++index;
        tagOrder.add(n, ASSIGNED_BY_TAG);
        int n2 = ++index;
        tagOrder.add(n2, SUBJECT_TAG);
        int n3 = ++index;
        tagOrder.add(n3, RELATIONSHIP_TAG);
        int n4 = ++index;
        tagOrder.add(n4, OBJECT_TAG);
        int n5 = ++index;
        tagOrder.add(n5, DESCRIPTION_TAG);
        int n6 = ++index;
        tagOrder.add(n6, EVIDENCE_TAG);
        tagOrder.add(++index, SOURCE_TAG);
    }

    @Override
    public boolean endStanza(IdentifiedObject obj) throws IOException {
        this.currentAnnotation = null;
        return false;
    }

    @Override
    public boolean startStanza(IdentifiedObject obj) throws IOException {
        if (obj instanceof Instance && obj.getType() != null && obj.getType().equals(AnnotationOntology.ANNOTATION())) {
            Instance instance = (Instance)obj;
            this.currentAnnotation = instance instanceof Annotation ? (Annotation)instance : new AnnotationImpl(instance);
            this.stream.print("[Annotation]\n");
            return true;
        }
        return false;
    }

    @Override
    public boolean writeTag(OBOConstants.TagMapping mapping, IdentifiedObject io, LinkDatabase linkDatabase) throws IOException {
        if (this.currentAnnotation != null) {
            if (mapping.equals(ASSIGNED_BY_TAG)) {
                LinkedObject assignedBy = this.currentAnnotation.getAssignedBy();
                if (assignedBy != null) {
                    this.stream.print("assigned_by: " + assignedBy.getID() + "\n");
                }
                return true;
            }
            if (mapping.equals(SUBJECT_TAG)) {
                LinkedObject subject = this.currentAnnotation.getSubject();
                if (subject != null) {
                    this.stream.print("subject: " + this.sengine.mapID(subject) + " ! " + subject.getName() + "\n");
                }
                return true;
            }
            if (mapping.equals(RELATIONSHIP_TAG)) {
                OBOProperty rel = this.currentAnnotation.getRelationship();
                if (rel != null) {
                    this.stream.print("relation: " + this.sengine.mapID(rel) + " ! " + rel.getName() + "\n");
                }
                return true;
            }
            if (mapping.equals(OBJECT_TAG)) {
                LinkedObject object = this.currentAnnotation.getObject();
                if (object != null) {
                    this.stream.print("object: " + this.sengine.mapID(object) + " ! " + object.getName() + "\n");
                }
                return true;
            }
            if (mapping.equals(EVIDENCE_TAG)) {
                for (LinkedObject lo : this.currentAnnotation.getEvidence()) {
                    this.stream.print("evidence: " + this.sengine.mapID(lo) + "\n");
                }
                return true;
            }
            if (mapping.equals(OBOConstants.INSTANCE_OF_TAG)) {
                return true;
            }
            if (mapping.equals(SOURCE_TAG)) {
                for (LinkedObject source : this.currentAnnotation.getSources()) {
                    this.stream.print("source: " + source.getID() + "\n");
                }
                return true;
            }
            if (mapping.equals(OBOConstants.LINK_TAG) || mapping.equals(OBOConstants.VALUE_LINK_TAG)) {
                if (io instanceof LinkedObject) {
                    LinkedObject lo = (LinkedObject)io;
                    LinkedList<Link> linkList = new LinkedList<Link>();
                    linkList.addAll(linkDatabase.getParents(lo));
                    Collections.sort(linkList, OBOSerializationEngine.getLinkComparator(this.serializer));
                    for (Link l : linkList) {
                        if (l.getType().equals(AnnotationOntology.ASSIGNED_BY_REL()) || l.getType().equals(AnnotationOntology.EVIDENCE_REL()) || l.getType().equals(AnnotationOntology.POSITS_REL()) || l.getType().equals(AnnotationOntology.SOURCE_REL())) continue;
                        if (l instanceof ValueLink) {
                            if (!mapping.equals(OBOConstants.VALUE_LINK_TAG)) continue;
                            this.serializer.writeValueLinkTag((ValueLink)l, l.getNestedValue());
                            continue;
                        }
                        if (!mapping.equals(OBOConstants.LINK_TAG)) continue;
                        this.sengine.writeLink(this.serializer, l);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSerializationEngine(OBOSerializationEngine engine) {
        this.sengine = engine;
    }
}

