/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.io.IOUtil;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.annotation.dataadapter.AnnotationParserExtension;
import org.obo.dataadapter.OBOMetaData;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOParser;
import org.obo.dataadapter.ParseEngine;
import org.obo.dataadapter.ParserExtension;
import org.obo.dataadapter.PostcompParserExtension;
import org.obo.datamodel.AnnotatedObject;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.ModificationMetadataObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.UnknownStanza;
import org.obo.datamodel.Value;
import org.obo.datamodel.impl.DanglingClassImpl;
import org.obo.datamodel.impl.DatatypeValueImpl;
import org.obo.datamodel.impl.DefaultIDRule;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.NamedIDProfile;
import org.obo.datamodel.impl.NestedValueImpl;
import org.obo.datamodel.impl.PropertyValueImpl;
import org.obo.filters.CompoundFilterImpl;
import org.obo.filters.EqualsComparison;
import org.obo.filters.NamespaceSearchCriterion;
import org.obo.filters.ObjectFilterImpl;
import org.obo.filters.SelfSearchAspect;
import org.obo.identifier.IDProfile;
import org.obo.util.IDUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOBOParser
implements OBOParser {
    protected static final Logger logger = Logger.getLogger(DefaultOBOParser.class);
    protected ParseEngine engine;
    protected Set<RelStruct> linkSet;
    protected Set<String> pathSet;
    protected Set<PropertyValStruct> propertyValSet;
    protected Set<BasicMapping> considerSet;
    protected Set<BasicMapping> useSet;
    protected Map<IdentifiedObject, String> rangeMap;
    protected Map<IdentifiedObject, String> domainMap;
    protected MultiMap<IdentifiedObject, List<String>> holdsOverChainMap = new MultiHashMap();
    protected Map<String, Namespace> namespaceMap;
    protected Map<String, InstanceStruct> instanceOfHash;
    protected Map<String, String> idMapping;
    protected String idPrefix = null;
    protected Stack<Namespace> namespaceStack;
    protected Stack<String> pathStack;
    protected List<UnknownStanza> unknownStanzaList;
    protected IdentifiedObject currentObject;
    protected UnknownStanza unknownStanza;
    protected String currentStanza;
    protected OBOSession session;
    protected boolean requireSubsumption = false;
    protected boolean allowDanglingParents = true;
    protected ObjectFactory objectFactory = new DefaultObjectFactory();
    protected boolean halted = false;
    protected IDProfile currentProfile;
    protected Collection<ParserExtension> parserExtensions = new LinkedList<ParserExtension>();
    protected OBOMetaData metaData;
    protected boolean failFast = false;
    protected boolean followImports = true;
    protected boolean assignDefaultNamespaceToLinks = false;

    public DefaultOBOParser() {
        this.instanceOfHash = new HashMap<String, InstanceStruct>();
        this.idMapping = new HashMap<String, String>();
        this.propertyValSet = new HashSet<PropertyValStruct>();
        this.unknownStanzaList = new Vector<UnknownStanza>();
        this.linkSet = new HashSet<RelStruct>();
        this.pathSet = new HashSet<String>();
        this.namespaceStack = new Stack();
        this.pathStack = new Stack();
        this.namespaceMap = new HashMap<String, Namespace>();
        this.rangeMap = new HashMap<IdentifiedObject, String>();
        this.domainMap = new HashMap<IdentifiedObject, String>();
        this.considerSet = new HashSet<BasicMapping>();
        this.useSet = new HashSet<BasicMapping>();
        this.addParserExtension(new AnnotationParserExtension());
        this.addParserExtension(new PostcompParserExtension());
    }

    @Override
    public void cancel() {
        this.halted = true;
        for (ParserExtension extension : this.parserExtensions) {
            extension.cancel();
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    protected Namespace getDefaultNamespace() {
        if (this.namespaceStack == null || this.namespaceStack.empty()) {
            return null;
        }
        Namespace out = this.namespaceStack.peek();
        return out;
    }

    public void setRequireSubsumption(boolean requireSubsumption) {
        this.requireSubsumption = requireSubsumption;
    }

    public void setAllowDanglingParents(boolean allowDanglingParents) {
        this.allowDanglingParents = allowDanglingParents;
    }

    public void setFollowImports(boolean followImports) {
        this.followImports = followImports;
    }

    public boolean getAllowDanglingParents() {
        return this.allowDanglingParents;
    }

    public boolean getFollowImports() {
        return this.followImports;
    }

    public OBOSession getSession() {
        return this.session;
    }

    public void addParserExtension(ParserExtension extension) {
        this.parserExtensions.add(extension);
        extension.setParser(this);
    }

    public void removeParserExtension(ParserExtension extension) {
        this.parserExtensions.remove(extension);
        extension.setParser(null);
    }

    @Override
    public void readNamespaceIDRule(String ns, String rule) {
        if (this.currentProfile == null) {
            this.currentProfile = new NamedIDProfile("<default ID profile>");
        }
        if (ns == null) {
            this.currentProfile.setDefaultRule(rule);
        } else {
            DefaultIDRule idRule = new DefaultIDRule();
            ObjectFilterImpl filter = new ObjectFilterImpl();
            filter.setAspect(new SelfSearchAspect());
            filter.setCriterion(new NamespaceSearchCriterion());
            filter.setComparison(new EqualsComparison());
            filter.setValue(ns);
            CompoundFilterImpl cfilter = new CompoundFilterImpl();
            cfilter.addFilter(filter);
            idRule.setFilter(cfilter);
            idRule.setRule(rule);
            this.currentProfile.addRule(idRule);
        }
    }

    @Override
    public void readFormatVersion(String version) {
    }

    public String getCurrentPath() {
        return this.pathStack.peek();
    }

    @Override
    public void readImport(String path) throws IOException, OBOParseException {
        URL originalURL = IOUtil.getURL((String)this.getCurrentPath());
        try {
            URL url = new URL(originalURL, path);
            path = url.toString();
            if (!this.pathSet.contains(path)) {
                this.metaData.addImport(this.getCurrentPath(), path);
                if (this.getFollowImports()) {
                    this.engine.parse(path);
                }
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    public String mapPath(String path) {
        if (path.startsWith("obo:")) {
            String ns = path.substring(4);
            path = "http://purl.org/obo/obo-all/" + ns + "/" + ns + ".obo";
        }
        return path;
    }

    @Override
    public void readFileVersion(String version) {
        this.metaData.mapFileData(this.getCurrentPath(), version);
    }

    @Override
    public void readDate(Date date) {
        this.session.getCurrentHistory().setDate(date);
    }

    @Override
    public void readSavedBy(String savedBy) {
        this.session.getCurrentHistory().setUser(savedBy);
    }

    @Override
    public void readAutogeneratedBy(String autogeneratedBy) {
    }

    @Override
    public void readRemark(String remark) {
        remark = remark.trim();
        if (this.session.getCurrentHistory().getComment() == null) {
            this.session.getCurrentHistory().setComment(remark);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.session.getCurrentHistory().getComment(), "\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals(remark)) continue;
                return;
            }
            this.session.getCurrentHistory().setComment(this.session.getCurrentHistory().getComment() + "\n" + remark);
        }
    }

    @Override
    public void readSubsetDef(String name, String desc) {
        TermSubset cat = this.objectFactory.createSubset(name, desc);
        this.session.addSubset(cat);
    }

    @Override
    public void readSynonymCategory(String id, String name, int scope) {
        SynonymType cat = this.objectFactory.createSynonymType(id, name, scope);
        this.session.addSynonymType(cat);
    }

    public LinkedObject getLinkedObject(String id) {
        LinkedObject lo = (LinkedObject)this.getObject(id);
        if (lo == null) {
            if (this.allowDanglingParents) {
                lo = this.objectFactory.createDanglingObject(id, false);
                this.session.addObject(lo);
                logger.info((Object)("Added dangling object for " + id));
            } else {
                logger.error((Object)("dangling: " + id));
            }
        }
        return lo;
    }

    public IdentifiedObject getObject(String id) {
        IdentifiedObject io = this.session.getObject(this.mapID(id));
        return io;
    }

    protected static boolean isBuiltInID(String id) {
        for (int i = 0; i < OBOProperty.BUILTIN_TYPES.length; ++i) {
            if (!OBOProperty.BUILTIN_TYPES[i].getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String mapID(String id) {
        String newid;
        if (this.idPrefix != null && id.indexOf(58) == -1 && !DefaultOBOParser.isBuiltInID(id)) {
            id = this.idPrefix + ":" + id;
        }
        if ((newid = this.idMapping.get(id)) != null) {
            id = newid;
        }
        for (ParserExtension extension : this.parserExtensions) {
            String mangledID = extension.mapID(id);
            if (mangledID == null) continue;
            id = mangledID;
        }
        return id;
    }

    public IdentifiedObject fetchObject(String id) {
        IdentifiedObject out = this.getObject(id);
        if (out == null) {
            out = this.createObject(this.currentStanza, id);
            this.session.addObject(out);
        }
        return out;
    }

    protected IdentifiedObject createObject(String currentStanza, String id) {
        ParserExtension extension;
        IdentifiedObject out = null;
        Iterator<ParserExtension> i$ = this.parserExtensions.iterator();
        while (i$.hasNext() && (out = (extension = i$.next()).createObject(currentStanza, id)) == null) {
        }
        if (out == null) {
            if (currentStanza.equalsIgnoreCase("typedef")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_PROPERTY, false);
            } else if (currentStanza.equalsIgnoreCase("term")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_CLASS, false);
            } else if (currentStanza.equalsIgnoreCase("instance")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_INSTANCE, false);
            }
        }
        return out;
    }

    @Override
    public void readIDMapping(String originalid, String newid) throws OBOParseException {
        if (this.idMapping.containsKey(originalid) && !this.idMapping.get(originalid).equals(newid)) {
            throw new OBOParseException("Multiple mappings assigned to " + originalid, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.idMapping.put(originalid, newid);
    }

    @Override
    public void readIDPrefix(String prefix) throws OBOParseException {
        if (this.idPrefix != null && !this.idPrefix.equals(prefix)) {
            throw new OBOParseException("Multiple id-prefixes defined", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum(), 0);
        }
        this.idPrefix = prefix;
        for (IdentifiedObject io : this.session.getObjects()) {
            String convertedID = this.mapID(io.getID());
            if (convertedID.equals(io.getID())) continue;
            this.idMapping.put(convertedID, io.getID());
        }
    }

    public void setCurrentObject(IdentifiedObject currentObject) {
        this.currentObject = currentObject;
    }

    @Override
    public void readID(String id, NestedValue nv) {
        id = this.mapID(id);
        this.setCurrentObject(this.fetchObject(id));
        this.currentObject.setIDExtension(nv);
        this.session.addObject(this.currentObject);
        this.engine.setReadIDForCurrentBlock(true);
    }

    @Override
    public void readName(String name, NestedValue nv) {
        this.currentObject.setName(name);
        this.currentObject.setNameExtension(nv);
    }

    @Override
    public void readRange(String range, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set range of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.rangeMap.put(this.currentObject, range);
    }

    @Override
    public void readDomain(String domain, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set domain of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.domainMap.put(this.currentObject, domain);
    }

    @Override
    public void readHoldsOverChain(String[] ids, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Tried to specify holds_over_chain for object " + this.currentObject + " which " + "does not support this tag.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        ArrayList<String> mappedIds = new ArrayList<String>();
        for (String id : ids) {
            mappedIds.add(this.mapID(id));
        }
        this.holdsOverChainMap.add((Object)this.currentObject, mappedIds);
    }

    @Override
    public void readAltID(String id, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof MultiIDObject)) {
            throw new OBOParseException("Attempted to add secondary ID to object " + this.currentObject + " which does not support secondary " + "IDs.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((MultiIDObject)this.currentObject).addSecondaryID(id);
        if (nv != null) {
            ((MultiIDObject)this.currentObject).addSecondaryIDExtension(id, nv);
        }
    }

    @Override
    public void readComment(String comment, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof CommentedObject)) {
            throw new OBOParseException("Attempted to set comment of object " + this.currentObject + " which does not support comments.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        CommentedObject co = (CommentedObject)this.currentObject;
        String currCmt = co.getComment();
        if (currCmt != null && currCmt != "") {
            co.setComment(currCmt + "\n" + comment);
            logger.info((Object)("appending to existing comment: " + currCmt + " + " + comment));
        } else {
            co.setComment(comment);
        }
        co.setCommentExtension(nv);
    }

    @Override
    public void readInstanceOf(String termID, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof Instance)) {
            throw new OBOParseException("Attempted to set instance_of value for non-instance " + this.currentObject, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        InstanceStruct is = new InstanceStruct(termID, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        this.instanceOfHash.put(this.mapID(this.currentObject.getID()), is);
    }

    @Override
    public void readPropertyValue(String propID, String val, String typeID, boolean quoted, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof Instance)) {
            throw new OBOParseException("Attempted to set instance_of value for non-instance " + this.currentObject, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        PropertyValStruct pvs = new PropertyValStruct(this.currentObject.getID(), propID, val, typeID, nv, this.getCurrentPath(), quoted, this.engine.getCurrentLine(), this.engine.getLineNum());
        this.propertyValSet.add(pvs);
    }

    protected Synonym getSynonym(String name, OBOParser.XrefPair[] xrefs, int type, String synTypeID, NestedValue nv) throws OBOParseException {
        Synonym s = this.objectFactory.createSynonym(name, type);
        s.setNestedValue(nv);
        if (synTypeID != null) {
            SynonymType synType = this.session.getSynonymType(synTypeID);
            if (synType == null) {
                throw new OBOParseException("Unrecognized synonym type ID " + synTypeID + " found", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
            }
            s.setSynonymType(synType);
        }
        for (int i = 0; i < xrefs.length; ++i) {
            Dbxref ref = this.getDbxref(xrefs[i], 1);
            s.addXref(ref);
        }
        return s;
    }

    protected Dbxref getDbxref(OBOParser.XrefPair pair, int type) {
        String id;
        String db;
        String dbx = pair.xref;
        int index = dbx.indexOf(58);
        if (index < 0) {
            db = "";
            id = dbx;
        } else {
            db = dbx.substring(0, index);
            id = dbx.substring(index + 1, dbx.length());
        }
        Dbxref ref = this.objectFactory.createDbxref(db, id, pair.desc, type, null);
        ref.setNestedValue(pair.nv);
        return ref;
    }

    @Override
    public void readDef(String def, OBOParser.XrefPair[] xrefs, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof DefinedObject)) {
            throw new OBOParseException("Attempted to set definition of object " + this.currentObject + " which does not support " + "definitions.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((DefinedObject)this.currentObject).setDefinition(def);
        for (int i = 0; i < xrefs.length; ++i) {
            Dbxref ref = this.getDbxref(xrefs[i], 2);
            ((DefinedObject)this.currentObject).addDefDbxref(ref);
        }
        ((DefinedObject)this.currentObject).setDefinitionExtension(nv);
    }

    @Override
    public void readXrefAnalog(OBOParser.XrefPair xref) throws OBOParseException {
        if (!(this.currentObject instanceof DbxrefedObject)) {
            throw new OBOParseException("Attempted to add dbxref to object " + this.currentObject + " which does not support dbxrefs.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        Dbxref ref = this.getDbxref(xref, 3);
        ((DbxrefedObject)((Object)this.currentObject)).addDbxref(ref);
    }

    @Override
    public void readXrefUnk(OBOParser.XrefPair xref) throws OBOParseException {
        if (!(this.currentObject instanceof DbxrefedObject)) {
            throw new OBOParseException("Attempted to add dbxref to object " + this.currentObject + " which does not support dbxrefs.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        Dbxref ref = this.getDbxref(xref, -1);
        ((DbxrefedObject)((Object)this.currentObject)).addDbxref(ref);
    }

    @Override
    public void readSubset(String name, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof SubsetObject)) {
            throw new OBOParseException("Attempted to add category to object " + this.currentObject + " which does not support categories.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        TermSubset cat = this.session.getCategory(name);
        if (cat == null) {
            throw new OBOParseException("Undefined category " + name + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((SubsetObject)((Object)this.currentObject)).addCategory(cat);
        ((SubsetObject)((Object)this.currentObject)).addCategoryExtension(cat, nv);
    }

    @Override
    public void readSynonym(String name, OBOParser.XrefPair[] xrefs, int scope, String catID, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof SynonymedObject)) {
            throw new OBOParseException("Attempted to add synonym to object " + this.currentObject + " which does not support synonyms.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((SynonymedObject)this.currentObject).addSynonym(this.getSynonym(name, xrefs, scope, catID, nv));
    }

    @Override
    public void readRelationship(String rel_type, String id, boolean necessary, boolean inverseNecessary, boolean completes, boolean implied, Integer minCardinality, Integer maxCardinality, Integer cardinality, String ns, NestedValue nv, List<String> args, boolean parentIsProperty) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify relationship for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        RelStruct rs = new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), this.mapID(rel_type), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), necessary, inverseNecessary, completes, implied, minCardinality, maxCardinality, cardinality, ns, nv, args);
        rs.parentIsProperty = parentIsProperty;
        this.linkSet.add(rs);
    }

    @Override
    public void readIsa(String id, String ns, boolean completes, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify isa for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        RelStruct rs = new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), OBOProperty.IS_A.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, completes, implied, null, null, null, ns, nv);
        if (this.currentObject instanceof OBOProperty) {
            rs.parentIsProperty = true;
        }
        this.linkSet.add(rs);
    }

    @Override
    public void readDisjoint(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify disjoint_from for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        this.linkSet.add(new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), OBOProperty.DISJOINT_FROM.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    @Override
    public void readUnion(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify union_of for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        this.linkSet.add(new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), OBOProperty.UNION_OF.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    @Override
    public void readInverseOf(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify inverse_of for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        this.linkSet.add(new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), OBOProperty.INVERSE_OF.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    @Override
    public void readTransitiveOver(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify inverse_of for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        RelStruct rs = new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), OBOProperty.TRANSITIVE_OVER.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv);
        rs.parentIsProperty = true;
        this.linkSet.add(rs);
    }

    public void readMetaRelation(String id, String ns, String metaRelationId, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify inverse_of for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        if (this.assignDefaultNamespaceToLinks && ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getID();
        }
        this.linkSet.add(new RelStruct(this.mapID(this.currentObject.getID()), this.mapID(id), metaRelationId, this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    @Override
    public void readIsCyclic(boolean isCyclic, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set cyclic attribute of non-property " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setCyclic(isCyclic);
        ((OBOProperty)this.currentObject).setCyclicExtension(nv);
    }

    @Override
    public void readIsTransitive(boolean isTransitive, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set transitive attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setTransitive(isTransitive);
        ((OBOProperty)this.currentObject).setTransitiveExtension(nv);
    }

    @Override
    public void readIsUniversallyQuantified(boolean isUniversallyQuantified, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set UniversallyQuantified attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setUniversallyQuantified(isUniversallyQuantified);
    }

    @Override
    public void readIsSymmetric(boolean isSymmetric, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set symmetric attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setSymmetric(isSymmetric);
        ((OBOProperty)this.currentObject).setSymmetricExtension(nv);
    }

    @Override
    public void readAlwaysImpliesInverse(boolean b, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set always_implies_inverse attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setAlwaysImpliesInverse(b);
        ((OBOProperty)this.currentObject).setAlwaysImpliesInverseExtension(nv);
    }

    @Override
    public void readIsReflexive(boolean b, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set reflexive attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setReflexive(b);
        ((OBOProperty)this.currentObject).setReflexiveExtension(nv);
    }

    @Override
    public void readIsAnonymous(NestedValue nv) {
        this.currentObject.setIsAnonymous(true);
        this.currentObject.setAnonymousExtension(nv);
    }

    @Override
    public void readIsMetadataTag(NestedValue nv) {
        ((OBOProperty)this.currentObject).setMetadataTag(true);
    }

    @Override
    public void readIsObsolete(NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof ObsoletableObject)) {
            throw new OBOParseException("Attempt to obsolete non-obsoletable object " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((ObsoletableObject)this.currentObject).setObsolete(true);
        ((ObsoletableObject)this.currentObject).setObsoleteExtension(nv);
    }

    @Override
    public void readReplacedBy(String id, NestedValue nv) {
        this.useSet.add(new BasicMapping(this.currentObject.getID(), id, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum()));
    }

    @Override
    public void readConsider(String id, NestedValue nv) {
        this.considerSet.add(new BasicMapping(this.currentObject.getID(), id, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum()));
    }

    @Override
    public void startParse() throws OBOParseException {
        this.halted = false;
        this.linkSet.clear();
        this.pathSet.clear();
        this.rangeMap.clear();
        this.domainMap.clear();
        this.unknownStanzaList.clear();
        this.namespaceMap.clear();
        this.useSet.clear();
        this.considerSet.clear();
        this.currentProfile = null;
        this.session = this.objectFactory.createSession();
        this.metaData = new OBOMetaData();
        for (ParserExtension extension : this.parserExtensions) {
            extension.setSession(this.session);
            extension.setParseEngine(this.engine);
            extension.startParse();
        }
    }

    @Override
    public void readDefaultNamespace(String ns) throws OBOParseException {
        Namespace n = this.getDefaultNamespace();
        this.namespaceMap.remove(n.getID());
        Namespace mapped = this.namespaceMap.get(ns);
        if (mapped != null) {
            this.namespaceStack.pop();
            this.namespaceStack.push(mapped);
        } else {
            n.setID(ns);
            this.namespaceMap.put(n.getID(), n);
        }
    }

    @Override
    public void readNamespace(String ns, NestedValue nv) {
        Namespace n = this.namespaceMap.get(ns);
        if (n == null) {
            Namespace def = this.getDefaultNamespace();
            n = this.objectFactory.createNamespace(ns, def.getPath());
            this.session.addNamespace(n);
        }
        this.metaData.addNamespace(this.getCurrentPath(), n);
        this.currentObject.setNamespace(n);
    }

    @Override
    public void startFileParse(String uri) throws OBOParseException {
        this.pathSet.add(uri);
        Namespace ns = this.namespaceMap.get(uri);
        if (ns == null) {
            ns = this.objectFactory.createNamespace(uri, uri);
            this.namespaceMap.put(uri, ns);
            this.session.addNamespace(ns);
        }
        this.metaData.mapFileData(uri, null);
        this.metaData.addNamespace(uri, ns);
        this.namespaceStack.push(ns);
        this.pathStack.push(uri);
        for (ParserExtension extension : this.parserExtensions) {
            extension.startFileParse(uri);
        }
    }

    @Override
    public void endFileParse(String uri) throws OBOParseException {
        if (this.currentObject != null && this.currentObject.getNamespace() == null && this.getDefaultNamespace() != null) {
            this.currentObject.setNamespace(this.getDefaultNamespace());
        }
        this.session.setDefaultNamespace(this.namespaceStack.pop());
        this.idMapping.clear();
        this.idPrefix = null;
        this.pathStack.pop();
        this.currentStanza = null;
        for (ParserExtension extension : this.parserExtensions) {
            extension.endFileParse(uri);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void endParse() throws OBOParseException {
        IdentifiedObject object;
        IdentifiedObject subject;
        BasicMapping bm;
        DanglingObject dangling;
        OBOProperty t;
        Iterator<Object> it = this.linkSet.iterator();
        ArrayList<Object> danglingViolations = new ArrayList<Object>();
        while (it.hasNext()) {
            OBORestriction tr;
            IdentifiedObject type;
            IdentifiedObject parent;
            IdentifiedObject child;
            RelStruct rs;
            block88: {
                if (this.halted) {
                    throw new OBOParseException("Operation cancelled by user", null, null, -1);
                }
                rs = it.next();
                child = this.getObject(rs.getChild());
                parent = this.getObject(rs.getParent());
                type = this.getObject(rs.getType());
                if (parent == null) {
                    if (this.allowDanglingParents) {
                        parent = this.objectFactory.createDanglingObject(rs.getParent(), rs.parentIsProperty);
                        this.session.addObject(parent);
                        logger.info((Object)("No parent for " + child + "--added dangling object " + parent + " (id = " + parent.getID() + ", name = " + parent.getName() + ")"));
                        break block88;
                    } else {
                        danglingViolations.add(rs);
                        continue;
                    }
                }
                if (!(parent instanceof LinkedObject)) {
                    if (!this.allowDanglingParents) {
                        throw new OBOParseException("Tried to link to object " + rs.getParent() + " that does not " + "support linking.", rs.getPath(), rs.getLine(), rs.getLineNum());
                    }
                    logger.info((Object)("Parent " + parent + "--not LinkedObject. adding as dangling"));
                    parent = this.objectFactory.createDanglingObject(parent.getID(), rs.parentIsProperty);
                    parent.setName(parent.getID());
                    this.session.addObject(parent);
                }
            }
            if (type == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Unrecognized type " + rs.getType(), rs.getPath(), rs.getLine(), rs.getLineNum());
                }
                type = (OBOProperty)((Object)this.objectFactory.createDanglingObject(rs.getType(), true));
                logger.info((Object)("No type for " + child + "--added dangling type object " + type));
            } else if (!(type instanceof OBOProperty)) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Tried to use non-type " + rs.getType() + " as relationship " + "type", rs.getPath(), rs.getLine(), rs.getLineNum());
                }
                type = (OBOProperty)((Object)this.objectFactory.createDanglingObject(rs.getType(), true));
                logger.info((Object)("No type for " + child + "--added dangling type object " + type));
            }
            Namespace ns = null;
            String nsString = rs.getNamespace();
            if (nsString != null) {
                ns = this.namespaceMap.get(nsString);
                logger.info((Object)("read namespace " + nsString + " for link, fetched namespace " + ns));
                if (ns == null) {
                    ns = this.objectFactory.createNamespace(nsString, null);
                    this.namespaceMap.put(nsString, ns);
                    this.session.addNamespace(ns);
                }
            }
            if ((tr = this.objectFactory.createOBORestriction((LinkedObject)child, (OBOProperty)type, (LinkedObject)parent, rs.isImplied())).isImplied()) {
                logger.info((Object)("loaded implied rel " + tr));
            }
            tr.setNecessarilyTrue(rs.isNecessary());
            tr.setInverseNecessarilyTrue(rs.isInverseNecessary());
            tr.setNestedValue(rs.getNestedValue());
            tr.setCompletes(rs.completes());
            tr.setMaxCardinality(rs.getMaxCardinality());
            tr.setMinCardinality(rs.getMinCardinality());
            tr.setCardinality(rs.getCardinality());
            if (rs.getArgs() != null && rs.getArgs().size() > 0) {
                ArrayList<LinkedObject> args = new ArrayList<LinkedObject>();
                for (int i = 0; i < rs.getArgs().size(); ++i) {
                    args.add(this.getLinkedObject(rs.getArgs().get(i)));
                }
                tr.setAdditionalArguments(args);
            }
            if (ns != null && !ns.equals(child.getNamespace())) {
                tr.setNamespace(ns);
            }
            tr.getParent().addChild(tr);
        }
        it = this.rangeMap.keySet().iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            t = (OBOProperty)it.next();
            String rangeID = this.rangeMap.get(t);
            IdentifiedObject o = this.getObject(rangeID);
            if (o == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Assigned non-existant range ID " + rangeID + " to term " + t.getID(), null, null, -1);
                }
                dangling = this.objectFactory.createDanglingObject(rangeID, false);
                logger.info((Object)("assigned DANGLING " + dangling + " to property " + t.getID()));
                t.setRange(dangling);
                logger.info((Object)("      range = " + t.getRange()));
                continue;
            }
            if (!(o instanceof Type)) {
                throw new OBOParseException("Assigned non-type to range of term " + t.getID(), null, null, -1);
            }
            t.setRange((Type)o);
        }
        it = this.domainMap.keySet().iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            t = (OBOProperty)it.next();
            String domainID = this.domainMap.get(t);
            IdentifiedObject domain = this.getObject(domainID);
            if (domain == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Assigned non-existant domain id " + domainID + " to term " + t.getID(), null, null, -1);
                }
                dangling = this.objectFactory.createDanglingObject(domainID, false);
                logger.info((Object)("Domain is null for domainID " + domainID + "--added dangling object"));
                t.setDomain(dangling);
                continue;
            }
            if (!(domain instanceof OBOClass)) {
                throw new OBOParseException("Cannot use non-term " + domain + " as domain value.", null, null, -1);
            }
            t.setDomain((OBOClass)domain);
        }
        Iterator i$ = this.holdsOverChainMap.keySet().iterator();
        block4: while (true) {
            if (!i$.hasNext()) {
                it = this.instanceOfHash.keySet().iterator();
                break;
            }
            IdentifiedObject io = (IdentifiedObject)i$.next();
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            OBOProperty t2 = (OBOProperty)io;
            Iterator i$2 = ((Collection)this.holdsOverChainMap.get((Object)io)).iterator();
            while (true) {
                if (!i$2.hasNext()) continue block4;
                List chain = (List)i$2.next();
                ArrayList<OBOProperty> pChain = new ArrayList<OBOProperty>();
                for (String pid : chain) {
                    IdentifiedObject p = this.getObject(pid);
                    if (p == null) {
                        if (!this.allowDanglingParents) {
                            throw new OBOParseException("Assigned non-existant property in chain id " + pid + " in term " + t2.getID(), null, null, -1);
                        }
                        DanglingObject dangling2 = this.objectFactory.createDanglingObject(pid, true);
                        logger.info((Object)("null property " + pid + "--added dangling object"));
                        p = dangling2;
                    } else if (!(p instanceof OBOProperty)) {
                        throw new OBOParseException("Cannot use non-relation " + p + " " + p.getClass() + " in chain.", null, null, -1);
                    }
                    pChain.add((OBOProperty)p);
                }
                t2.addHoldsOverChain(pChain);
            }
            break;
        }
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            String id = (String)it.next();
            InstanceStruct is = this.instanceOfHash.get(id);
            IdentifiedObject instance = this.getObject(id);
            if (instance == null) {
                throw new OBOParseException("Unexpected condition, unrecognized instance " + id + " found", is.getPath(), is.getLine(), is.getLineNum());
            }
            IdentifiedObject instanceOfObj = this.getObject(is.instanceOf);
            if (instanceOfObj == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Unrecognized instance_of ID " + is.instanceOf + " specified for " + "instance id " + id, is.getPath(), is.getLine(), is.getLineNum());
                }
                instanceOfObj = new DanglingClassImpl(is.instanceOf);
                logger.info((Object)"instanceOfObj is null-added dangling object");
            } else if (!(instanceOfObj instanceof OBOClass)) {
                throw new OBOParseException("Cannot use non-term value " + is.instanceOf + ", " + "for instance_of statement.", is.getPath(), is.getLine(), is.getLineNum());
            }
            ((Instance)instance).setType(TermUtil.castToClass((LinkedObject)instanceOfObj));
        }
        it = this.propertyValSet.iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            PropertyValStruct pvs = (PropertyValStruct)it.next();
            Instance instance = (Instance)this.getObject(pvs.instanceID);
            AnnotatedObject prop_o = (AnnotatedObject)this.session.getObject(pvs.propID);
            if (instance == null) {
                throw new OBOParseException("Unexpected condition encountered. Missing instance.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            if (prop_o == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Unrecognized property " + pvs.propID, pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                prop_o = (OBOProperty)((Object)this.objectFactory.createDanglingObject(pvs.propID, true));
            }
            if (!(prop_o instanceof OBOProperty)) {
                throw new OBOParseException("Non-property " + pvs.propID + " specified as" + "property.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            OBOProperty prop = (OBOProperty)prop_o;
            IdentifiedObject type_o = this.session.getObject(pvs.typeID);
            if (pvs.quoted) {
                if (pvs.typeID == null) {
                    type_o = Datatype.STRING;
                }
                if (type_o == null) {
                    type_o = Datatype.STRING;
                }
                if (!(type_o instanceof Datatype)) {
                    throw new OBOParseException("Non-datatype " + pvs.typeID + " specified " + "as datatype", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                Datatype type = (Datatype)type_o;
                if (!type.isLegalValue(pvs.val)) {
                    throw new OBOParseException("Illegal value " + pvs.val + "for type " + type, pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                if (prop.getRange() != null && !(prop.getRange() instanceof Datatype)) {
                    throw new OBOParseException("Datatype specified for property with non-datatype range", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                instance.addPropertyValue(prop, new DatatypeValueImpl(type, pvs.val));
                continue;
            }
            IdentifiedObject o = this.session.getObject(pvs.val);
            if (o == null) {
                if (this.allowDanglingParents) {
                    o = this.objectFactory.createDanglingObject(pvs.val, false);
                    this.session.addObject(o);
                    logger.info((Object)("Created dangling object " + o));
                } else {
                    danglingViolations.add(pvs);
                    continue;
                }
            }
            if (type_o != null) {
                throw new OBOParseException("Cannot assign a type to a non-datatype property value.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            logger.info((Object)("pvs.val = " + pvs.val + ", o = " + o));
            if (!(o instanceof Value)) {
                throw new OBOParseException("Attempted to assign non value to a propertyValue", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            instance.addPropertyValue(prop, o);
        }
        if (danglingViolations.size() <= 0) {
            it = this.useSet.iterator();
        } else {
            String message = danglingViolations.size() + " unrecognized parent terms:\n";
            int linenum = -1;
            String line = null;
            String path = null;
            String parent = null;
            for (int i = 0; i < 20 && i < danglingViolations.size(); ++i) {
                Object o = danglingViolations.get(i);
                if (o instanceof RelStruct) {
                    RelStruct rs = (RelStruct)o;
                    linenum = rs.getLineNum();
                    line = rs.getLine();
                    path = rs.getPath();
                    parent = rs.getParent();
                } else if (o instanceof PropertyValStruct) {
                    PropertyValStruct pvs = (PropertyValStruct)o;
                    linenum = pvs.getLineNum();
                    line = pvs.getLine();
                    path = pvs.getPath();
                    parent = pvs.val;
                }
                message = message + "     line " + linenum + ": " + parent + " of " + path + "\n";
            }
            throw new OBOParseException(message, path, line, linenum);
        }
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            bm = (BasicMapping)it.next();
            subject = this.session.getObject(bm.getSubject());
            if (subject == null) {
                throw new OBOParseException("Unexpected condition: subject of replaced_by " + bm.getSubject() + " disappeared!", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(subject instanceof ObsoletableObject)) {
                throw new OBOParseException("Attempted to assign replaced_by value to non-obsoletable object " + subject, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            object = this.session.getObject(bm.getObject());
            if (object == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Could not resolve ID " + bm.getObject() + " in replaced_by " + "statement.", bm.getPath(), bm.getLine(), bm.getLineNum());
                }
                object = new DanglingClassImpl(bm.getObject());
                logger.info((Object)("object is null for " + bm.getObject() + "--added dangling class impl"));
            }
            if (!(object instanceof ObsoletableObject)) {
                throw new OBOParseException("replaced_by tag has non-obsoletable value " + object, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!((ObsoletableObject)subject).isObsolete()) {
                throw new OBOParseException("Attempted to specify replaced_by value for non-obsolete object " + subject + ".", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (((ObsoletableObject)object).isObsolete() && this.failFast) {
                throw new OBOParseException("Attempted to specify obsolete value " + object + " for " + "replaced_by tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            ((ObsoletableObject)subject).addReplacedBy((ObsoletableObject)object);
            if (bm.getNestedValue() == null) continue;
            ((ObsoletableObject)subject).addReplacedByExtension((ObsoletableObject)object, bm.getNestedValue());
        }
        it = this.considerSet.iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            bm = (BasicMapping)it.next();
            subject = this.session.getObject(bm.getSubject());
            if (subject == null) {
                throw new OBOParseException("Unexpected condition: subject of consider " + bm.getSubject() + " disappeared!", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(subject instanceof ObsoletableObject)) {
                throw new OBOParseException("Attempted to assign consider value to non-obsoletable object " + subject, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            object = this.session.getObject(bm.getObject());
            if (object == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Could not resolve ID " + bm.getObject() + " in consider " + "tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
                }
                object = new DanglingClassImpl(bm.getObject());
                logger.info((Object)("object is null for " + bm.getObject() + "--added dangling class impl"));
            }
            if (!(object instanceof ObsoletableObject)) {
                throw new OBOParseException("consider tag has non-obsoletable value " + object, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!((ObsoletableObject)subject).isObsolete()) {
                throw new OBOParseException("Attempted to specify consider value for non-obsolete object " + subject + ".", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (((ObsoletableObject)object).isObsolete()) {
                throw new OBOParseException("Attempted to specify obsolete value " + object + " for " + "consider tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            ((ObsoletableObject)subject).addConsiderReplacement((ObsoletableObject)object);
            if (bm.getNestedValue() == null) continue;
            ((ObsoletableObject)subject).addConsiderExtension((ObsoletableObject)object, bm.getNestedValue());
        }
        for (int i = 0; i < this.unknownStanzaList.size(); ++i) {
            UnknownStanza us = this.unknownStanzaList.get(i);
            this.session.addUnknownStanza(us);
        }
        this.session.setIDProfile(this.currentProfile);
        this.linkSet.clear();
        this.namespaceMap.clear();
        this.pathSet.clear();
        Iterator<ParserExtension> i$2 = this.parserExtensions.iterator();
        while (i$2.hasNext()) {
            ParserExtension extension = i$2.next();
            extension.endParse();
        }
        return;
    }

    @Override
    public boolean startStanza(String name) throws OBOParseException {
        if (this.currentObject != null && this.currentObject.getNamespace() == null && this.getDefaultNamespace() != null) {
            this.currentObject.setNamespace(this.getDefaultNamespace());
        }
        this.engine.setReadIDForCurrentBlock(false);
        this.setCurrentStanza(name);
        boolean handled = false;
        for (ParserExtension extension : this.parserExtensions) {
            if (!extension.startStanza(name)) continue;
            handled = true;
        }
        if (!handled) {
            if (!(this.currentStanza.equalsIgnoreCase("term") || this.currentStanza.equalsIgnoreCase("typedef") || this.currentStanza.equalsIgnoreCase("instance"))) {
                this.unknownStanza = new UnknownStanza(this.currentStanza, this.getDefaultNamespace());
                this.unknownStanzaList.add(this.unknownStanza);
            } else {
                this.unknownStanza = null;
            }
        }
        return true;
    }

    public void setCurrentStanza(String name) {
        this.currentStanza = name;
        this.unknownStanza = null;
    }

    @Override
    public void readBangComment(String comment) throws OBOParseException {
        for (ParserExtension extension : this.parserExtensions) {
            extension.readBangComment(comment);
        }
    }

    public UnknownStanza getCurrentUnknownStanza() {
        return this.unknownStanza;
    }

    @Override
    public boolean prefersRaw(String tag, String value, NestedValue nv) throws OBOParseException {
        boolean handled = false;
        for (ParserExtension extension : this.parserExtensions) {
            boolean accepted = extension.readTagValue(tag, value, nv, handled);
            if (!accepted) continue;
            handled = true;
        }
        return handled;
    }

    @Override
    public boolean readTagValue(String name, String value, NestedValue nv, boolean handled) throws OBOParseException {
        if (!handled) {
            PropertyValueImpl pv = new PropertyValueImpl(name, value, this.engine.getCurrentPath(), this.engine.getLineNum());
            if (this.currentStanza == null) {
                this.session.addPropertyValue(pv);
            } else if (this.unknownStanza != null) {
                this.unknownStanza.addPropertyValue(pv, nv);
            } else {
                this.currentObject.addPropertyValue(pv);
            }
        }
        return true;
    }

    @Override
    public void setParseEngine(ParseEngine engine) {
        this.engine = engine;
        for (ParserExtension extension : this.parserExtensions) {
            extension.setParseEngine(engine);
        }
    }

    public OBOMetaData getMetaData() {
        return this.metaData;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Override
    public void readCreatedBy(String user, NestedValue val) throws OBOParseException {
        if (!(this.currentObject instanceof ModificationMetadataObject)) {
            throw new OBOParseException("Attempted to set created-by field of object " + this.currentObject + " which does not support modification metadata.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((ModificationMetadataObject)((Object)this.currentObject)).setCreatedBy(user);
        ((ModificationMetadataObject)((Object)this.currentObject)).setCreatedByExtension(val);
    }

    @Override
    public void readCreationDate(Date date, NestedValue val) throws OBOParseException {
        if (!(this.currentObject instanceof ModificationMetadataObject)) {
            throw new OBOParseException("Attempted to set creation-date field of object " + this.currentObject + " which does not support modification metadata.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((ModificationMetadataObject)((Object)this.currentObject)).setCreationDate(date);
        ((ModificationMetadataObject)((Object)this.currentObject)).setCreationDateExtension(val);
    }

    @Override
    public void readModificationDate(Date date, NestedValue val) throws OBOParseException {
        if (!(this.currentObject instanceof ModificationMetadataObject)) {
            throw new OBOParseException("Attempted to set modification-date field of object " + this.currentObject + " which does not support modification metadata.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((ModificationMetadataObject)((Object)this.currentObject)).setModificationDate(date);
        ((ModificationMetadataObject)((Object)this.currentObject)).setModificationDateExtension(val);
    }

    @Override
    public void readModifiedBy(String user, NestedValue val) throws OBOParseException {
        if (!(this.currentObject instanceof ModificationMetadataObject)) {
            throw new OBOParseException("Attempted to set modified-by field of object " + this.currentObject + " which does not support modification metadata.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((ModificationMetadataObject)((Object)this.currentObject)).setModifiedBy(user);
        ((ModificationMetadataObject)((Object)this.currentObject)).setModifiedByExtension(val);
    }

    @Override
    public void readImpliedID() {
        if (this.unknownStanza == null) {
            this.readID(IDUtil.fetchTemporaryID(this.session), new NestedValueImpl());
        }
    }

    @Override
    public void readIDSpace(String idspace, String uriPrefix) throws OBOParseException {
        this.session.addIDSpace(idspace, uriPrefix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RelStruct
    implements Comparable {
        protected String child;
        protected String parent;
        protected String type;
        protected int linenum;
        protected String path;
        protected String line;
        protected String ns;
        protected NestedValue nv;
        protected boolean necessary = true;
        protected boolean inverseNecessary = false;
        protected boolean completes = false;
        protected boolean implied = false;
        public boolean parentIsProperty = false;
        protected Integer minCardinality;
        protected Integer maxCardinality;
        protected Integer cardinality;
        protected List<String> args;

        public int compareTo(Object b) {
            if (b instanceof RelStruct) {
                if (this.linenum < ((RelStruct)b).getLineNum()) {
                    return -1;
                }
                if (this.linenum > ((RelStruct)b).getLineNum()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public RelStruct(String child, String parent, String type, String path, int linenum, String line, boolean necessary, boolean inverseNecessary, boolean completes, boolean implied, Integer minCardinality, Integer maxCardinality, Integer cardinality, String ns, NestedValue nv, List<String> args) {
            this.child = child;
            this.parent = parent;
            this.type = type;
            this.linenum = linenum;
            this.path = path;
            this.line = line;
            this.necessary = necessary;
            this.inverseNecessary = inverseNecessary;
            this.completes = completes;
            this.implied = implied;
            this.cardinality = cardinality;
            this.maxCardinality = maxCardinality;
            this.minCardinality = minCardinality;
            this.nv = nv;
            this.ns = ns;
            this.args = args;
        }

        public RelStruct(String child, String parent, String type, String path, int linenum, String line, boolean necessary, boolean inverseNecessary, boolean completes, boolean implied, Integer minCardinality, Integer maxCardinality, Integer cardinality, String ns, NestedValue nv) {
            this.child = child;
            this.parent = parent;
            this.type = type;
            this.linenum = linenum;
            this.path = path;
            this.line = line;
            this.necessary = necessary;
            this.inverseNecessary = inverseNecessary;
            this.completes = completes;
            this.implied = implied;
            this.cardinality = cardinality;
            this.maxCardinality = maxCardinality;
            this.minCardinality = minCardinality;
            this.nv = nv;
            this.ns = ns;
        }

        public String getPath() {
            return this.path;
        }

        public Integer getMinCardinality() {
            return this.minCardinality;
        }

        public Integer getMaxCardinality() {
            return this.maxCardinality;
        }

        public Integer getCardinality() {
            return this.cardinality;
        }

        public void setNestedValue(NestedValue nv) {
            this.nv = nv;
        }

        public NestedValue getNestedValue() {
            return this.nv;
        }

        public String getNamespace() {
            return this.ns;
        }

        public boolean isNecessary() {
            return this.necessary;
        }

        public boolean isInverseNecessary() {
            return this.inverseNecessary;
        }

        public boolean isImplied() {
            return this.implied;
        }

        public boolean completes() {
            return this.completes;
        }

        public int getLineNum() {
            return this.linenum;
        }

        public String getLine() {
            return this.line;
        }

        public String getChild() {
            return this.child;
        }

        public String getParent() {
            return this.parent;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args = args;
        }
    }

    protected static class PropertyValStruct {
        protected String instanceID;
        protected String propID;
        protected String val;
        protected String typeID;
        protected NestedValue nv;
        protected String line;
        protected int linenum;
        protected String path;
        protected boolean quoted;

        public PropertyValStruct(String instanceID, String propID, String val, String typeID, NestedValue nv, String path, boolean quoted, String line, int linenum) {
            this.instanceID = instanceID;
            this.propID = propID;
            this.val = val;
            this.typeID = typeID;
            this.nv = nv;
            this.path = path;
            this.quoted = quoted;
            this.line = line;
            this.linenum = linenum;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }
    }

    protected static class InstanceStruct {
        protected String instanceOf;
        protected NestedValue nv;
        protected String path;
        protected String line;
        protected int linenum;

        public InstanceStruct(String instanceOf, NestedValue nv, String path, String line, int linenum) {
            this.instanceOf = instanceOf;
            this.path = path;
            this.line = line;
            this.linenum = linenum;
            this.nv = nv;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }
    }

    protected static class BasicMapping {
        protected String subject;
        protected String object;
        protected NestedValue nv;
        protected String path;
        protected String line;
        protected int linenum;

        public BasicMapping(String subject, String object, NestedValue nv, String path, String line, int linenum) {
            this.subject = subject;
            this.object = object;
            this.nv = nv;
            this.line = line;
            this.linenum = linenum;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getObject() {
            return this.object;
        }

        public NestedValue getNestedValue() {
            return this.nv;
        }
    }
}

