/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.IOUtil;
import org.bbop.io.ProgressableInputStream;
import org.bbop.io.SafeFileOutputStream;
import org.bbop.util.VectorTransformer;
import org.bbop.util.VectorUtil;
import org.obo.dataadapter.CompoundGOFlatFileParseException;
import org.obo.dataadapter.GOFlatFileParseException;
import org.obo.dataadapter.GOFlatFileTokenizer;
import org.obo.dataadapter.GOToken;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.RelToHolderTransformation;
import org.obo.dataadapter.RelationshipHolder;
import org.obo.datamodel.AnnotatedObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.RootAlgorithm;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.impl.DbxrefImpl;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.datamodel.impl.OBOPropertyImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.util.TermUtil;

public class GOFlatFileAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(GOFlatFileAdapter.class);
    Stack termStack;
    OBOClass root;
    OBOClass writeRoot;
    String currentType;
    GOFlatFileConfiguration config;
    protected BufferedReader currentReader;
    protected List writeStreamList = new ArrayList();
    protected List printStreamList = new ArrayList();
    Vector parentageList;
    CompoundGOFlatFileParseException exceptionHolder;
    protected boolean strictParentage = false;
    protected boolean strictDefinition = false;
    protected boolean hideDownstream = true;
    protected static OBOProperty FAILED_TYPE = new OBOPropertyImpl("goflatfile:failed");
    protected static OBOProperty UNKNOWN_TYPE = new OBOPropertyImpl("UNKNOWN", "unknown");
    protected static final Map RESERVED_SYMBOLS = new HashMap();
    protected HashMap categories = new HashMap();
    protected HashMap namespaceHash = new HashMap();
    protected HashMap nsHash = new HashMap();
    protected boolean lostDefs = false;
    protected boolean cancelled = false;
    protected int readfileindex;
    protected Map readerCache = new HashMap();
    protected String progressString;
    protected int progressValue = -1;
    protected GraphicalUI advancedUI;
    protected OBOClassImpl dummyTerm = new OBOClassImpl("dummy");
    protected static final Vector scratchVector = new Vector();
    public static final char BOUNDARY_CHAR = '@';
    public static final HashMap IDMAPPINGS = new HashMap();
    protected List listeners = new Vector();
    protected ProgressableInputStream currentStream;
    OBOSession history;
    protected static final Comparator idComparator = new Comparator(){

        public int compare(Object a, Object b) {
            String x = (String)a;
            String y = (String)b;
            return x.compareToIgnoreCase(y);
        }
    };
    protected static final Comparator dbxrefComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return a.toString().compareToIgnoreCase(b.toString());
        }
    };
    protected static final Comparator relByChildComparator = new Comparator(){

        public int compare(Object a, Object b) {
            Link tra = (Link)a;
            Link trb = (Link)b;
            return ((OBOClass)tra.getChild()).compareTo(trb.getChild());
        }
    };
    protected static final Comparator relByParentComparator = new Comparator(){

        public int compare(Object a, Object b) {
            Link tra = (Link)a;
            Link trb = (Link)b;
            return ((OBOClass)tra.getParent()).compareTo(trb.getParent());
        }
    };
    Map charToType = new HashMap();
    Map typeToChar = new HashMap();
    protected GOFlatFileTokenizer tokenizer;
    protected String username = null;
    protected String autogen;

    protected void setProgressValue(int progressValue) {
        this.progressValue = progressValue;
    }

    protected void setProgressString(String progressString) {
        this.progressString = progressString;
    }

    public String getProgressString() {
        return this.progressString;
    }

    protected BufferedReader openReader(String filename) throws IOException {
        this.currentStream = IOUtil.getProgressableStream((String)filename);
        this.currentStream.setProgressMessage("Reading " + filename + "...");
        this.currentReader = new BufferedReader(new InputStreamReader((InputStream)this.currentStream));
        return this.currentReader;
    }

    public Number getProgressValue() {
        if (this.progressValue == -1) {
            int filecount = 1;
            if (this.config != null) {
                filecount = this.config.getReadPaths().size() + (this.config.getDefFilename() != null ? 1 : 0);
            }
            int newval = (this.currentStream.getProgressValue().intValue() + this.readfileindex * 100) / filecount;
            return newval;
        }
        return this.progressValue;
    }

    public static boolean isReservedCharacter(char c) {
        return RESERVED_SYMBOLS.containsKey(new Character(c));
    }

    protected String convertTypeToChar(OBOProperty trt) {
        return (String)this.typeToChar.get(trt);
    }

    protected OBOProperty convertCharToType(String chr) {
        OBOProperty out = (OBOProperty)this.charToType.get(chr);
        return out;
    }

    protected void initTypeMappings() {
        this.typeToChar.clear();
        this.charToType.clear();
    }

    protected void addTypeMapping(CharTypeMapping mapping) {
        OBOProperty prop;
        String propid = mapping.getPropertyID();
        if (this.config.getTranslateTypes() && IDMAPPINGS.get(propid) != null) {
            propid = (String)IDMAPPINGS.get(propid);
        }
        if ((prop = (OBOProperty)this.history.getObject(propid)) == null) {
            prop = new OBOPropertyImpl(propid, mapping.getPropertyName());
            this.history.addObject(prop);
        }
        this.addTypeMapping(mapping.getTypeChar(), prop);
    }

    protected void addTypeMapping(String typeChar, OBOProperty prop) {
        if (typeChar.length() == 1 && this.tokenizer != null) {
            this.tokenizer.addKeeperTokenChar(typeChar.charAt(0));
        }
        this.charToType.put(typeChar, prop);
        this.typeToChar.put(prop, typeChar);
    }

    public void setAllowCycles(boolean allowCycles) {
        this.config.setAllowCycles(allowCycles);
    }

    public boolean getAllowCycles() {
        return this.config.getAllowCycles();
    }

    public void setAllowDangling(boolean allowDangling) {
        this.config.setAllowDangling(allowDangling);
    }

    public boolean getAllowDangling() {
        return this.config.getAllowDangling();
    }

    public String getTermText(OBOClass term) throws DataAdapterException {
        throw new DataAdapterException("Not supported");
    }

    public Set getTermCategories() throws DataAdapterException {
        return new HashSet(this.categories.values());
    }

    public void setHideDownstream(boolean hide) {
        this.hideDownstream = hide;
    }

    public String[] getIDs(OBOSession history, OBOClass term, String prefix, int length, int count) throws DataAdapterException {
        throw new DataAdapterException("Not supported");
    }

    public String[] getIDs(OBOSession history, OBOClass term, String prefix, int min, int max, int length, int count) throws DataAdapterException {
        throw new DataAdapterException("Not supported");
    }

    public Vector getHistories() throws DataAdapterException {
        throw new DataAdapterException("Not supported");
    }

    public void setStrictParentage(boolean strict) {
        this.strictParentage = strict;
    }

    public void setStrictDefinition(boolean strict) {
        this.strictDefinition = strict;
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){

            public AdapterConfiguration createEmptyConfig() {
                return new GOFlatFileConfiguration();
            }

            public void setConfiguration(AdapterConfiguration c) {
                GOFlatFileConfiguration config;
                super.setConfiguration(c);
                if (c instanceof GOFlatFileConfiguration && (config = (GOFlatFileConfiguration)c).getDefFilename() != null) {
                    String pathStr = (String)this.readField.getSelectedItem();
                    pathStr = pathStr + " '" + this.escapePath(config.getDefFilename(), true) + "'";
                    this.readField.setSelectedItem(pathStr);
                }
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                if (storeonly) {
                    return;
                }
                GOFlatFileAdapter.this.readerCache.clear();
                Iterator it = ((FileAdapterConfiguration)this.config).getReadPaths().iterator();
                boolean foundDefFile = false;
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (!GOFlatFileAdapter.this.isDefinitionFile(s)) continue;
                    if (foundDefFile) {
                        throw new DataAdapterUIException("More than one definition file was specified.");
                    }
                    it.remove();
                    ((GOFlatFileConfiguration)this.config).setDefFilename(s);
                    foundDefFile = true;
                }
                ((GOFlatFileConfiguration)this.config).setBasicSave(true);
            }
        };
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        GraphicalUI advanced = this.getAdvancedUI();
        if (advanced != null) {
            ui.setAdvancedUI(advanced);
            advanced.setSimpleUI((GraphicalUI)ui);
        }
        return ui;
    }

    protected void setDefinition(IDWrapper id, Map terms, String definition, String comment, Vector refs, CompoundGOFlatFileParseException defExceptions, String filename, String startline, int startlineNumber) throws DataAdapterException {
        if (id == null) {
            defExceptions.addException(new GOFlatFileParseException("No goid field in entry.", filename, startline, startlineNumber, 0));
            return;
        }
        if (definition == null) {
            defExceptions.addException(new GOFlatFileParseException("No definition field in entry.", filename, startline, startlineNumber, 0));
            return;
        }
        if (refs.size() < 1) {
            defExceptions.addException(new GOFlatFileParseException("No definition_reference field in entry.", filename, startline, startlineNumber, 0));
            return;
        }
        OBOClass term = (OBOClass)terms.get(id.toString());
        if (term != null) {
            term.setDefinition(definition);
            if (comment == null) {
                term.setComment("");
            } else {
                term.setComment(comment);
            }
            for (int i = 0; i < refs.size(); ++i) {
                term.addDefDbxref((Dbxref)refs.get(i));
            }
        } else if (term == null) {
            this.lostDefs = true;
            if (this.strictDefinition) {
                defExceptions.addException(new GOFlatFileParseException("Reference to non-existant GO ID " + id.toString(), filename, startline, startlineNumber, 0));
            }
        }
    }

    protected int unescapedIndex(String str, char findme) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != findme) continue;
            return i;
        }
        return -1;
    }

    public void populateDefinitions(Map allterms, String filename) throws DataAdapterException {
        try {
            BufferedReader reader = this.openReader(filename);
            CompoundGOFlatFileParseException defExceptions = new CompoundGOFlatFileParseException(this.hideDownstream);
            int lineNumber = 0;
            IDWrapper goid = null;
            String term = null;
            String def = null;
            String comment = null;
            Vector<DbxrefImpl> references = new Vector<DbxrefImpl>();
            boolean inDefinition = false;
            int startlineNumber = -1;
            String startline = null;
            this.setProgressString("Parsing definitions...");
            while (true) {
                int start;
                String line = reader.readLine();
                ++lineNumber;
                if (this.cancelled) {
                    throw new CancelledAdapterException();
                }
                if (line == null) {
                    if (goid == null || term == null || def == null || references.size() == 0) break;
                    this.setDefinition(goid, allterms, GOFlatFileAdapter.unescapeDefText(def), GOFlatFileAdapter.unescapeDefText(comment), references, defExceptions, filename, startline, startlineNumber);
                    break;
                }
                if (line.trim().equals("")) {
                    if (goid != null && term != null && def != null && references.size() != 0) {
                        this.setDefinition(goid, allterms, GOFlatFileAdapter.unescapeDefText(def), GOFlatFileAdapter.unescapeDefText(comment), references, defExceptions, filename, startline, startlineNumber);
                    }
                    goid = null;
                    term = null;
                    def = null;
                    comment = null;
                    references = new Vector();
                    startlineNumber = -1;
                    startline = null;
                    inDefinition = false;
                }
                if (line.trim().length() == 0 || line.charAt(0) == '!') continue;
                if (startline == null) {
                    startline = line;
                    startlineNumber = lineNumber;
                }
                if ((start = this.findStartOfDefFieldData(line)) == -1) {
                    if (inDefinition) {
                        def = def + " " + line;
                        continue;
                    }
                    defExceptions.addException(new GOFlatFileParseException("No type field found, and line is not a continuation of definition text.", filename, line, lineNumber, 0));
                    continue;
                }
                String key = line.substring(0, start - 2);
                String value = line.substring(start);
                if (key.equals("definition")) {
                    inDefinition = true;
                    if (def == null) {
                        def = value;
                        continue;
                    }
                    defExceptions.addException(new GOFlatFileParseException("Multiple definition fields for one entry.", filename, line, lineNumber, 0));
                    continue;
                }
                if (key.equals("comment")) {
                    inDefinition = false;
                    if (comment == null) {
                        comment = value;
                        continue;
                    }
                    defExceptions.addException(new GOFlatFileParseException("Multiple comment fields for one entry.", filename, line, lineNumber, 0));
                    continue;
                }
                if (key.equals("goid") || key.equals("id")) {
                    inDefinition = false;
                    if (goid == null) {
                        try {
                            Queue tokenList = this.getQueueForLine(filename.toString(), line, lineNumber, null);
                            tokenList.dequeue();
                            tokenList.dequeue();
                            goid = this.pullOffID(tokenList, this.exceptionHolder);
                        }
                        catch (NoSuchElementException e) {
                            GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected end of line ", filename, line, lineNumber, line.length());
                            defExceptions.addException(ex);
                        }
                        continue;
                    }
                    defExceptions.addException(new GOFlatFileParseException("Multiple ID fields for one entry.", filename, line, lineNumber, 0));
                    continue;
                }
                if (key.equals("term")) {
                    inDefinition = false;
                    if (term == null) {
                        term = value;
                        continue;
                    }
                    defExceptions.addException(new GOFlatFileParseException("Multiple term name fields for one entry.", filename, line, lineNumber, 0));
                    continue;
                }
                if (key.equals("definition_reference")) {
                    DbxrefImpl ref;
                    String dbid;
                    String dbname;
                    inDefinition = false;
                    int index = this.unescapedIndex(value, ':');
                    if (index == -1) {
                        dbname = "";
                        dbid = value;
                    } else {
                        dbname = value.substring(0, index);
                        dbid = value.substring(index + 1, value.length());
                    }
                    if (references.contains(ref = new DbxrefImpl(dbname, dbid, 2))) continue;
                    references.addElement(ref);
                    continue;
                }
                defExceptions.addException(new GOFlatFileParseException("Unrecognized type field \"" + key + "\"", filename, line, lineNumber, 0));
            }
            if (!defExceptions.isEmpty()) {
                throw defExceptions;
            }
        }
        catch (FileNotFoundException e) {
            throw new DataAdapterException("Cannot find " + filename);
        }
        catch (IOException e) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            throw new DataAdapterException("File unreadable", (Throwable)e);
        }
    }

    private int findStartOfDefFieldData(String in) {
        int firstSpace = in.indexOf(" ");
        if (firstSpace < 1 || in.charAt(firstSpace - 1) != ':') {
            return -1;
        }
        return firstSpace + 1;
    }

    public void init() {
    }

    protected static URL getURLForPath(String path) {
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                url = new URL("file:" + path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public OBOClass importTerms(OBOClass root, boolean stripIds) throws DataAdapterException {
        OBOClass term;
        if (stripIds) {
            term = this.getRoot(new HashMap());
            this.wipeOutIDs(term);
        } else {
            Map<String, IdentifiedObject> map = TermUtil.createIDMap(TermUtil.getDescendants(root, true));
            term = this.getRoot(map);
        }
        return term;
    }

    private void wipeOutIDs(OBOClass term) {
        for (Link tr : term.getChildren()) {
            this.wipeOutIDs((OBOClass)tr.getChild());
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration config, Object input) throws DataAdapterException {
        if (!(config instanceof GOFlatFileConfiguration)) {
            throw new DataAdapterException("Adapter requires a GOFlatFileConfiguration object.");
        }
        this.cancelled = false;
        this.config = (GOFlatFileConfiguration)config;
        if (op.equals(OBOAdapter.READ_ONTOLOGY)) {
            OBOSession session = this.getRoot();
            return session;
        }
        if (op.equals(OBOAdapter.WRITE_ONTOLOGY)) {
            return this.write((OBOSession)input);
        }
        throw new DataAdapterException("Unsupported operation " + op);
    }

    public boolean isDefinitionFile(String filename) {
        try {
            String currentLine;
            BufferedReader reader = this.openReader(filename);
            reader.mark(10000);
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.trim().length() == 0 || currentLine.charAt(0) == '!') continue;
                reader.reset();
                return currentLine.startsWith("term:") || currentLine.startsWith("goid:") || currentLine.startsWith("id:") || currentLine.startsWith("comment:") || currentLine.startsWith("definition:") || currentLine.startsWith("definition_reference:");
            }
            reader.reset();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public OBOSession getRoot() throws DataAdapterException {
        this.categories.clear();
        this.namespaceHash.clear();
        this.initTypeMappings();
        this.history = new OBOSessionImpl();
        this.lostDefs = false;
        HashMap table = new HashMap();
        this.tokenizer = new GOFlatFileTokenizer();
        this.tokenizer.addTokenChar(' ');
        this.tokenizer.addTokenChar('\t');
        this.tokenizer.addKeeperTokenChar('$');
        this.tokenizer.addKeeperTokenChar(';');
        this.tokenizer.addKeeperTokenChar(',');
        this.tokenizer.addKeeperTokenChar(':');
        for (CharTypeMapping ctm : this.config.getTypeMappings()) {
            this.addTypeMapping(ctm);
        }
        this.tokenizer.addBoundaryChar('@');
        this.nsHash = new HashMap();
        OBOClass root = this.getRoot(table);
        this.readerCache.clear();
        this.history.setDefaultNamespace(root.getNamespace());
        Iterator<Object> it = TermUtil.getDescendants(root, true).iterator();
        while (it.hasNext()) {
            this.history.addObject((IdentifiedObject)it.next());
        }
        this.history.getCurrentHistory().setUser(System.getProperty("user.name"));
        this.history.getCurrentHistory().setDate(new Date());
        this.history.getCurrentHistory().setComment(this.config.getComment());
        this.history.getSubsets().addAll(this.getTermCategories());
        for (Namespace ns : this.nsHash.values()) {
            this.history.addNamespace(ns);
        }
        this.history.setLoadRemark(this.createLoadRemark());
        return this.history;
    }

    protected String createLoadRemark() {
        StringBuffer out = new StringBuffer();
        Iterator it = this.config.getReadPaths().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String filename = (String)it.next();
            if (!first) {
                out.append(", ");
            }
            first = true;
            out.append(filename);
        }
        return "GO File from : " + out.toString();
    }

    public boolean getLostDefs() {
        return this.lostDefs;
    }

    public synchronized OBOClass getRoot(Map allterms) throws DataAdapterException {
        OBOClass root = null;
        String rootfile = null;
        Iterator it = this.config.getReadPaths().iterator();
        this.readfileindex = 0;
        while (it.hasNext()) {
            String filename = (String)it.next();
            this.exceptionHolder = new CompoundGOFlatFileParseException(this.hideDownstream);
            this.parentageList = new Vector();
            HashMap termHash = new HashMap();
            OBOClass term = this.getTerms(allterms, filename);
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            this.checkParentage(allterms, this.parentageList, filename);
            if (root == null) {
                root = term;
                rootfile = filename;
            } else if (!term.getName().equals(root.getName()) || !term.getID().equals(root.getID())) {
                throw new DataAdapterException(rootfile + " and " + filename + " have different root " + "terms!");
            }
            ++this.readfileindex;
        }
        if (this.config.getDefFilename() != null) {
            this.populateDefinitions(allterms, this.config.getDefFilename());
            ++this.readfileindex;
        }
        this.parentageList.removeAllElements();
        return root;
    }

    protected static void println(PrintStream stream) {
        GOFlatFileAdapter.println(stream, "");
    }

    protected static void println(PrintStream stream, String string) {
        stream.print(string + "\n");
    }

    public void checkParentage(Map allterms, Vector parentageList, String filename) throws DataAdapterException {
        HashMap parentCounter = new HashMap();
        CompoundGOFlatFileParseException parentageErrors = new CompoundGOFlatFileParseException(this.hideDownstream);
        for (int i = 0; i < parentageList.size(); ++i) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            ParentageHolder ph = (ParentageHolder)parentageList.get(i);
            OBOClass term = (OBOClass)allterms.get(ph.childID);
            OBOClass parent = (OBOClass)allterms.get(ph.parentid);
            OBOProperty type = this.convertCharToType(ph.type);
            if (type == null) {
                type = FAILED_TYPE;
                parentageErrors.addException(new GOFlatFileParseException("Unrecognized parentage character \"" + ph.type + "\"", filename, ph.line, ph.lineNumber, ph.colNumber));
            }
            if (parent == null) {
                parentageErrors.addException(new GOFlatFileParseException("No term exists with ID " + ph.parentid, filename, ph.line, ph.lineNumber, ph.colNumber));
                continue;
            }
            Vector trs = this.getTRsForParentWithID(term, ph.parentid);
            if (trs.size() != 0) {
                if (this.strictParentage) {
                    parentageErrors.addException(new GOFlatFileParseException(ph.parentid + " is listed as parent of " + ph.childID + ", " + "but " + ph.childID + " does not appear in " + "the file as a child of " + ph.parentid, filename, ph.line, ph.lineNumber, ph.colNumber));
                } else {
                    OBORestrictionImpl tr = new OBORestrictionImpl((LinkedObject)term, parent, type);
                    parent.addChild(tr);
                }
            }
            if (this.config.getAllowCycles() || !TermUtil.hasAncestor(parent, term)) continue;
            parentageErrors.addException(new GOFlatFileParseException("This relationship would create a cycle.", filename, ph.line, ph.lineNumber, ph.colNumber));
            throw parentageErrors;
        }
        if (!parentageErrors.isEmpty()) {
            throw parentageErrors;
        }
    }

    protected static boolean contains(OBOClass a, OBOClass b) {
        return GOFlatFileAdapter.contains(a, b, new HashMap());
    }

    private static boolean contains(OBOClass a, OBOClass b, Map lookedAt) {
        if (a == b || lookedAt.containsKey(a)) {
            return true;
        }
        lookedAt.put(a, a);
        for (Link tr : a.getChildren()) {
            OBOClass child = (OBOClass)tr.getChild();
            try {
                if (!GOFlatFileAdapter.contains(child, b, lookedAt)) continue;
                return true;
            }
            catch (Throwable ex) {
                logger.info((Object)("got " + ex));
                System.exit(1);
            }
        }
        return false;
    }

    public Vector getTRsForParentWithID(OBOClass child, String id) {
        Vector<Link> out = new Vector<Link>();
        Vector<Link> parents = new Vector<Link>(child.getParents());
        block0: for (int i = 0; i < parents.size(); ++i) {
            Link tr = parents.get(i);
            Vector<String> ids = new Vector<String>();
            ids.addAll(((AnnotatedObject)((Object)tr.getParent())).getSecondaryIDs());
            ids.add(tr.getParent().getID());
            for (int j = 0; j < ids.size(); ++j) {
                String pid = (String)ids.get(j);
                if (!tr.getParent().getID().equals(pid)) continue;
                out.add(tr);
                continue block0;
            }
        }
        return out;
    }

    public OBOClass findTermInHash(OBOClass term, Map hash) {
        if (hash.containsKey(term.getID())) {
            return (OBOClass)hash.get(term.getID());
        }
        return null;
    }

    public void putTermInHash(OBOClass term, Map hash) {
        hash.put(term.getID(), term);
    }

    public OBOClass getTerms(Map allterms, String filename) throws DataAdapterException {
        OBOClass oldTerm = null;
        this.root = null;
        this.termStack = new Stack();
        int currentDepth = 0;
        int lineNumber = 0;
        String currentLine = null;
        boolean inputStarted = false;
        String leaderComment = null;
        try {
            BufferedReader reader = this.openReader(filename);
            File file = new File(filename);
            String nsName = file.getName();
            String shortfilename = file.getName();
            for (file = file.getParentFile(); file != null && this.nsHash.containsKey(nsName.toString()); file = file.getParentFile()) {
                nsName = file.getName() + "/" + nsName;
            }
            if (file == null && this.nsHash.containsKey(nsName)) {
                int i = 1;
                while (this.nsHash.containsKey(nsName + "_" + i)) {
                    ++i;
                }
                nsName = nsName + "_" + i;
            }
            Namespace ns = new Namespace(nsName, filename);
            this.nsHash.put(nsName, ns);
            this.setProgressString("Parsing " + shortfilename + "...");
            long loopstart = System.currentTimeMillis();
            while ((currentLine = reader.readLine()) != null) {
                GOFlatFileParseException ex;
                GOFlatFileParseException ex2;
                ++lineNumber;
                if (currentLine.trim().length() == 0) {
                    GOFlatFileParseException ex3 = new GOFlatFileParseException("Blank lines are not allowed", filename, currentLine, lineNumber, 1);
                    this.exceptionHolder.addException(ex3);
                    continue;
                }
                if (this.isComment(currentLine)) {
                    if (inputStarted) continue;
                    String commentLine = currentLine.substring(1);
                    if (commentLine.startsWith("type:")) {
                        commentLine = commentLine.substring(5).trim();
                        StringTokenizer stringTokenizer = new StringTokenizer(commentLine);
                        try {
                            String typeName;
                            String typeChar = stringTokenizer.nextToken();
                            String typeDesc = typeName = stringTokenizer.nextToken();
                            boolean first = true;
                            while (stringTokenizer.hasMoreTokens()) {
                                if (!first) {
                                    typeDesc = typeDesc + " " + stringTokenizer.nextToken();
                                    continue;
                                }
                                first = false;
                                typeDesc = stringTokenizer.nextToken();
                            }
                            this.addTypeMapping(new CharTypeMapping(typeChar, typeName, typeDesc));
                        }
                        catch (NoSuchElementException ex4) {}
                        continue;
                    }
                    if (leaderComment == null || leaderComment.length() == 0) {
                        leaderComment = commentLine;
                        continue;
                    }
                    leaderComment = leaderComment + "\n" + commentLine;
                    continue;
                }
                inputStarted = true;
                int oldDepth = currentDepth;
                currentDepth = this.countLeadingSpaces(currentLine);
                OBOClass term = this.parseLine(filename, currentLine, lineNumber, allterms);
                if (this.root == null && currentDepth > 0) {
                    ex2 = new GOFlatFileParseException("Bad indentation. The first line of a file must not be indented. root = " + this.root + ", currentDepth = " + currentDepth, filename, currentLine, lineNumber, 1);
                    this.exceptionHolder.addException(ex2);
                    throw this.exceptionHolder;
                }
                if (this.root == null && !this.currentType.equals("$")) {
                    ex2 = new GOFlatFileParseException("Bad root symbol. The root term must always be listed with the $ symbol.", filename, currentLine, lineNumber, 1);
                    this.exceptionHolder.addException(ex2);
                    throw this.exceptionHolder;
                }
                if (term == null) break;
                OBOClass found = (OBOClass)allterms.get(term.getID());
                if (found != null) {
                    if (!found.getName().equals(term.getName())) {
                        ex = new GOFlatFileParseException("Misspelled term name or illegal reuse of a GO ID. This term was previously defined with the name \"" + found.getName() + "\", but new name is \"" + term.getName() + "\".", filename, currentLine, lineNumber, 1);
                        this.exceptionHolder.addException(ex);
                    }
                    term = found;
                } else {
                    this.putTermInHash(term, allterms);
                }
                term.setNamespace(ns);
                if (oldDepth > currentDepth) {
                    for (int i = 0; i < oldDepth - currentDepth; ++i) {
                        this.termStack.pop();
                    }
                } else if (oldDepth < currentDepth) {
                    if (currentDepth - oldDepth != 1) {
                        ex = new GOFlatFileParseException("Bad indentation. No line may be greater than 1 space deeper than its parent.", filename, currentLine, lineNumber, 1);
                        this.exceptionHolder.addException(ex);
                        throw this.exceptionHolder;
                    }
                    this.termStack.push(oldTerm);
                }
                if (this.termStack.size() > 0) {
                    OBOClass parent = (OBOClass)this.termStack.peek();
                    if (!this.config.getAllowCycles() && TermUtil.hasAncestor(parent, term)) {
                        GOFlatFileParseException ex5 = new GOFlatFileParseException("Attempt to make " + term.getID() + " an " + "ancestor of itself. This could be a " + "structural error, or it could be caused " + "by the improper reuse of a go id.", filename, currentLine, lineNumber, 1);
                        this.exceptionHolder.addException(ex5);
                        throw this.exceptionHolder;
                    }
                    OBOProperty relType = this.convertCharToType(this.currentType);
                    if (relType == null) {
                        relType = FAILED_TYPE;
                        GOFlatFileParseException ex6 = new GOFlatFileParseException("Unrecognized type character \"" + this.currentType + "\"", filename, currentLine, lineNumber, 1);
                        this.exceptionHolder.addException(ex6);
                    }
                    OBORestrictionImpl newTR = new OBORestrictionImpl((LinkedObject)term, relType, parent);
                    term.addParent(newTR);
                } else if (this.root == null) {
                    this.root = term;
                } else if (currentDepth - oldDepth != 1) {
                    GOFlatFileParseException ex7 = new GOFlatFileParseException("Attempt to assign second root term.", filename, currentLine, lineNumber, 1);
                    this.exceptionHolder.addException(ex7);
                    throw this.exceptionHolder;
                }
                oldTerm = term;
            }
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.trim().length() <= 0) continue;
                GOFlatFileParseException ex = new GOFlatFileParseException("Data after end of file token found.", filename, currentLine, lineNumber, 1);
                this.exceptionHolder.addException(ex);
                throw this.exceptionHolder;
            }
            if (this.root == null) {
                GOFlatFileParseException ex = new GOFlatFileParseException("File contains no data.", filename, "", 0, 1);
                this.exceptionHolder.addException(ex);
            }
            if (!this.exceptionHolder.isEmpty()) {
                throw this.exceptionHolder;
            }
            if (leaderComment != null && leaderComment.length() > 0) {
                this.history.getCurrentHistory().setComment(leaderComment);
            }
            return this.root;
        }
        catch (NoSuchElementException e) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected end of line during term definition. (There may be other errors after this one).", filename, currentLine, lineNumber, currentLine.length());
            this.exceptionHolder.addException(ex);
            throw this.exceptionHolder;
        }
        catch (FileNotFoundException e) {
            throw new DataAdapterException("Cannot find " + filename);
        }
        catch (IOException e) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            throw new DataAdapterException("File unreadable", (Throwable)e);
        }
    }

    protected boolean isComment(String in) {
        return in.charAt(0) == '!';
    }

    protected OBOClass parseLine(String filename, String line, int lineNum, Map allterms) throws GOFlatFileParseException {
        Queue tokenList = this.getQueueForLine(filename, line, lineNum, allterms);
        if (((GOToken)tokenList.peek()).getToken().equals("$") && tokenList.size() == 1) {
            return null;
        }
        OBOClass t = this.getTermFromTokens(tokenList, filename, line, lineNum, allterms);
        return t;
    }

    protected OBOClass getTermFromTokens(Queue tokens, String filename, String line, int lineNum, Map allterms) throws GOFlatFileParseException {
        IDWrapper id;
        OBOClassImpl term;
        this.currentType = this.pullOffType(tokens);
        if (tokens.size() == 0) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Expected term name, found nothing.", filename, line, lineNum, 0);
            this.exceptionHolder.addException(ex);
            return new OBOClassImpl(null);
        }
        GOToken toptoken = (GOToken)tokens.peek();
        String currentLine = toptoken.getLine();
        String currentFilename = toptoken.getFilename();
        int currentLineNumber = toptoken.getLineNumber();
        String name = this.pullOffTerm(tokens);
        GOToken semicolonToken = (GOToken)tokens.dequeue();
        if (!semicolonToken.getToken().equals(";")) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Expected \";\" instead of \"" + semicolonToken.getToken() + "\"", semicolonToken.getFilename(), semicolonToken.getLine(), semicolonToken.getLineNumber(), semicolonToken.getColNumber());
            this.exceptionHolder.addException(ex);
        }
        if ((term = (OBOClassImpl)allterms.get((id = this.pullOffID(tokens, this.exceptionHolder)).toString())) != null) {
            this.dummyTerm.setName(name);
            this.dummyTerm.setID(id.toString());
            return this.dummyTerm;
        }
        term = new OBOClassImpl(name, id.toString());
        try {
            Vector altids = this.pullOffIDList(tokens);
            term.getSecondaryIDs().addAll(altids);
            Vector<DbxrefImpl> dbxrefs = new Vector<DbxrefImpl>();
            Vector<SynonymImpl> synonyms = new Vector<SynonymImpl>();
            while (!tokens.isEmpty()) {
                GOToken token = (GOToken)tokens.dequeue();
                if (this.convertCharToType(token.getToken()) != null) {
                    this.discardParentageTokens(token, id.toString(), tokens);
                    continue;
                }
                if (token.getToken().equals(";")) {
                    GOToken keytoken = (GOToken)tokens.dequeue();
                    String key = keytoken.getToken();
                    token = (GOToken)tokens.dequeue();
                    if (!token.getToken().equals(":")) {
                        GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected seperator \"" + token.getToken() + "\" found. Expected \":\"", token.getFilename(), token.getLine(), token.getLineNumber(), token.getColNumber());
                        this.exceptionHolder.addException(ex);
                    }
                    String value = this.pullOffValues(tokens);
                    if (key.equals("synonym")) {
                        synonyms.add(new SynonymImpl(value));
                        continue;
                    }
                    dbxrefs.add(new DbxrefImpl(key, value, 3));
                    continue;
                }
                GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected character " + token.getToken(), token.getFilename(), token.getLine(), token.getLineNumber(), token.getColNumber());
                this.exceptionHolder.addException(ex);
            }
            term.getSynonyms().addAll(synonyms);
            term.getDbxrefs().addAll(dbxrefs);
        }
        catch (NoSuchElementException e) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected end of line ", currentFilename, currentLine, currentLineNumber, currentLine.length());
            this.exceptionHolder.addException(ex);
        }
        return term;
    }

    protected Dbxref decodeDbxref(GOToken keyToken, String dbxrefString) throws GOFlatFileParseException {
        int type;
        int colonloc = dbxrefString.indexOf(":");
        if (colonloc == -1) {
            throw new GOFlatFileParseException("Expected : in dbxref definition", keyToken.getFilename(), keyToken.getLine(), keyToken.getLineNumber(), keyToken.getColNumber());
        }
        int startQuote = dbxrefString.indexOf("\"", colonloc);
        if (startQuote == -1) {
            throw new GOFlatFileParseException("Expected open \" in dbxref definition", keyToken.getFilename(), keyToken.getLine(), keyToken.getLineNumber(), keyToken.getColNumber());
        }
        int endQuote = dbxrefString.lastIndexOf("\"");
        if (startQuote == -1) {
            throw new GOFlatFileParseException("Expected closing \" in dbxref definition", keyToken.getFilename(), keyToken.getLine(), keyToken.getLineNumber(), keyToken.getColNumber());
        }
        String key = dbxrefString.substring(0, colonloc).trim();
        String val = dbxrefString.substring(colonloc + 1, startQuote - 1).trim();
        String desc = dbxrefString.substring(startQuote + 1, endQuote).trim();
        String typeStr = dbxrefString.substring(endQuote + 1, dbxrefString.length()).trim();
        if (typeStr.equals("ANT")) {
            type = 0;
        } else if (typeStr.equals("SYN")) {
            type = 1;
        } else if (typeStr.equals("DEF")) {
            type = 2;
        } else if (typeStr.equals("ANA")) {
            type = 3;
        } else if (typeStr.equals("UNK")) {
            type = -1;
        } else {
            throw new GOFlatFileParseException("Expected dbxref type tag  (ANT, ANA, SYN, DEF, UNK) in dbxref definition; found " + typeStr, keyToken.getFilename(), keyToken.getLine(), keyToken.getLineNumber(), keyToken.getColNumber());
        }
        DbxrefImpl dbxref = new DbxrefImpl(key, val, desc, type);
        return dbxref;
    }

    protected String pullOffValues(Queue tokens) {
        GOToken token = (GOToken)tokens.dequeue();
        String value = token.getToken();
        while (!(tokens.isEmpty() || ((GOToken)tokens.peek()).getToken().equals(";") || ((GOToken)tokens.peek()).getToken().charAt(0) == '@' || ((GOToken)tokens.peek()).getToken().length() == 1 && this.convertCharToType(((GOToken)tokens.peek()).getToken()) != null)) {
            GOToken currentToken = (GOToken)tokens.dequeue();
            if (!currentToken.isFlush()) {
                value = value + " ";
            }
            value = value + currentToken.getToken();
        }
        return value;
    }

    protected void discardParentageTokens(GOToken typeToken, String id, Queue tokens) throws GOFlatFileParseException {
        String name = this.pullOffTerm(tokens);
        if (tokens.size() < 1) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Expected ; ", typeToken.getFilename(), typeToken.getLine(), typeToken.getLineNumber(), typeToken.getColNumber());
            this.exceptionHolder.addException(ex);
            return;
        }
        GOToken token = (GOToken)tokens.dequeue();
        if (!token.getToken().equals(";")) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Expected ; instead of " + token.getToken(), token.getFilename(), token.getLine(), token.getLineNumber(), token.getColNumber());
            this.exceptionHolder.addException(ex);
        } else {
            String parentid = this.pullOffID(tokens, this.exceptionHolder).toString();
            ParentageHolder ph = new ParentageHolder();
            ph.parentid = parentid;
            ph.childID = id;
            ph.name = name;
            ph.line = typeToken.getLine();
            ph.lineNumber = typeToken.getLineNumber();
            ph.colNumber = typeToken.getColNumber();
            ph.type = typeToken.getToken();
            this.parentageList.addElement(ph);
        }
    }

    protected Vector pullOffIDList(Queue tokens) throws GOFlatFileParseException {
        Vector<String> ids = new Vector<String>();
        while (!tokens.isEmpty() && ((GOToken)tokens.peek()).getToken().equals(",")) {
            tokens.dequeue();
            ids.add(this.pullOffID(tokens, this.exceptionHolder).toString());
        }
        return ids;
    }

    protected String pullOffType(Queue tokens) throws GOFlatFileParseException {
        GOToken token = (GOToken)tokens.dequeue();
        String type = token.getToken();
        if (!type.equals("$") && this.convertCharToType(type) == null) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Unrecognized type character '" + type + "' found. condition 1", token.getFilename(), token.getLine(), token.getLineNumber(), token.getColNumber());
            this.exceptionHolder.addException(ex);
            type = "";
        }
        return type;
    }

    protected String pullOffTerm(Queue tokens) {
        String name = ((GOToken)tokens.dequeue()).getToken();
        while (!tokens.isEmpty() && !((GOToken)tokens.peek()).getToken().equals(";") && this.convertCharToType(((GOToken)tokens.peek()).getToken()) == null) {
            GOToken token = (GOToken)tokens.dequeue();
            if (!token.isFlush()) {
                name = name + " ";
            }
            name = name + token.getToken();
        }
        return name;
    }

    protected boolean isNextItemID(Queue tokens) {
        if (tokens.size() < 3) {
            return false;
        }
        String prefix = ((GOToken)tokens.peekAt(0)).getToken();
        GOToken token = (GOToken)tokens.peekAt(1);
        if (!token.getToken().equals(":")) {
            return false;
        }
        token = (GOToken)tokens.peekAt(2);
        try {
            Integer.parseInt(token.getToken());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected IDWrapper pullOffID(Queue tokens, CompoundGOFlatFileParseException exList) throws GOFlatFileParseException {
        String prefix = ((GOToken)tokens.dequeue()).getToken();
        GOToken token = (GOToken)tokens.dequeue();
        if (!token.getToken().equals(":")) {
            GOFlatFileParseException ex = new GOFlatFileParseException("Unexpected GO ID seperator " + token.getToken() + " found. Expected :", token.getFilename(), token.getLine(), token.getLineNumber(), token.getColNumber());
            exList.addException(ex);
        }
        token = (GOToken)tokens.dequeue();
        return new IDWrapper(prefix, token.getToken());
    }

    protected Queue getQueueForLine(String filename, String in, int lineNum, Map allterms) throws GOFlatFileParseException {
        GOToken token;
        Queue queue = new Queue();
        this.tokenizer.setStrings(filename, in, lineNum);
        while ((token = this.tokenizer.getNextToken()) != null) {
            queue.enqueue(token);
        }
        return queue;
    }

    protected int countLeadingSpaces(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return line.length();
    }

    public String getID() {
        return "OBO:GOFlatFileAdapter";
    }

    public String getName() {
        return "GO Flat File Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{OBOAdapter.READ_ONTOLOGY, OBOAdapter.WRITE_ONTOLOGY};
        return supported;
    }

    public void init(Object params) throws DataAdapterException {
    }

    public OBOSession write(OBOSession history) throws DataAdapterException {
        List<SaveRecord> saveRecords;
        this.history = history;
        this.initTypeMappings();
        this.writeStreamList.clear();
        this.printStreamList.clear();
        for (CharTypeMapping ctm : this.config.getTypeMappings()) {
            this.addTypeMapping(ctm);
        }
        LinkedHashSet<IdentifiedObject> trueroots = new LinkedHashSet<IdentifiedObject>();
        for (IdentifiedObject io : history.getObjects()) {
            if (!(io instanceof OBOClass) || ((OBOClass)io).getParents().size() != 0 || TermUtil.isObsolete(io) || io.isBuiltIn()) continue;
            trueroots.add(io);
        }
        if (this.config.getBasicSave()) {
            saveRecords = new LinkedList();
            saveRecords.add(new SaveRecord(null, this.config.getWritePath()));
        } else {
            saveRecords = this.config.getSaveRecords();
        }
        Iterator<Object> it = saveRecords.iterator();
        Vector<OBOClass> roots = new Vector<OBOClass>();
        while (it.hasNext()) {
            OBOClass term;
            SaveRecord sr = (SaveRecord)it.next();
            OBOClass root = (OBOClass)trueroots.iterator().next();
            if (sr.getID() == null) {
                if (trueroots.size() > 1) {
                    throw new DataAdapterException("Cannot write multiply rooted file to this format, roots = " + trueroots);
                }
                term = root;
            } else {
                term = (OBOClass)TermUtil.cloneParentTree((LinkedObject)history.getObject(sr.getID()));
            }
            roots.add(term);
            Vector<OBOProperty> relationshipTypes = new Vector<OBOProperty>(TermUtil.getRelationshipTypes(history));
            this.write(sr.getFilename(), sr.getDefFilename(), term, relationshipTypes, new Vector<TermSubset>(history.getSubsets()), OBOProperty.IS_A);
        }
        if (!this.config.getBasicSave()) {
            this.writeDefinitions(roots);
        }
        for (PrintStream sfos : this.printStreamList) {
            sfos.close();
            if (!sfos.checkError()) continue;
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            throw new DataAdapterException("Failed while trying to close file");
        }
        return history;
    }

    public OBOProperty getDefaultType() {
        return OBOProperty.IS_A;
    }

    public void write(String filename, String defFilename, OBOClass root, Vector relationshipTypes, Vector categories, OBOProperty defaultType) throws DataAdapterException {
        this.writeRoot = root;
        try {
            Collection<LinkedObject> terms = TermUtil.getDescendants(root, true);
            if (filename != null) {
                Map<String, IdentifiedObject> h = TermUtil.createIDMap(terms);
                int termCount = h.size();
                h = null;
                SafeFileOutputStream rawstream = new SafeFileOutputStream(filename);
                this.writeStreamList.add(rawstream);
                PrintStream stream = new PrintStream(new BufferedOutputStream((OutputStream)rawstream));
                this.printStreamList.add(stream);
                this.writeHeader(root, relationshipTypes, categories, defaultType, stream);
                this.setProgressString("Writing terms " + (filename != null ? "to file " + filename : "") + "...");
                this.writeTerm(filename, stream, 0, "$", root, null, true, new HashMap(), termCount);
            }
            if (defFilename != null) {
                this.writeDefinitionsForTerms(terms, defFilename);
            }
        }
        catch (IOException e) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            throw new DataAdapterException(e.getMessage(), (Throwable)e);
        }
    }

    public void writeDefinitions(Vector roots) throws DataAdapterException {
        HashSet<OBOClass> set = new HashSet<OBOClass>();
        for (int i = 0; i < roots.size(); ++i) {
            for (OBOClass oBOClass : TermUtil.getDescendants((OBOClass)roots.get(i), true)) {
                set.add(oBOClass);
            }
        }
        this.writeDefinitionsForTerms(set);
    }

    public void writeDefinitionsForTerms(Collection t) throws DataAdapterException {
        this.writeDefinitionsForTerms(t, this.config.getSaveDefFilename());
    }

    public void writeDefinitionsForTerms(Collection t, String defFilename) throws DataAdapterException {
        try {
            if (defFilename != null && defFilename.length() > 0) {
                SafeFileOutputStream rawstream = new SafeFileOutputStream(defFilename);
                this.writeStreamList.add(rawstream);
                PrintStream stream = new PrintStream(new BufferedOutputStream((OutputStream)rawstream));
                this.printStreamList.add(stream);
                Vector terms = new Vector();
                terms.addAll(t);
                this.writeDefs(defFilename, stream, terms);
            }
        }
        catch (IOException e) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            throw new DataAdapterException(e.getMessage());
        }
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setAutogenString(String autogen) {
        this.autogen = autogen;
    }

    public String getAutogenString() {
        return this.autogen;
    }

    protected void writeDefs(String filename, PrintStream stream, Vector terms) throws DataAdapterException {
        Collections.sort(terms);
        GOFlatFileAdapter.println(stream, "!version: $Revision: 1.21 $");
        GOFlatFileAdapter.println(stream, "!date:                 " + new Date());
        if (this.getUserName() == null) {
            GOFlatFileAdapter.println(stream, "!saved-by: " + System.getProperty("user.name"));
        } else {
            GOFlatFileAdapter.println(stream, "!saved-by: " + this.getUserName());
        }
        if (this.autogen != null) {
            GOFlatFileAdapter.println(stream, "!autogenerated-by: " + this.autogen);
        }
        GOFlatFileAdapter.println(stream, "!");
        GOFlatFileAdapter.println(stream, "!Gene Ontology definitions");
        GOFlatFileAdapter.println(stream, "!");
        int index = 0;
        int oldProgress = -1;
        this.setProgressString("Writing definitions " + (filename != null ? "to file " + filename : "") + "...");
        Iterator e = terms.iterator();
        while (e.hasNext()) {
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
            int progress = 100 * index / terms.size();
            this.setProgressValue(progress);
            this.setProgressString(this.progressString);
            OBOClass term = (OBOClass)e.next();
            if (term.getDefinition() != null && term.getDefinition().length() > 0) {
                this.writeDef(stream, term);
            }
            ++index;
        }
    }

    protected static String unescapeDefText(String def) {
        if (def == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        boolean escape = false;
        for (int i = 0; i < def.length(); ++i) {
            char c = def.charAt(i);
            if (!escape) {
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                out.append(c);
                continue;
            }
            escape = false;
            if (c == '\\') {
                out.append('\\');
                continue;
            }
            if (c != 'n') continue;
            out.append('\n');
        }
        return out.toString();
    }

    protected static String escapeDefText(String def) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < def.length(); ++i) {
            char c = def.charAt(i);
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c == '\r') {
                out.append("\\n");
                continue;
            }
            if (c == '\n') {
                out.append("\\n");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    protected void writeDef(PrintStream stream, OBOClass term) {
        GOFlatFileAdapter.println(stream, "term: " + term.getName());
        if (this.useLegacyTypes()) {
            GOFlatFileAdapter.println(stream, "goid: " + term.getID());
        } else {
            GOFlatFileAdapter.println(stream, "id: " + term.getID());
        }
        GOFlatFileAdapter.println(stream, "definition: " + GOFlatFileAdapter.escapeDefText(term.getDefinition()));
        for (Dbxref ref : term.getDefDbxrefs()) {
            GOFlatFileAdapter.println(stream, "definition_reference: " + ref.getDatabase() + ":" + ref.getDatabaseID());
        }
        if (!RootAlgorithm.STRICT.isRoot(term) && term.getComment() != null && term.getComment().length() > 0) {
            GOFlatFileAdapter.println(stream, "comment: " + GOFlatFileAdapter.escapeDefText(term.getComment()));
        }
        GOFlatFileAdapter.println(stream);
    }

    protected void writeHeader(OBOClass root, Vector relationshipTypes, Vector categories, OBOProperty defaultType, PrintStream stream) throws DataAdapterException {
        int i;
        String comment = this.config.getComment();
        if (comment == null) {
            comment = root.getComment();
        }
        Vector<String> commentList = new Vector<String>();
        if (comment != null) {
            StringTokenizer tokenizer = new StringTokenizer(comment, "\n\r");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("date") || token.startsWith("saved-by") || token.startsWith("autogenerated-by") || token.startsWith("version") || token.startsWith("type")) continue;
                commentList.add(token);
            }
        }
        if (this.getAutogenString() != null) {
            GOFlatFileAdapter.println(stream, "!autogenerated-by:     " + this.getAutogenString());
        }
        if (this.getUserName() != null) {
            GOFlatFileAdapter.println(stream, "!saved-by:             " + this.getUserName());
        }
        GOFlatFileAdapter.println(stream, "!date:                 " + new Date());
        GOFlatFileAdapter.println(stream, "!version: $Revision: 1.21 $");
        if (defaultType != null) {
            this.writeTypeLine(defaultType, stream);
        }
        for (i = 0; i < relationshipTypes.size(); ++i) {
            OBOProperty trt = (OBOProperty)relationshipTypes.get(i);
            if (defaultType != null && defaultType.equals(trt)) continue;
            this.writeTypeLine(trt, stream);
        }
        for (i = 0; i < commentList.size(); ++i) {
            GOFlatFileAdapter.println(stream, "!" + commentList.get(i));
        }
    }

    public void writeTypeLine(OBOProperty trt, PrintStream stream) throws DataAdapterException {
        if (trt.isBuiltIn() && !TermUtil.isUsed(this.history, trt)) {
            return;
        }
        String propid = trt.getID();
        if (this.config.getTranslateTypes() && IDMAPPINGS.get(trt.getID()) != null) {
            propid = (String)IDMAPPINGS.get(trt.getID());
        }
        if (this.useLegacyTypes()) {
            String typeStr = this.convertTypeToChar(trt);
            if (typeStr == null) {
                throw new DataAdapterException("Couldn't find a relationship character for relationship type " + trt);
            }
            GOFlatFileAdapter.println(stream, "!type: " + typeStr + " " + propid + " " + trt.getName());
        } else {
            GOFlatFileAdapter.println(stream, "!type: @" + propid + "@ " + propid + " " + trt.getName());
            this.addTypeMapping("@" + propid + "@", trt);
        }
    }

    public void setUseLegacyTypes(boolean useLegacyTypes) {
        this.config.setUseLegacyTypes(useLegacyTypes);
    }

    public boolean useLegacyTypes() {
        return this.config.getUseLegacyTypes();
    }

    protected void writeTerm(String filename, PrintStream stream, int spaceDepth, String leaderChar, OBOClass term, OBOClass currentParent, boolean treatAsRoot, Map lookedAt, int termCount) throws DataAdapterException {
        if (this.cancelled) {
            throw new CancelledAdapterException();
        }
        boolean isCycle = false;
        if (lookedAt.containsKey(term) && (this.config.getReduceSize() || (isCycle = TermUtil.hasAncestor(term, term)))) {
            if (this.config.getAllowCycles() || this.config.getReduceSize() && !isCycle) {
                return;
            }
            throw new DataAdapterException("File contains a cycle! OBOClass " + term + " (ID = " + term.getID() + ") is its own parent!");
        }
        if (!treatAsRoot) {
            this.setProgressValue(100 * lookedAt.size() / termCount);
            lookedAt.put(term, term);
        }
        this.writeLineForTerm(stream, spaceDepth, leaderChar, term, currentParent, treatAsRoot);
        Vector children = VectorUtil.transform((VectorTransformer)new RelToHolderTransformation(false), new Vector<Link>(term.getChildren()));
        Collections.sort(children);
        for (int i = 0; i < children.size(); ++i) {
            Link tr = ((RelationshipHolder)children.get(i)).getRelationship();
            this.writeTerm(filename, stream, spaceDepth + 1, this.getCharForRelationship(tr), (OBOClass)tr.getChild(), term, false, lookedAt, termCount);
        }
    }

    protected void writeLineForTerm(PrintStream stream, int spaceDepth, String leaderChar, OBOClass term, OBOClass currentParent, boolean treatAsRoot) {
        if (treatAsRoot) {
            leaderChar = "$";
        }
        String output = this.getNChars(spaceDepth, ' ') + leaderChar + this.getTermString(term) + this.getSecondaryIDString(term) + this.getDbxrefString(term) + this.getSynonymString(term) + (treatAsRoot ? "" : this.getParentString(term, currentParent));
        GOFlatFileAdapter.println(stream, output);
    }

    protected String getDbxrefString(OBOClass term) {
        StringBuffer out = new StringBuffer();
        scratchVector.clear();
        Iterator<Dbxref> it = term.getDbxrefs().iterator();
        while (it.hasNext()) {
            VectorUtil.insertSorted((List)scratchVector, (Comparator)dbxrefComparator, (Object)it.next());
        }
        for (int i = 0; i < scratchVector.size(); ++i) {
            Dbxref ref = (Dbxref)scratchVector.get(i);
            out.append(" ; " + this.escape(ref.getDatabase()) + ":" + this.escape(ref.getDatabaseID()));
        }
        return out.toString();
    }

    protected String getSynonymString(OBOClass term) {
        StringBuffer out = new StringBuffer();
        scratchVector.clear();
        scratchVector.addAll(term.getSynonyms());
        Collections.sort(scratchVector, Synonym.COMPARATOR);
        for (int i = 0; i < scratchVector.size(); ++i) {
            Synonym syn = (Synonym)scratchVector.get(i);
            out.append(this.formatSynonym(syn));
        }
        return out.toString();
    }

    protected String formatSynonym(Synonym syn) {
        return " ; synonym:" + this.escape(syn.getText());
    }

    protected String getParentString(OBOClass term, OBOClass parent) {
        StringBuffer out = new StringBuffer();
        scratchVector.clear();
        Iterator<Link> it = term.getParents().iterator();
        while (it.hasNext()) {
            VectorUtil.insertSorted((List)scratchVector, (Comparator)relByParentComparator, (Object)it.next());
        }
        for (int i = 0; i < scratchVector.size(); ++i) {
            Link tr = (Link)scratchVector.get(i);
            if (tr.getParent().getID().equals(parent.getID()) || !TermUtil.hasAncestor(tr.getParent(), this.writeRoot) && !tr.getParent().equals(this.writeRoot)) continue;
            out.append(" " + this.getCharForRelationship(tr) + " " + this.getTermString((OBOClass)tr.getParent()));
        }
        return out.toString();
    }

    protected String getCharForRelationship(OBOProperty type) {
        String c = this.convertTypeToChar(type);
        if (c == null) {
            return "?";
        }
        return c;
    }

    protected String getCharForRelationship(Link tr) {
        return this.getCharForRelationship(tr.getType());
    }

    protected String escape(String text) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isISOControl(c) || Character.isIdentifierIgnorable(c) || c == '\n' || c == '\r') continue;
            if (GOFlatFileAdapter.isReservedCharacter(c) || this.convertCharToType(c + "") != null) {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    protected String getTermString(OBOClass term) {
        if (term.getID() == null) {
            new Exception("unexpected condition encountered!").printStackTrace();
        }
        return this.escape(term.getName()) + " ; " + term.getID();
    }

    protected String getSecondaryIDString(OBOClass term) {
        String trailingIDs = "";
        if (term.getSecondaryIDs().size() > 0) {
            Iterator<String> it = term.getSecondaryIDs().iterator();
            scratchVector.clear();
            while (it.hasNext()) {
                VectorUtil.insertSorted((List)scratchVector, (Comparator)idComparator, (Object)it.next());
            }
            for (int i = 0; i < scratchVector.size(); ++i) {
                trailingIDs = trailingIDs + ", " + (String)scratchVector.get(i);
            }
        }
        return trailingIDs;
    }

    protected String getNChars(int n, char c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.currentReader != null) {
                this.currentReader.close();
            }
            for (SafeFileOutputStream stream : this.writeStreamList) {
                stream.fail();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GraphicalUI getAdvancedUI() {
        return this.advancedUI;
    }

    public void setAdvancedUI(GraphicalUI advancedUI) {
        this.advancedUI = advancedUI;
    }

    static {
        Object junk = new Object();
        RESERVED_SYMBOLS.put(new Character(';'), junk);
        RESERVED_SYMBOLS.put(new Character('$'), junk);
        RESERVED_SYMBOLS.put(new Character(','), junk);
        RESERVED_SYMBOLS.put(new Character(':'), junk);
        RESERVED_SYMBOLS.put(new Character('!'), junk);
        RESERVED_SYMBOLS.put(new Character('\\'), junk);
        RESERVED_SYMBOLS.put(new Character('?'), junk);
        RESERVED_SYMBOLS.put(new Character('@'), junk);
        IDMAPPINGS.put("DEVELOPSFROM", "develops_from");
        IDMAPPINGS.put("DEVELOPS_FROM", "develops_from");
        IDMAPPINGS.put("ISA", "is_a");
        IDMAPPINGS.put("IS_A", "is_a");
        IDMAPPINGS.put("PARTOF", "part_of");
        IDMAPPINGS.put("PART_OF", "part_of");
    }

    protected class IDWrapper {
        String prefix;
        String id;

        public IDWrapper(String prefix, String id) {
            this.prefix = prefix;
            this.id = id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getID() {
            return this.id;
        }

        public String toString() {
            return this.prefix + ":" + this.id;
        }
    }

    private class ParentageHolder {
        public String parentid;
        public String childID;
        public String line;
        public String name;
        public String type;
        public int lineNumber;
        public int colNumber;

        private ParentageHolder() {
        }
    }

    public static class SaveRecord {
        protected String id;
        protected String filename;
        protected String defFilename;

        public SaveRecord() {
        }

        public SaveRecord(String id, String filename) {
            this.id = id;
            this.filename = filename;
        }

        public String getID() {
            return this.id;
        }

        public void setDefFilename(String defFilename) {
            this.defFilename = defFilename;
        }

        public String getDefFilename() {
            return this.defFilename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public URL getURL() {
            return GOFlatFileAdapter.getURLForPath(this.filename);
        }

        public String toString() {
            return "ID = " + this.id + ", path = " + this.filename;
        }
    }

    public static class CharTypeMapping {
        protected String typeChar;
        protected String propertyID;
        protected String propertyName;

        public CharTypeMapping() {
        }

        public CharTypeMapping(String typeChar, String propertyID, String propertyName) {
            this.setTypeChar(typeChar);
            this.setPropertyID(propertyID);
            this.setPropertyName(propertyName);
        }

        public String toString() {
            return this.propertyID;
        }

        public void setTypeChar(String typeChar) {
            this.typeChar = typeChar;
        }

        public String getTypeChar() {
            return this.typeChar;
        }

        public void setPropertyID(String propertyID) {
            this.propertyID = propertyID;
        }

        public String getPropertyID() {
            return this.propertyID;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class GOFlatFileConfiguration
    extends FileAdapterConfiguration {
        protected String defFilename;
        protected String comment;
        protected boolean hideDownstream = true;
        protected boolean allowCycles = false;
        protected boolean allowDangling = false;
        protected boolean reduceSize = false;
        protected boolean useLegacyTypes = false;
        protected boolean translateTypes = false;
        protected List saveRecords = new ArrayList();
        protected String saveDefFilename;
        protected List typeMappings = new ArrayList();
        protected boolean basicSave = false;

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public void setTypeMappings(List typeMappings) {
            this.typeMappings = typeMappings;
        }

        public List getTypeMappings() {
            return this.typeMappings;
        }

        public void setSaveDefFilename(String saveDefFilename) {
            this.saveDefFilename = saveDefFilename;
        }

        public String getSaveDefFilename() {
            return this.saveDefFilename;
        }

        public void setSaveRecords(List saveRecords) {
            this.saveRecords = saveRecords;
        }

        public List getSaveRecords() {
            return this.saveRecords;
        }

        public void setTranslateTypes(boolean translateTypes) {
            this.translateTypes = translateTypes;
        }

        public boolean getTranslateTypes() {
            return this.translateTypes;
        }

        public void setUseLegacyTypes(boolean useLegacyTypes) {
            this.useLegacyTypes = useLegacyTypes;
        }

        public boolean getUseLegacyTypes() {
            return this.useLegacyTypes;
        }

        public void setReduceSize(boolean reduceSize) {
            this.reduceSize = reduceSize;
        }

        public boolean getReduceSize() {
            return this.reduceSize;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowCycles(boolean allowCycles) {
            this.allowCycles = allowCycles;
        }

        public boolean getAllowCycles() {
            return this.allowCycles;
        }

        public void setHideDownstream(boolean hideDownstream) {
            this.hideDownstream = hideDownstream;
        }

        public boolean getHideDownstream() {
            return this.hideDownstream;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public void setDefFilename(String defFilename) {
            this.defFilename = defFilename;
        }

        public String getDefFilename() {
            return this.defFilename;
        }
    }

    protected class Queue {
        protected List contents = new Vector();

        protected Queue() {
        }

        public void enqueue(Object o) {
            this.contents.add(o);
        }

        public Object dequeue() {
            if (this.size() < 1) {
                throw new NoSuchElementException();
            }
            return this.contents.remove(0);
        }

        public Object peekAt(int index) {
            if (index >= this.size()) {
                throw new NoSuchElementException();
            }
            return this.contents.get(index);
        }

        public Object peek() {
            if (this.size() < 1) {
                throw new NoSuchElementException();
            }
            return this.contents.get(0);
        }

        public boolean isEmpty() {
            return this.contents.size() == 0;
        }

        public int size() {
            return this.contents.size();
        }
    }
}

