/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.IOUtil;
import org.obo.dataadapter.DefaultOBOParser;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOMetaData;
import org.obo.dataadapter.OBOParseEngine;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBO_1_0_Serializer;
import org.obo.dataadapter.OBO_1_2_Serializer;
import org.obo.dataadapter.ParseEngine;
import org.obo.datamodel.OBOSession;
import org.obo.identifier.IDProfile;
import org.obo.nlp.SemanticParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOFileAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(OBOFileAdapter.class);
    protected OBOAdapterConfiguration ioprofile;
    protected List progressListeners = new LinkedList();
    protected ParseEngine engine;
    protected OBOSerializationEngine serializeEngine;
    protected StringBuffer buffer = new StringBuffer();
    protected boolean cancelled = false;
    protected OBOMetaData metaData;
    protected GraphicalUI advancedUI;
    protected String userName;
    protected String autogenString;
    protected IDProfile idProfile;
    protected IOOperation<?, ?> op;

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){
            private static final long serialVersionUID = 8709597443707849569L;

            public AdapterConfiguration createEmptyConfig() {
                return new OBOAdapterConfiguration();
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                ((OBOAdapterConfiguration)this.config).setBasicSave(true);
            }
        };
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        GraphicalUI advancedUI = this.getAdvancedUI();
        if (advancedUI != null) {
            advancedUI.setSimpleUI((GraphicalUI)ui);
            ui.setAdvancedUI(advancedUI);
        }
        return ui;
    }

    public String getID() {
        return "OBO:OBO_Adapter";
    }

    public String getName() {
        return "OBO Flat File Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{READ_ONTOLOGY, WRITE_ONTOLOGY};
        return supported;
    }

    public AdapterConfiguration getConfiguration() {
        return this.ioprofile;
    }

    public String getProgressString() {
        if (this.op.equals((Object)READ_ONTOLOGY) && this.engine != null) {
            return this.engine.getProgressString();
        }
        if (this.op.equals((Object)WRITE_ONTOLOGY) && this.serializeEngine != null) {
            return this.serializeEngine.getProgressString();
        }
        return null;
    }

    public Number getProgressValue() {
        if (this.op.equals((Object)READ_ONTOLOGY) && this.engine != null) {
            return this.engine.getProgressValue();
        }
        if (this.op.equals((Object)WRITE_ONTOLOGY) && this.serializeEngine != null) {
            return this.serializeEngine.getProgressValue();
        }
        return null;
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, AdapterConfiguration configuration, INPUT_TYPE input) throws DataAdapterException {
        if (!(configuration instanceof OBOAdapterConfiguration)) {
            throw new DataAdapterException("Invalid configuration; this adapter requires an OBOAdapterConfiguration object.");
        }
        this.op = op;
        if (op.equals((Object)READ_ONTOLOGY)) {
            try {
                this.cancelled = false;
                this.ioprofile = (OBOAdapterConfiguration)configuration;
                DefaultOBOParser parser = new DefaultOBOParser();
                parser.setAllowDanglingParents(this.ioprofile.getAllowDangling());
                parser.setFailFast(this.ioprofile.getFailFast());
                parser.setFollowImports(this.ioprofile.getFollowImports());
                this.engine = new OBOParseEngine(parser);
                this.engine.setPaths(this.ioprofile.getReadPaths());
                logger.info((Object)("Reading " + this.ioprofile.getReadPaths() + "\n\t (allowDangling = " + this.ioprofile.getAllowDangling() + ")" + "\n\t (followImports = " + this.ioprofile.getFollowImports() + ")"));
                this.engine.parse();
                logger.debug((Object)"Done parsing file");
                OBOSession history = parser.getSession();
                this.metaData = parser.getMetaData();
                history.setLoadRemark(this.createLoadRemark());
                return (OUTPUT_TYPE)history;
            }
            catch (OBOParseException e) {
                e.printStackTrace();
                if (this.cancelled) {
                    throw new CancelledAdapterException();
                }
                throw new DataAdapterException((Throwable)e, "Load Error, line " + e.getLineNum());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.cancelled) {
                    throw new CancelledAdapterException();
                }
                throw new DataAdapterException(e, "Load error with path " + this.engine.getCurrentPath());
            }
        }
        if (op.equals((Object)WRITE_ONTOLOGY)) {
            try {
                this.cancelled = false;
                OBO_1_2_Serializer serializer = null;
                this.ioprofile = (OBOAdapterConfiguration)configuration;
                if (this.ioprofile.getSerializer().equals("OBO_1_2")) {
                    serializer = new OBO_1_2_Serializer();
                } else if (this.ioprofile.getSerializer().equals("OBO_1_0")) {
                    serializer = new OBO_1_0_Serializer();
                }
                if (serializer == null) {
                    throw new DataAdapterException("Could not serialize to serializer " + this.ioprofile.getSerializer());
                }
                this.serializeEngine = new OBOSerializationEngine();
                this.serializeEngine.setUsername(this.getUserName());
                this.serializeEngine.setAutogenString(this.getAutogenString());
                this.serializeEngine.setCurrentProfile(this.getIDProfile());
                LinkedList<OBOSerializationEngine.FilteredPath> filteredPaths = new LinkedList<OBOSerializationEngine.FilteredPath>();
                if (this.ioprofile.getBasicSave()) {
                    filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath()));
                } else {
                    filteredPaths.addAll(this.ioprofile.getSaveRecords());
                }
                logger.info((Object)("Writing " + filteredPaths + " (serializer = " + this.ioprofile.getSerializer() + ", basicSave = " + this.ioprofile.getBasicSave() + ")"));
                Iterator it = this.progressListeners.iterator();
                this.serializeEngine.serialize((OBOSession)input, (OBOSerializer)serializer, filteredPaths);
                return (OUTPUT_TYPE)input;
            }
            catch (DataAdapterException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new DataAdapterException("Operation " + op + " not supported!");
    }

    public void cancel() {
        this.cancelled = true;
        if (this.engine != null) {
            this.engine.cancel();
        }
        if (this.serializeEngine != null) {
            this.serializeEngine.cancel();
        }
    }

    protected String createLoadRemark() {
        StringBuffer out = new StringBuffer();
        Iterator it = this.ioprofile.getReadPaths().iterator();
        int i = 0;
        while (it.hasNext()) {
            String path = (String)it.next();
            path = IOUtil.getShortName((String)path);
            if (i != 0) {
                out.append(", ");
            }
            out.append(path);
            ++i;
        }
        return out.toString();
    }

    public OBOMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicalUI getAdvancedUI() {
        return this.advancedUI;
    }

    public void setAdvancedUI(GraphicalUI advancedUI) {
        this.advancedUI = advancedUI;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAutogenString() {
        return this.autogenString;
    }

    public void setAutogenString(String autogenString) {
        this.autogenString = autogenString;
    }

    public IDProfile getIDProfile() {
        return this.idProfile;
    }

    public void setIDProfile(IDProfile idProfile) {
        this.idProfile = idProfile;
    }

    public static class OBOAdapterConfiguration
    extends FileAdapterConfiguration {
        protected boolean allowDangling = true;
        protected boolean followImports = true;
        protected boolean failFast = false;
        protected boolean saveImplied;
        protected List saveRecords = new ArrayList();
        protected boolean basicSave = true;
        protected String serializer = "OBO_1_2";
        protected String impliedType = "Save for presentation";
        protected SemanticParser semanticParser;
        protected boolean includeExplanations = false;
        protected boolean includeNames = false;

        public void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public boolean getFailFast() {
            return this.failFast;
        }

        public String getSerializer() {
            return this.serializer;
        }

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public List getSaveRecords() {
            return this.saveRecords;
        }

        public void setSaveRecords(List saveRecords) {
            if (saveRecords.contains(null)) {
                new Exception("Null save record added to profile").printStackTrace();
            }
            this.saveRecords = saveRecords;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean getFollowImports() {
            return this.followImports;
        }

        public void setFollowImports(boolean followImports) {
            this.followImports = followImports;
        }

        public SemanticParser getSemanticParser() {
            return this.semanticParser;
        }

        public void setSemanticParser(SemanticParser semanticParser) {
            this.semanticParser = semanticParser;
        }

        public boolean isIncludeExplanations() {
            return this.includeExplanations;
        }

        public void setIncludeExplanations(boolean includeExplanations) {
            this.includeExplanations = includeExplanations;
        }

        public boolean isIncludeNames() {
            return this.includeNames;
        }

        public void setIncludeNames(boolean includeNames) {
            this.includeNames = includeNames;
        }
    }
}

