/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOMetaData {
    protected static final Logger logger = Logger.getLogger(OBOMetaData.class);
    protected Map<String, FileMetaData> files = new HashMap<String, FileMetaData>();

    protected FileMetaData getData(String file) {
        FileMetaData data = this.files.get(file);
        if (data == null) {
            data = new FileMetaData(file);
            this.files.put(file, data);
        }
        return data;
    }

    public Collection<String> getFileNames() {
        return this.files.keySet();
    }

    public String getVersion(String file) {
        FileMetaData data = this.getData(file);
        if (data != null) {
            return data.getVersion();
        }
        return null;
    }

    public Collection<Namespace> getNamespaces(String file) {
        FileMetaData data = this.getData(file);
        if (data != null) {
            return data.getNamespaces();
        }
        return null;
    }

    public void mapFileData(String file, String version) {
        FileMetaData data = this.getData(file);
        data.setVersion(version);
    }

    public void addNamespace(String file, Namespace namespace) {
        FileMetaData data = this.getData(file);
        data.addNamespace(namespace);
    }

    public Collection<String> getImports(String file) {
        FileMetaData data = this.getData(file);
        if (data != null) {
            return data.getImports();
        }
        return null;
    }

    public void addImport(String file, String importFile) {
        FileMetaData data = this.getData(file);
        data.addImport(importFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileMetaData {
        protected String file;
        protected String version;
        protected Collection<Namespace> namespaces = new LinkedList<Namespace>();
        protected Collection<String> imports = new LinkedList<String>();

        public FileMetaData(String file, String version) {
            this.file = file;
            this.version = version;
        }

        public FileMetaData(String file) {
            this.file = file;
        }

        public void addImport(String importFile) {
            this.imports.add(importFile);
        }

        public Collection<String> getImports() {
            return this.imports;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getFile() {
            return this.file;
        }

        public Collection<Namespace> getNamespaces() {
            return this.namespaces;
        }

        public void addNamespace(Namespace n) {
            if (!this.namespaces.contains(n)) {
                this.namespaces.add(n);
            }
        }
    }
}

