/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.expression.JexlContext;
import org.bbop.io.SafeFileOutputStream;
import org.bbop.util.AbstractProgressValued;
import org.obo.annotation.dataadapter.AnnotationParserExtension;
import org.obo.dataadapter.OBOConstants;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBOSerializerExtension;
import org.obo.dataadapter.PostcompParserExtension;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.ModificationMetadataObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.RootAlgorithm;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.FilteredLinkDatabase;
import org.obo.datamodel.impl.NestedValueImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.datamodel.impl.RootAlgorithmModeratedLinkDatabase;
import org.obo.filters.CompoundFilter;
import org.obo.filters.CompoundFilterImpl;
import org.obo.filters.EqualsComparison;
import org.obo.filters.Filter;
import org.obo.filters.IDSearchCriterion;
import org.obo.filters.IsPropertyCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.LinkFilterImpl;
import org.obo.filters.NamespaceSearchCriterion;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterImpl;
import org.obo.filters.SelfSearchAspect;
import org.obo.identifier.IDProfile;
import org.obo.identifier.IDRule;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerFactory;
import org.obo.reasoner.impl.LinkPileReasonerFactory;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOSerializationEngine
extends AbstractProgressValued {
    protected static final Logger logger = Logger.getLogger(OBOSerializationEngine.class);
    protected static int DONT_WRITE_ID_RULES = 0;
    protected static int WRITE_STORED_ID_RULES = 1;
    protected static int WRITE_CURRENT_ID_RULES = 2;
    public static final String SAVE_FOR_PRESENTATION = "Save for presentation";
    public static final String SAVE_ALL = "Save all links";
    protected boolean cancelled = false;
    protected List streams = new LinkedList();
    protected List closingStreams = new LinkedList();
    protected List progressListeners = new LinkedList();
    protected List<OBOSerializerExtension> extensions = new LinkedList<OBOSerializerExtension>();
    protected OBOSerializer serializer;
    protected boolean allowDangling;
    protected boolean saveImplied;
    protected ReasonerFactory reasonerFactory;
    protected boolean realizeImplied;
    protected List<OBOConstants.TagMapping> tagOrdering;
    protected List<OBOConstants.StanzaMapping> stanzaOrdering;
    protected List<OBOConstants.TagMapping> headerTagOrdering;
    protected ReasonedLinkDatabase reasoner;
    protected IDProfile currentProfile;
    protected String autogenString;
    protected String username;
    protected boolean writeModificationData;
    protected static final char[] generic_escapes = new char[]{'{', '!', '\n', '\r'};
    protected static final char[] blocktext_escapes = new char[]{'{', '\n', '\t', '!'};
    protected static final char[] space_escapes = new char[]{'{', '\"', ' ', '\t', '!'};
    protected static final char[] single_quote_escapes = new char[]{'\'', '\n'};
    protected static final char[] double_quote_escapes = new char[]{'\"', '\n', '\r'};
    protected static final char[] before_quote_escapes = new char[]{'\"', '{', '!'};
    protected static final char[] pv_name_escapes = new char[]{'=', ' ', '\t', '!'};
    protected static final char[] pv_value_escapes = new char[]{',', '}', ' ', '\t', '!'};
    protected static final char[] dbxref_escapes = new char[]{'{', ':', '\t', ',', '\"', ']', '!'};

    public static String escapeSpaces(String s) {
        return OBOSerializationEngine.escape(s, space_escapes);
    }

    public static String escapeQuoted(String s, char quoteChar) {
        char[] escapes = quoteChar == '\'' ? single_quote_escapes : (quoteChar == '\"' ? double_quote_escapes : new char[]{quoteChar, '\n'});
        return OBOSerializationEngine.escape(s, escapes);
    }

    public static String escapeBeforeQuotes(String s) {
        return OBOSerializationEngine.escape(s, before_quote_escapes);
    }

    public static String escapePVName(String s) {
        return OBOSerializationEngine.escape(s, pv_name_escapes);
    }

    public static String escapePVValue(String s) {
        return OBOSerializationEngine.escape(s, pv_value_escapes);
    }

    public static String escapeDbxref(String s) {
        return OBOSerializationEngine.escape(s, dbxref_escapes);
    }

    public static String escapeBlocktext(String s) {
        return OBOSerializationEngine.escape(s, blocktext_escapes);
    }

    public static String escape(String s) {
        return OBOSerializationEngine.escape(s, generic_escapes);
    }

    public static String escape(String s, char[] charsToEscape) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean found = false;
            if (c == '\\') {
                found = true;
            } else {
                for (int j = 0; j < charsToEscape.length; ++j) {
                    if (charsToEscape[j] != c) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                out.append('\\');
                if (c == '\n') {
                    out.append('n');
                    continue;
                }
                if (c == '\r') {
                    out.append('n');
                    continue;
                }
                if (c == '\\') {
                    out.append('\\');
                    continue;
                }
                if (c == ' ') {
                    out.append('W');
                    continue;
                }
                out.append(c);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public OBOSerializationEngine() {
        try {
            this.addSerializerExtension(new PostcompParserExtension());
            this.addSerializerExtension(new AnnotationParserExtension());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.cancelled = true;
        for (SafeFileOutputStream sfos : this.streams) {
            try {
                sfos.fail();
            }
            catch (IOException iOException) {}
        }
    }

    public void serialize(OBOSession session, OBOSerializer serializer, String path) throws DataAdapterException {
        this.serialize(session, serializer, Collections.singleton(new FilteredPath(null, null, path)));
    }

    public void serialize(OBOSession session, OBOSerializer serializer, Collection<FilteredPath> filteredPaths) throws DataAdapterException {
        this.setSerializer(serializer);
        this.streams.clear();
        this.cancelled = false;
        for (FilteredPath filteredPath : filteredPaths) {
            try {
                try {
                    FileOutputStream fos = new FileOutputStream(filteredPath.getPath());
                    fos.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Can't write to output file " + filteredPath.getPath()));
                    throw new DataAdapterException("Can't write to output file " + filteredPath.getPath());
                }
                SafeFileOutputStream sfos = new SafeFileOutputStream(filteredPath.getPath());
                this.streams.add(sfos);
                PrintStream stream = new PrintStream(new BufferedOutputStream((OutputStream)sfos));
                this.closingStreams.add(stream);
                Filter linkFilter = filteredPath.getLinkFilter();
                Filter objectFilter = filteredPath.getObjectFilter();
                if (!filteredPath.getDoFilter()) {
                    objectFilter = null;
                } else if (filteredPath.getSaveTypes()) {
                    CompoundFilterImpl cf = new CompoundFilterImpl();
                    ObjectFilterImpl propCriterion = new ObjectFilterImpl();
                    propCriterion.setNegate(false);
                    propCriterion.setCriterion(new IsPropertyCriterion());
                    cf.setBooleanOperation(1);
                    cf.addFilter(objectFilter);
                    cf.addFilter(propCriterion);
                    objectFilter = cf;
                }
                if (!filteredPath.getDoLinkFilter()) {
                    linkFilter = null;
                }
                this.writeFile(session, objectFilter, linkFilter, serializer, stream, filteredPath);
            }
            catch (IOException ex) {
                throw new DataAdapterException("Write error", (Throwable)ex);
            }
        }
        for (OutputStream os : this.closingStreams) {
            try {
                os.close();
            }
            catch (IOException ex) {
                throw new DataAdapterException("Could not commit changes to " + os);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.closingStreams.clear();
        this.streams.clear();
    }

    protected void setSerializer(OBOSerializer serializer) {
        this.serializer = serializer;
        serializer.setEngine(this);
    }

    public void writeHeader(OBOSession session, LinkDatabase linkDatabase, OBOSerializer serializer, FilteredPath filteredPath) throws IOException, CancelledAdapterException {
        serializer.startHeader();
        String remark = filteredPath.getRemark();
        if (remark == null) {
            remark = session.getCurrentHistory().getComment();
        }
        ArrayList scratchList = new ArrayList();
        List headerTagOrdering = serializer.getHeaderTagOrdering();
        if (headerTagOrdering == null) {
            headerTagOrdering = OBOConstants.DEFAULT_HEADER_TAG_ORDER;
        }
        for (Object tagSpec : headerTagOrdering) {
            HashSet<Cloneable> usedCategories;
            Comparator comparator;
            if (tagSpec.equals("format-version")) {
                serializer.writeFormatVersionHeaderTag();
                continue;
            }
            if (tagSpec.equals("data-version")) {
                if (session.getCurrentHistory().getVersion() == null) continue;
                serializer.writeDataVersionHeaderTag(session.getCurrentHistory().getVersion());
                continue;
            }
            if (tagSpec.equals("date")) {
                Date date = new GregorianCalendar(TimeZone.getTimeZone("GMT")).getTime();
                serializer.writeDateHeaderTag(date);
                continue;
            }
            if (tagSpec.equals("saved-by")) {
                String username = this.getUsername();
                if (username == null) continue;
                serializer.writeSavedByHeaderTag(username);
                continue;
            }
            if (tagSpec.equals("autogenerated-by")) {
                if (this.getAutogenString() == null) continue;
                serializer.writeAutoGeneratedByHeaderTag(this.getAutogenString());
                continue;
            }
            if (tagSpec.equals("idspace")) {
                for (String idspace : session.getIDSpaces()) {
                    serializer.writeIDSpaceHeaderTag(idspace, session.expandIDSpace(idspace));
                }
                continue;
            }
            if (tagSpec.equals("subsetdef")) {
                comparator = serializer.getCategoryComparator();
                if (comparator == null) {
                    comparator = OBOConstants.DEFAULT_CATEGORY_COMPARATOR;
                }
                scratchList.clear();
                if (filteredPath.getDiscardUnusedCategories()) {
                    usedCategories = new HashSet<Cloneable>();
                    for (IdentifiedObject io : linkDatabase.getObjects()) {
                        if (!(io instanceof SubsetObject)) continue;
                        SubsetObject co = (SubsetObject)((Object)io);
                        usedCategories.addAll(co.getSubsets());
                    }
                    scratchList.addAll(usedCategories);
                } else {
                    scratchList.addAll(session.getSubsets());
                }
                Collections.sort(scratchList, comparator);
                for (Object o : scratchList) {
                    TermSubset cat = (TermSubset)o;
                    serializer.writeSubsetDefHeaderTag(cat);
                }
                continue;
            }
            if (tagSpec.equals("synonymtypedef")) {
                comparator = serializer.getSynonymCategoryComparator();
                if (comparator == null) {
                    comparator = OBOConstants.DEFAULT_RELATED_SYNONYM_CATEGORY_COMPARATOR;
                }
                scratchList.clear();
                if (filteredPath.getDiscardUnusedCategories()) {
                    usedCategories = new HashSet();
                    for (IdentifiedObject io : linkDatabase.getObjects()) {
                        if (!(io instanceof SynonymedObject)) continue;
                        SynonymedObject so = (SynonymedObject)io;
                        for (Synonym s : so.getSynonyms()) {
                            if (s.getSynonymType() == null) continue;
                            usedCategories.add(s.getSynonymType());
                        }
                    }
                    scratchList.addAll(usedCategories);
                } else {
                    scratchList.addAll(session.getSynonymTypes());
                }
                Collections.sort(scratchList, comparator);
                for (SynonymType cat : scratchList) {
                    serializer.writeSynonymTypeDefHeaderTag(cat);
                }
                continue;
            }
            if (tagSpec.equals("default-namespace")) {
                serializer.writeDefaultNamespaceHeaderTag(session.getDefaultNamespace());
                continue;
            }
            if (tagSpec.equals("namespace-id-rule")) {
                if (filteredPath.getIDRuleMode() != WRITE_STORED_ID_RULES && filteredPath.getIDRuleMode() != WRITE_CURRENT_ID_RULES) continue;
                IDProfile profile = null;
                if (filteredPath.getIDRuleMode() == WRITE_STORED_ID_RULES) {
                    profile = session.getIDProfile();
                }
                if (profile == null) {
                    profile = this.currentProfile;
                }
                if (profile == null) continue;
                serializer.writeNamespaceIDRuleHeaderTag(null, profile.getDefaultRule());
                HashMap<String, String> nsMap = new HashMap<String, String>();
                ArrayList<String> nsList = new ArrayList<String>();
                for (IDRule rule : profile.getRules()) {
                    ObjectFilter of;
                    CompoundFilter cf;
                    Filter<?> filter = rule.getFilter();
                    if (rule.getFilter() instanceof CompoundFilter && (cf = (CompoundFilter)rule.getFilter()).getFilters().size() == 1) {
                        filter = cf.getFilters().get(0);
                    }
                    if (filter == null || !(filter instanceof ObjectFilter) || !((of = (ObjectFilter)filter).getCriterion() instanceof NamespaceSearchCriterion) || !(of.getAspect() instanceof SelfSearchAspect) || !(of.getComparison() instanceof EqualsComparison) || of.getNegate()) continue;
                    String ns = of.getValue();
                    nsMap.put(ns, rule.getRule());
                    nsList.add(ns);
                }
                Collections.sort(nsList);
                for (String ns : nsList) {
                    serializer.writeNamespaceIDRuleHeaderTag(ns, (String)nsMap.get(ns));
                }
                continue;
            }
            if (!tagSpec.equals("remark")) continue;
            serializer.writeRemarkHeaderTag(remark);
        }
        for (PropertyValue pv : session.getPropertyValues()) {
            serializer.writeGenericHeaderTag(pv.getProperty(), pv.getValue());
        }
        serializer.endHeader();
    }

    public static Comparator getIDComparator(OBOSerializer serializer) {
        Comparator idComparator = serializer.getIDComparator();
        if (idComparator == null) {
            idComparator = OBOConstants.DEFAULT_ID_COMPARATOR;
        }
        return idComparator;
    }

    public static Comparator getDbxrefComparator(OBOSerializer serializer) {
        Comparator dbxrefComparator = serializer.getDbxrefComparator();
        if (dbxrefComparator == null) {
            dbxrefComparator = OBOConstants.DEFAULT_DBXREF_COMPARATOR;
        }
        return dbxrefComparator;
    }

    public static Comparator getCategoryComparator(OBOSerializer serializer) {
        Comparator categoryComparator = serializer.getCategoryComparator();
        if (categoryComparator == null) {
            categoryComparator = OBOConstants.DEFAULT_CATEGORY_COMPARATOR;
        }
        return categoryComparator;
    }

    public static Comparator getSynonymComparator(OBOSerializer serializer) {
        Comparator synonymComparator = serializer.getSynonymComparator();
        if (synonymComparator == null) {
            synonymComparator = OBOConstants.DEFAULT_RELATED_SYNONYM_COMPARATOR;
        }
        return synonymComparator;
    }

    public static Comparator getObsoleteComparator(OBOSerializer serializer) {
        Comparator obsoleteComparator = serializer.getObsoleteComparator();
        if (obsoleteComparator == null) {
            obsoleteComparator = OBOConstants.DEFAULT_OBSOLETE_COMPARATOR;
        }
        return obsoleteComparator;
    }

    public static Comparator getLinkComparator(OBOSerializer serializer) {
        Comparator linkComparator = serializer.getLinkComparator();
        if (linkComparator == null) {
            linkComparator = OBOConstants.DEFAULT_LINK_COMPARATOR;
        }
        return linkComparator;
    }

    public void writeObject(IdentifiedObject obj, LinkDatabase linkDatabase, OBOSerializer serializer) throws IOException, CancelledAdapterException {
        boolean written = false;
        for (OBOSerializerExtension extension : this.extensions) {
            if (!extension.startStanza(obj)) continue;
            written = true;
            break;
        }
        if (!written) {
            if (this.isRealObject(obj)) {
                serializer.startStanza(obj);
            } else {
                logger.info((Object)("OBOSerializationEngine.writeObject: not writing bogus object " + obj));
                return;
            }
        }
        for (OBOConstants.TagMapping tagMapping : this.tagOrdering) {
            this.writeTag(tagMapping, obj, linkDatabase, serializer);
        }
        written = false;
        for (OBOSerializerExtension extension : this.extensions) {
            if (!extension.endStanza(obj)) continue;
            written = true;
            break;
        }
        if (!written) {
            serializer.endStanza(obj);
        }
    }

    protected boolean isRealObject(IdentifiedObject obj) {
        return (TermUtil.isClass(obj) || TermUtil.isProperty(obj) || TermUtil.isInstance(obj)) && !TermUtil.isDangling(obj);
    }

    protected void writeTag(OBOConstants.TagMapping tagMapping, IdentifiedObject obj, LinkDatabase linkDatabase, OBOSerializer serializer) throws IOException {
        this.writeTag(tagMapping, obj, linkDatabase, serializer, this.allowDangling, this.realizeImplied, this.writeModificationData);
    }

    protected void writeTag(OBOConstants.TagMapping tagMapping, IdentifiedObject obj, LinkDatabase linkDatabase, OBOSerializer serializer, boolean allowDangling, boolean realizeImpliedLinks, boolean writeModificationData) throws IOException {
        block27: {
            LinkedList<ObsoletableObject> scratchList;
            ObsoletableObject oo;
            block50: {
                LinkedList<Link> linkList;
                LinkedObject lo;
                block49: {
                    OBOProperty property;
                    block48: {
                        block47: {
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block39: {
                                                            block38: {
                                                                LinkedList<Cloneable> scratchList2;
                                                                block37: {
                                                                    block36: {
                                                                        block35: {
                                                                            ModificationMetadataObject mobj;
                                                                            block34: {
                                                                                block33: {
                                                                                    block32: {
                                                                                        block31: {
                                                                                            block30: {
                                                                                                block29: {
                                                                                                    block28: {
                                                                                                        block26: {
                                                                                                            for (OBOSerializerExtension extension : this.extensions) {
                                                                                                                if (!extension.writeTag(tagMapping, obj, linkDatabase)) continue;
                                                                                                                return;
                                                                                                            }
                                                                                                            if (tagMapping.equals(OBOConstants.ID_TAG)) {
                                                                                                                serializer.writeIDTag(obj.getID(), obj.getIDExtension());
                                                                                                            } else if (tagMapping.equals(OBOConstants.IS_ANONYMOUS_TAG)) {
                                                                                                                serializer.writeIsAnonymousTag(obj.isAnonymous(), obj.getAnonymousExtension());
                                                                                                            }
                                                                                                            if (!tagMapping.equals(OBOConstants.NAME_TAG)) break block26;
                                                                                                            serializer.writeNameTag(obj.getName(), obj.getNameExtension());
                                                                                                            break block27;
                                                                                                        }
                                                                                                        if (!tagMapping.equals(OBOConstants.NAMESPACE_TAG)) break block28;
                                                                                                        serializer.writeNamespaceTag(obj.getNamespace(), obj.getNamespaceExtension());
                                                                                                        break block27;
                                                                                                    }
                                                                                                    if (!(obj instanceof MultiIDObject) || !tagMapping.equals(OBOConstants.ALT_ID_TAG)) break block29;
                                                                                                    LinkedList<String> scratchList22 = new LinkedList<String>();
                                                                                                    scratchList22.addAll(((MultiIDObject)obj).getSecondaryIDs());
                                                                                                    Collections.sort(scratchList22, OBOSerializationEngine.getIDComparator(serializer));
                                                                                                    for (String string : scratchList22) {
                                                                                                        NestedValue nv = ((MultiIDObject)obj).getSecondaryIDExtension(string);
                                                                                                        serializer.writeAltIDTag(string, nv);
                                                                                                    }
                                                                                                    break block27;
                                                                                                }
                                                                                                if (!(obj instanceof DefinedObject) || !tagMapping.equals(OBOConstants.DEF_TAG)) break block30;
                                                                                                scratchList2 = new LinkedList<Cloneable>();
                                                                                                scratchList2.addAll(((DefinedObject)obj).getDefDbxrefs());
                                                                                                Collections.sort(scratchList2, OBOSerializationEngine.getDbxrefComparator(serializer));
                                                                                                serializer.writeDefTag(((DefinedObject)obj).getDefinition(), scratchList2, ((DefinedObject)obj).getDefinitionExtension());
                                                                                                break block27;
                                                                                            }
                                                                                            if (!(obj instanceof CommentedObject) || !tagMapping.equals(OBOConstants.COMMENT_TAG)) break block31;
                                                                                            CommentedObject cobj = (CommentedObject)obj;
                                                                                            if (cobj.getComment() == null) break block27;
                                                                                            serializer.writeCommentTag(cobj.getComment(), cobj.getCommentExtension());
                                                                                            break block27;
                                                                                        }
                                                                                        if (!(obj instanceof ModificationMetadataObject) || !tagMapping.equals(OBOConstants.CREATED_BY_TAG)) break block32;
                                                                                        mobj = (ModificationMetadataObject)((Object)obj);
                                                                                        if (mobj.getCreatedBy() == null) break block27;
                                                                                        serializer.writeCreatedByTag(mobj.getCreatedBy(), mobj.getCreatedByExtension());
                                                                                        break block27;
                                                                                    }
                                                                                    if (!(obj instanceof ModificationMetadataObject) || !tagMapping.equals(OBOConstants.CREATION_DATE_TAG)) break block33;
                                                                                    mobj = (ModificationMetadataObject)((Object)obj);
                                                                                    if (mobj.getCreationDate() == null) break block27;
                                                                                    serializer.writeCreationDateTag(mobj.getCreationDate(), mobj.getCreationDateExtension());
                                                                                    break block27;
                                                                                }
                                                                                if (!(obj instanceof ModificationMetadataObject) || !tagMapping.equals(OBOConstants.MODIFICATION_DATE_TAG) || !writeModificationData) break block34;
                                                                                mobj = (ModificationMetadataObject)((Object)obj);
                                                                                if (mobj.getModificationDate() == null) break block27;
                                                                                serializer.writeModificationDateTag(mobj.getModificationDate(), mobj.getModificationDateExtension());
                                                                                break block27;
                                                                            }
                                                                            if (!(obj instanceof ModificationMetadataObject) || !tagMapping.equals(OBOConstants.MODIFIED_BY_TAG) || !writeModificationData) break block35;
                                                                            mobj = (ModificationMetadataObject)((Object)obj);
                                                                            if (mobj.getModifiedBy() == null) break block27;
                                                                            serializer.writeModifiedByTag(mobj.getModifiedBy(), mobj.getModifiedByExtension());
                                                                            break block27;
                                                                        }
                                                                        if (!(obj instanceof SubsetObject) || !tagMapping.equals(OBOConstants.SUBSET_TAG)) break block36;
                                                                        scratchList2 = new LinkedList();
                                                                        scratchList2.addAll(((SubsetObject)((Object)obj)).getSubsets());
                                                                        Collections.sort(scratchList2, OBOSerializationEngine.getCategoryComparator(serializer));
                                                                        for (TermSubset termSubset : scratchList2) {
                                                                            NestedValue nv = ((SubsetObject)((Object)obj)).getCategoryExtension(termSubset);
                                                                            serializer.writeSubsetTag(termSubset, nv);
                                                                        }
                                                                        break block27;
                                                                    }
                                                                    if (!(obj instanceof SynonymedObject) || !tagMapping.equals(OBOConstants.RELATED_SYNONYM_TAG)) break block37;
                                                                    scratchList2 = new LinkedList();
                                                                    scratchList2.addAll(((SynonymedObject)obj).getSynonyms());
                                                                    Collections.sort(scratchList2, OBOSerializationEngine.getSynonymComparator(serializer));
                                                                    for (Synonym synonym : scratchList2) {
                                                                        serializer.writeSynonymTag(synonym, synonym.getNestedValue());
                                                                    }
                                                                    break block27;
                                                                }
                                                                if (!(obj instanceof DbxrefedObject) || !tagMapping.equals(OBOConstants.XREF_TAG)) break block38;
                                                                scratchList2 = new LinkedList();
                                                                scratchList2.addAll(((DbxrefedObject)((Object)obj)).getDbxrefs());
                                                                Collections.sort(scratchList2, OBOSerializationEngine.getDbxrefComparator(serializer));
                                                                for (Dbxref dbxref : scratchList2) {
                                                                    serializer.writeXrefTag(dbxref);
                                                                }
                                                                break block27;
                                                            }
                                                            if (!(obj instanceof Instance) || !tagMapping.equals(OBOConstants.INSTANCE_OF_TAG)) break block39;
                                                            serializer.writeInstanceOfTag(((Instance)obj).getType(), null);
                                                            break block27;
                                                        }
                                                        if (obj instanceof Instance && tagMapping.equals(OBOConstants.PROPERTY_VALUE_TAG)) break block27;
                                                        if (!(obj instanceof Instance) || !tagMapping.equals(OBOConstants.VALUE_LINK_TAG)) break block40;
                                                        if (!(obj instanceof LinkedObject)) break block27;
                                                        lo = (LinkedObject)obj;
                                                        linkList = new LinkedList<Link>();
                                                        linkList.addAll(linkDatabase.getParents(lo));
                                                        Collections.sort(linkList, OBOSerializationEngine.getLinkComparator(serializer));
                                                        for (Link link : linkList) {
                                                            if (!(link instanceof ValueLink)) continue;
                                                            serializer.writeValueLinkTag((ValueLink)link, link.getNestedValue());
                                                        }
                                                        break block27;
                                                    }
                                                    if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.DOMAIN_TAG)) break block41;
                                                    property = (OBOProperty)obj;
                                                    if (property.getDomain() == null || !allowDangling && linkDatabase.getObject(property.getDomain().getID()) == null) break block27;
                                                    serializer.writeDomainTag(property.getDomain(), property.getDomainExtension());
                                                    break block27;
                                                }
                                                if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.RANGE_TAG)) break block42;
                                                property = (OBOProperty)obj;
                                                if (property.getRange() == null || !allowDangling && linkDatabase.getObject(property.getRange().getID()) == null) break block27;
                                                serializer.writeRangeTag(property.getRange(), property.getRangeExtension());
                                                break block27;
                                            }
                                            if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.IS_CYCLIC_TAG)) break block43;
                                            property = (OBOProperty)obj;
                                            serializer.writeIsCyclicTag(property.isCyclic(), property.getCyclicExtension());
                                            break block27;
                                        }
                                        if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.IS_REFLEXIVE_TAG)) break block44;
                                        property = (OBOProperty)obj;
                                        serializer.writeIsReflexiveTag(property.isReflexive(), property.getReflexiveExtension());
                                        break block27;
                                    }
                                    if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.ALWAYS_IMPLIES_INVERSE_TAG)) break block45;
                                    property = (OBOProperty)obj;
                                    serializer.writeAlwaysImpliesInverseTag(property.isAlwaysImpliesInverse(), property.getReflexiveExtension());
                                    break block27;
                                }
                                if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.IS_SYMMETRIC_TAG)) break block46;
                                property = (OBOProperty)obj;
                                serializer.writeIsSymmetricTag(property.isSymmetric(), property.getSymmetricExtension());
                                break block27;
                            }
                            if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.IS_TRANSITIVE_TAG)) break block47;
                            property = (OBOProperty)obj;
                            serializer.writeIsTransitiveTag(property.isTransitive(), property.getTransitiveExtension());
                            break block27;
                        }
                        if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.TRANSITIVE_OVER_TAG)) break block27;
                        if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.DISJOINT_OVER_TAG)) break block48;
                        property = (OBOProperty)obj;
                        for (Link link : property.getParents()) {
                            if (!link.getType().equals(OBOProperty.DISJOINT_OVER)) continue;
                            serializer.writeLinkTag(link, null);
                        }
                        break block27;
                    }
                    if (!(obj instanceof OBOProperty) || !tagMapping.equals(OBOConstants.HOLDS_OVER_CHAIN_TAG)) break block49;
                    property = (OBOProperty)obj;
                    if (property.getHoldsOverChains() == null) break block27;
                    for (List list : property.getHoldsOverChains()) {
                        serializer.writeHoldsOverChainTag(list);
                    }
                    break block27;
                }
                if (!(obj instanceof LinkedObject) || !tagMapping.equals(OBOConstants.LINK_TAG)) break block50;
                if (!(obj instanceof LinkedObject)) break block27;
                lo = (LinkedObject)obj;
                linkList = new LinkedList();
                Collection<Link> collection = linkDatabase.getParents(lo);
                for (Link p : collection) {
                    if (p.getParent() == null) {
                        logger.error((Object)("invalid link: " + p + " Child: " + p.getChild().getClass()));
                    }
                    if (p.getType() != null) continue;
                    logger.error((Object)("invalid link: " + p + " Child: " + p.getChild().getClass()));
                }
                linkList.addAll(collection);
                Collections.sort(linkList, OBOSerializationEngine.getLinkComparator(serializer));
                for (Link link : linkList) {
                    if (link instanceof ValueLink) continue;
                    this.writeLink(serializer, link);
                }
                break block27;
            }
            if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.IS_OBSOLETE_TAG)) {
                oo = (ObsoletableObject)obj;
                serializer.writeIsObsoleteTag(oo.isObsolete(), oo.getObsoleteExtension());
            } else if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.REPLACED_BY_TAG)) {
                oo = (ObsoletableObject)obj;
                scratchList = new LinkedList<ObsoletableObject>();
                scratchList.addAll(oo.getReplacedBy());
                Collections.sort(scratchList, OBOSerializationEngine.getObsoleteComparator(serializer));
                for (ObsoletableObject replacement : scratchList) {
                    serializer.writeReplacedByTag(replacement, oo.getReplacedByExtension(replacement));
                }
            } else if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.CONSIDER_TAG)) {
                oo = (ObsoletableObject)obj;
                scratchList = new LinkedList();
                scratchList.addAll(oo.getConsiderReplacements());
                Collections.sort(scratchList, OBOSerializationEngine.getObsoleteComparator(serializer));
                for (ObsoletableObject replacement : scratchList) {
                    serializer.writeConsiderTag(replacement, oo.getConsiderExtension(replacement));
                }
            } else if (tagMapping.equals(OBOConstants.IS_METADATA_TAG) && obj instanceof OBOProperty) {
                serializer.writeIsMetadataTag(((OBOProperty)obj).isMetadataTag(), null);
            } else if (tagMapping.equals(OBOConstants.UNRECOGNIZED_TAG)) {
                for (PropertyValue pv : obj.getPropertyValues()) {
                    serializer.writeUnrecognizedTag(pv);
                }
            }
        }
    }

    public void writeLink(OBOSerializer serializer, Link link) throws IOException {
        if (this.allowDangling || !(link.getParent() instanceof DanglingObject)) {
            if (TermUtil.isImplied(link)) {
                if (this.saveImplied) {
                    if (this.realizeImplied) {
                        link = this.realizeLink(link);
                    }
                    serializer.writeLinkTag(link, link.getNestedValue());
                }
            } else {
                serializer.writeLinkTag(link, link.getNestedValue());
            }
        }
    }

    protected OBORestriction realizeLink(Link l) {
        OBORestrictionImpl out = new OBORestrictionImpl(l);
        if (l instanceof OBORestriction) {
            OBORestriction link = (OBORestriction)l;
            out.setCardinality(link.getCardinality());
            out.setMaxCardinality(link.getMaxCardinality());
            out.setMinCardinality(link.getMinCardinality());
            out.setCompletes(link.completes());
            out.setInverseCompletes(link.inverseCompletes());
            out.setNecessarilyTrue(link.isNecessarilyTrue());
            out.setInverseNecessarilyTrue(link.isInverseNecessarilyTrue());
        }
        if (l.getNestedValue() != null) {
            out.setNestedValue((NestedValue)l.getNestedValue().clone());
        } else {
            out.setNestedValue(new NestedValueImpl());
        }
        out.getNestedValue().setSuggestedComment("implied link automatically realized");
        return out;
    }

    protected static LinkFilter getPropertyLinkFilter(OBOProperty filterProperty) {
        LinkFilterImpl basicLinkFilter = new LinkFilterImpl();
        basicLinkFilter.setAspect(2);
        ObjectFilterImpl idfilter = new ObjectFilterImpl();
        idfilter.setCriterion(new IDSearchCriterion());
        idfilter.setComparison(new EqualsComparison());
        idfilter.setValue(filterProperty.getID());
        basicLinkFilter.setFilter(idfilter);
        return basicLinkFilter;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public void writeFile(OBOSession session, Filter objectFilter, Filter linkFilter, OBOSerializer serializer, PrintStream stream, FilteredPath filteredPath) throws IOException, CancelledAdapterException {
        String path = filteredPath.getPath();
        this.allowDangling = filteredPath.getAllowDangling();
        this.saveImplied = filteredPath.getSaveImplied();
        this.realizeImplied = filteredPath.getSaveImplied();
        this.writeModificationData = filteredPath.getWriteModificationData();
        String impliedType = filteredPath.getImpliedType();
        this.reasonerFactory = filteredPath.getReasonerFactory();
        OBOProperty prefilterProperty = null;
        if (filteredPath.getPrefilterProperty() != null) {
            prefilterProperty = (OBOProperty)session.getObject(filteredPath.getPrefilterProperty());
        }
        String rootAlgorithm = filteredPath.getRootAlgorithm();
        serializer.setOutputStream(stream);
        serializer.startSerialize();
        for (OBOSerializerExtension extension : this.extensions) {
            extension.setSerializer(serializer);
            extension.setSerializationEngine(this);
            extension.setSession(session);
            extension.setOutputStream(stream);
            extension.startSerialize();
        }
        boolean saveAll = impliedType.equals(SAVE_ALL);
        LinkDatabase database = session.getLinkDatabase();
        if (this.saveImplied || prefilterProperty != null) {
            ReasonedLinkDatabase fullReasoner;
            if (filteredPath.getUseSessionReasoner() && this.getReasoner() != null) {
                fullReasoner = this.getReasoner();
            } else {
                fullReasoner = this.reasonerFactory.createReasoner();
                fullReasoner.setLinkDatabase(new DefaultLinkDatabase(session));
                fullReasoner.recache();
            }
            if (prefilterProperty != null) {
                final FilteredLinkDatabase propertyFiltered = new FilteredLinkDatabase(fullReasoner);
                propertyFiltered.setFilterMethod(4);
                propertyFiltered.setLinkFilter(OBOSerializationEngine.getPropertyLinkFilter(prefilterProperty));
                if (saveAll) {
                    database = propertyFiltered;
                } else {
                    ReasonedLinkDatabase rld = fullReasoner;
                    FilteredLinkDatabase trimFiltered = new FilteredLinkDatabase(propertyFiltered);
                    trimFiltered.setFilterMethod(4);
                    trimFiltered.setLinkFilter(new Filter(){
                        private static final long serialVersionUID = 1L;

                        public boolean satisfies(Object o) {
                            if (o instanceof Link) {
                                Link link = (Link)o;
                                return !ReasonerUtil.shouldBeTrimmedNew(propertyFiltered, link);
                            }
                            return false;
                        }

                        public void lock() {
                        }

                        public void setContext(JexlContext context) {
                        }

                        public void setReasoner(ReasonedLinkDatabase reasoner) {
                        }

                        public Object clone() {
                            return this;
                        }
                    });
                    database = trimFiltered;
                }
            } else {
                database = saveAll ? fullReasoner : new TrimmedLinkDatabase(fullReasoner);
            }
            if (database instanceof ReasonedLinkDatabase) {
                ((ReasonedLinkDatabase)database).recache();
            }
        }
        if (linkFilter != null || objectFilter != null) {
            database = new FilteredLinkDatabase(database);
            ((FilteredLinkDatabase)database).setLinkFilter(linkFilter);
            ((FilteredLinkDatabase)database).setTermFilter(objectFilter);
            ((FilteredLinkDatabase)database).setAllowDangling(this.allowDangling);
        }
        if (rootAlgorithm.equals("STRICT")) {
            database = new RootAlgorithmModeratedLinkDatabase(database, RootAlgorithm.STRICT);
            ((RootAlgorithmModeratedLinkDatabase)database).recache();
        }
        this.setProgressString("Writing header: " + path);
        this.writeHeader(session, database, serializer, filteredPath);
        this.setProgressString("Setting up adapter: " + path);
        this.stanzaOrdering = new LinkedList<OBOConstants.StanzaMapping>();
        if (serializer.getStanzaOrdering() == null) {
            this.stanzaOrdering.addAll(OBOConstants.DEFAULT_STANZA_ORDER);
        } else {
            this.stanzaOrdering.addAll(serializer.getStanzaOrdering());
        }
        this.headerTagOrdering = new LinkedList<OBOConstants.TagMapping>();
        if (serializer.getHeaderTagOrdering() == null) {
            this.headerTagOrdering.addAll(OBOConstants.DEFAULT_HEADER_TAG_ORDER);
        } else {
            this.headerTagOrdering.addAll(serializer.getHeaderTagOrdering());
        }
        this.tagOrdering = new LinkedList<OBOConstants.TagMapping>();
        if (serializer.getTagOrdering() == null) {
            this.tagOrdering.addAll(OBOConstants.DEFAULT_TAG_ORDER);
        } else {
            this.tagOrdering.addAll(serializer.getTagOrdering());
        }
        for (OBOSerializerExtension extension : this.extensions) {
            extension.changeStanzaOrder(this.stanzaOrdering);
            extension.changeHeaderTagOrder(this.headerTagOrdering);
            extension.changeTagOrder(this.tagOrdering);
        }
        Comparator objectComparator = serializer.getObjectComparator();
        if (objectComparator == null) {
            objectComparator = OBOConstants.DEFAULT_OBJECT_COMPARATOR;
        }
        for (OBOConstants.StanzaMapping stanzaMapping : this.stanzaOrdering) {
            ArrayList<IdentifiedObject> objectList = new ArrayList<IdentifiedObject>();
            for (IdentifiedObject io : database.getObjects()) {
                if (!stanzaMapping.getStanzaClass().isInstance(io) || io.isBuiltIn()) continue;
                objectList.add(io);
            }
            this.setProgressString("Sorting objects: " + path);
            Collections.sort(objectList, objectComparator);
            this.setProgressString("Writing objects : " + path);
            Iterator<IdentifiedObject> it2 = objectList.iterator();
            int i = 0;
            while (it2.hasNext()) {
                if (this.cancelled) {
                    this.doHalt();
                }
                IdentifiedObject io = it2.next();
                int percent = 100 * i / objectList.size();
                this.setProgressValue(percent);
                boolean picked = false;
                for (OBOSerializerExtension extension : this.extensions) {
                    if (!extension.writeObject(database, io)) continue;
                    picked = true;
                    break;
                }
                if (!picked) {
                    this.writeObject(io, database, serializer);
                }
                ++i;
            }
        }
        for (OBOSerializerExtension extension : this.extensions) {
            extension.endSerialize();
        }
        serializer.endSerialize();
    }

    public String mapID(IdentifiedObject io) {
        return this.mapID(io, io.getID());
    }

    public String mapID(IdentifiedObject io, String id) {
        String out = id;
        String temp = this.serializer.mapID(io, id);
        if (temp != null) {
            out = temp;
        }
        for (OBOSerializerExtension extension : this.extensions) {
            temp = extension.mapIDforWrite(io, out);
            if (temp == null) continue;
            out = temp;
        }
        return out;
    }

    public void doHalt() throws CancelledAdapterException {
        throw new CancelledAdapterException();
    }

    public void addSerializerExtension(OBOSerializerExtension extension) throws IOException {
        this.extensions.add(extension);
    }

    public void removeSerializerExtension(OBOSerializerExtension extension) throws IOException {
        this.extensions.remove(extension);
    }

    public IDProfile getCurrentProfile() {
        return this.currentProfile;
    }

    public void setCurrentProfile(IDProfile currentProfile) {
        this.currentProfile = currentProfile;
    }

    public String getAutogenString() {
        return this.autogenString;
    }

    public void setAutogenString(String autogenString) {
        this.autogenString = autogenString;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static class FilteredPath {
        protected Filter linkFilter;
        protected Filter objectFilter;
        protected String prefilterProperty;
        protected boolean doFilter = false;
        protected boolean doLinkFilter = false;
        protected boolean allowDangling = true;
        protected boolean saveImplied = false;
        protected ReasonerFactory reasonerFactory = new LinkPileReasonerFactory();
        protected boolean discardUnusedCategories = false;
        protected boolean useSessionReasoner = true;
        protected int idRuleMode = DONT_WRITE_ID_RULES;
        protected String impliedType = "Save for presentation";
        protected String path;
        protected String remark;
        protected String rootAlgorithm = "GREEDY";
        protected boolean realizeImpliedLinks = false;
        protected boolean saveTypes;
        protected boolean writeModificationData = false;

        public FilteredPath() {
        }

        public FilteredPath(Filter linkFilter, Filter objectFilter, String path) {
            this.setLinkFilter(linkFilter);
            this.setObjectFilter(objectFilter);
            this.setPath(path);
        }

        public boolean getUseSessionReasoner() {
            return this.useSessionReasoner;
        }

        public void setUseSessionReasoner(boolean useSessionReasoner) {
            this.useSessionReasoner = useSessionReasoner;
        }

        public void setRootAlgorithm(String rootAlgorithm) {
            this.rootAlgorithm = rootAlgorithm;
        }

        public String getRootAlgorithm() {
            return this.rootAlgorithm;
        }

        public void setPrefilterProperty(String prefilterProperty) {
            this.prefilterProperty = prefilterProperty;
        }

        public String getPrefilterProperty() {
            return this.prefilterProperty;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setIDRuleMode(int idRuleWriteMode) {
            this.idRuleMode = idRuleWriteMode;
        }

        public int getIDRuleMode() {
            return this.idRuleMode;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setSaveImplied(boolean saveImplied) {
            this.saveImplied = saveImplied;
        }

        public boolean getSaveImplied() {
            return this.saveImplied;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setImpliedType(String impliedType) {
            this.impliedType = impliedType;
        }

        public String getImpliedType() {
            return this.impliedType;
        }

        public String getPath() {
            return this.path;
        }

        public boolean getDoLinkFilter() {
            return this.doLinkFilter;
        }

        public void setDoLinkFilter(boolean doLinkFilter) {
            this.doLinkFilter = doLinkFilter;
        }

        public boolean getDoFilter() {
            return this.doFilter;
        }

        public void setDoFilter(boolean doFilter) {
            this.doFilter = doFilter;
        }

        public String toString() {
            return this.path;
        }

        public boolean getRealizeImpliedLinks() {
            return this.realizeImpliedLinks;
        }

        public void setRealizeImpliedLinks(boolean realizeImpliedLinks) {
            this.realizeImpliedLinks = realizeImpliedLinks;
        }

        public boolean getSaveTypes() {
            return this.saveTypes;
        }

        public void setSaveTypes(boolean saveTypes) {
            this.saveTypes = saveTypes;
        }

        public boolean getDiscardUnusedCategories() {
            return this.discardUnusedCategories;
        }

        public void setDiscardUnusedCategories(boolean discardUnusedCategories) {
            this.discardUnusedCategories = discardUnusedCategories;
        }

        public Filter getLinkFilter() {
            return this.linkFilter;
        }

        public void setLinkFilter(Filter linkFilter) {
            this.linkFilter = linkFilter;
        }

        public Filter getObjectFilter() {
            return this.objectFilter;
        }

        public void setObjectFilter(Filter objectFilter) {
            this.objectFilter = objectFilter;
        }

        public ReasonerFactory getReasonerFactory() {
            return this.reasonerFactory;
        }

        public void setReasonerFactory(ReasonerFactory reasonerFactory) {
            this.reasonerFactory = reasonerFactory;
        }

        public boolean getWriteModificationData() {
            return this.writeModificationData;
        }

        public void setWriteModificationData(boolean writeModificationData) {
            this.writeModificationData = writeModificationData;
        }
    }
}

