/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.ProgressableInputStream;
import org.obo.dataadapter.DefaultOBOParser;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOParseEngine;
import org.obo.datamodel.OBOSession;

public class OWLURLReaderAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(OWLURLReaderAdapter.class);
    protected static final String RESTFUL_URL = "http://www.berkeleybop.org/obo-conv.cgi";
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected List listeners = new Vector();
    protected OBOParseEngine engine;

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration oldconfig, Object o) throws DataAdapterException {
        this.config = oldconfig;
        this.cancelled = false;
        if (op.equals(READ_ONTOLOGY)) {
            FileAdapterConfiguration config;
            if (oldconfig instanceof FileAdapterConfiguration && (config = (FileAdapterConfiguration)oldconfig).getReadPaths().size() == 1) {
                this.path = (String)config.getReadPaths().iterator().next();
                try {
                    return this.getRoot();
                }
                catch (DataAdapterException ex) {
                    if (this.cancelled) {
                        throw new CancelledAdapterException();
                    }
                    throw ex;
                }
            }
            throw new DataAdapterException("Bad configuration");
        }
        return null;
    }

    public String getID() {
        return "OBO:OWLURL";
    }

    public String getName() {
        return "OWL URL Reader";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{WRITE_ONTOLOGY, READ_ONTOLOGY};
        return supported;
    }

    public String getProgressString() {
        return this.engine.getProgressString();
    }

    public Number getProgressValue() {
        return this.engine.getProgressValue();
    }

    public OBOSession getRoot() throws DataAdapterException {
        try {
            String readPath;
            try {
                readPath = "http://www.berkeleybop.org/obo-conv.cgi?url=" + URLEncoder.encode(this.path, "UTF-8") + "&format=obo&style=basic";
            }
            catch (UnsupportedEncodingException ex) {
                throw new DataAdapterException("Could not construct URL", (Throwable)ex);
            }
            DefaultOBOParser parser = new DefaultOBOParser();
            parser.setAllowDanglingParents(true);
            this.engine = new OBOParseEngine(parser);
            this.engine.setPath(readPath);
            this.engine.parse();
            OBOSession history = parser.getSession();
            return history;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Load error");
        }
    }
}

