/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.IOUtil;
import org.bbop.io.ProgressableInputStream;
import org.obo.dataadapter.OBOAdapter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOSession;

public class SerialAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(SerialAdapter.class);
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration oldconfig, Object o) throws DataAdapterException {
        this.config = oldconfig;
        this.cancelled = false;
        if (op.equals(READ_ONTOLOGY)) {
            FileAdapterConfiguration config;
            if (oldconfig instanceof FileAdapterConfiguration && (config = (FileAdapterConfiguration)oldconfig).getReadPaths().size() == 1) {
                this.path = (String)config.getReadPaths().iterator().next();
                try {
                    return this.getRoot();
                }
                catch (DataAdapterException ex) {
                    if (this.cancelled) {
                        throw new CancelledAdapterException();
                    }
                    throw ex;
                }
            }
            throw new DataAdapterException("Bad configuration");
        }
        if (op.equals(WRITE_ONTOLOGY)) {
            if (oldconfig instanceof FileAdapterConfiguration) {
                FileAdapterConfiguration config = (FileAdapterConfiguration)oldconfig;
                this.path = config.getWritePath();
                this.write((OBOSession)o);
                return o;
            }
            throw new DataAdapterException("Bad configuration");
        }
        return null;
    }

    public String getID() {
        return "OBO:Serial";
    }

    public String getName() {
        return "OBO Serial Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{WRITE_ONTOLOGY, READ_ONTOLOGY};
        return supported;
    }

    public String getProgressString() {
        return this.pfis.getProgressString();
    }

    public Number getProgressValue() {
        return this.pfis.getProgressValue();
    }

    public OBOSession getRoot() throws DataAdapterException {
        ObjectInputStream stream;
        ZipInputStream zipstream;
        try {
            this.pfis = IOUtil.getProgressableStream((String)this.path);
            zipstream = new ZipInputStream(new BufferedInputStream((InputStream)this.pfis));
            zipstream.getNextEntry();
        }
        catch (IOException e) {
            throw new DataAdapterException("Load error", (Throwable)e);
        }
        try {
            stream = new ObjectInputStream(zipstream);
        }
        catch (IOException e) {
            throw new DataAdapterException("Could not load file - the selected file is probably not in the correct format", (Throwable)e);
        }
        try {
            OBOSession history = (OBOSession)stream.readObject();
            history.setLoadRemark(IOUtil.getShortName((String)this.path));
            return history;
        }
        catch (Exception e) {
            throw new DataAdapterException("Load error", (Throwable)e);
        }
    }

    public OBOSession write(OBOSession history) throws DataAdapterException {
        try {
            ZipOutputStream zipstream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.path)));
            ZipEntry entry = new ZipEntry("main");
            zipstream.putNextEntry(entry);
            zipstream.setLevel(5);
            ObjectOutputStream stream = new ObjectOutputStream(zipstream);
            stream.writeObject(history);
            stream.close();
            return history;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    public String getTermText(IdentifiedObject term) throws DataAdapterException {
        final StringBuffer buffer = new StringBuffer();
        OutputStream os = new OutputStream(){

            public void write(int b) {
                buffer.append((char)b);
            }
        };
        try {
            ObjectOutputStream stream = new ObjectOutputStream(os);
            stream.writeObject(os);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return buffer.toString();
    }
}

