/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.EmptyIterator;
import org.bbop.util.IteratorFactory;
import org.bbop.util.ObjectUtil;
import org.bbop.util.SingletonIterator;
import org.bbop.util.SuperCollection;
import org.bbop.util.TransformingIterator;
import org.bbop.util.VectorTransformer;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.IdentifiableObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.OBOSession;
import org.obo.filters.SearchCriterion;
import org.obo.filters.SynonymSearchCriterion;
import org.obo.filters.SynonymTextSearchCriterion;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPath {
    protected static final Logger logger = Logger.getLogger(FieldPath.class);
    public static final Object EMPTY = new Object();
    protected IdentifiedObject object;
    protected LinkedList<FieldPathElement> elements = new LinkedList();

    public FieldPath(IdentifiedObject object, Object ... newElements) {
        this(object);
        this.readElements(newElements);
    }

    public Object getValueAt(FieldPathSpec spec) {
        if (!this.startsWithSpec(spec)) {
            return null;
        }
        return this.elements.get(spec.getElements().size() - 1).getValue();
    }

    public Object getLastValue() {
        if (this.elements.size() > 0) {
            return this.elements.getLast().getValue();
        }
        return this.object;
    }

    public SearchCriterion getLastField() {
        return this.elements.getLast().getField();
    }

    protected FieldPath() {
    }

    public FieldPath(FieldPathSpec spec, Object ... newElements) {
        for (int i = 0; i < newElements.length; ++i) {
            if (i == 0) {
                this.object = (IdentifiedObject)newElements[0];
                continue;
            }
            this.elements.add(new FieldPathElement(spec.getElements().get(i - 1), newElements[i]));
        }
    }

    public FieldPath(FieldPath parentPath, Object ... newElements) {
        this(parentPath.getObject());
        if (newElements.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of arguments required");
        }
        for (FieldPathElement e : parentPath.getElements()) {
            this.elements.add(e);
        }
        this.readElements(newElements);
    }

    protected void readElements(Object[] newElements) {
        for (int i = 0; i < newElements.length; i += 2) {
            Object o = newElements[i];
            if (!(o instanceof SearchCriterion)) {
                throw new IllegalArgumentException("Field identifier should be a SearchCriterion");
            }
            this.elements.add(new FieldPathElement((SearchCriterion)o, newElements[i + 1]));
        }
    }

    public boolean startsWithSpec(FieldPathSpec spec) {
        int i;
        for (i = 0; i < this.elements.size(); ++i) {
            if (i >= spec.getElements().size()) {
                return true;
            }
            FieldPathElement e = this.elements.get(i);
            if (e.getField().equals(spec.getElements().get(i))) continue;
            return false;
        }
        return i >= spec.getElements().size();
    }

    public boolean matchesSpec(FieldPathSpec spec) {
        if (this.elements.size() != spec.getElements().size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            FieldPathElement e = this.elements.get(i);
            if (e.getField().equals(spec.getElements().get(i))) continue;
            return false;
        }
        return true;
    }

    public FieldPathSpec getSpec() {
        return new FieldPathSpec(this);
    }

    public FieldPath getParentPath() {
        if (this.elements.size() == 0) {
            return null;
        }
        FieldPath out = new FieldPath(this.getObject());
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            out.getElements().add(this.getElements().get(i));
        }
        return out;
    }

    public Collection<FieldPath> resolve() {
        return FieldPath.resolve(this, null);
    }

    public static void main(String[] args) throws Exception {
        OBOSession session = TermUtil.getSession("/Users/jrichter/ontology/so-xp.obo");
        FieldPath path = new FieldPath(null);
        FieldPath path2 = new FieldPath((IdentifiedObject)null, new SynonymSearchCriterion(), null, new SynonymTextSearchCriterion(), null);
        Collection<FieldPath> c1 = FieldPath.resolve(path, session.getLinkDatabase());
        Collection<FieldPath> c2 = FieldPath.resolve(path2, session.getLinkDatabase());
        logger.info((Object)("c1.size = " + c1.size()));
        logger.info((Object)("c2.size = " + c2.size()));
    }

    public static Collection<FieldPath> resolve(FieldPathSpec spec, LinkDatabase linkDatabase) {
        FieldPath queryPath = FieldPathSpec.createQueryPath(spec);
        return FieldPath.resolve(queryPath, linkDatabase);
    }

    public static Collection<FieldPath> resolve(FieldPath path, LinkDatabase linkDatabase) {
        LinkedList<Object> factories = new LinkedList<Object>();
        factories.add(new FieldPathRootIteratorFactory(linkDatabase));
        for (FieldPathElement elt : path.elements) {
            try {
                factories.add(new FieldPathElementIteratorFactory(elt));
            }
            catch (Exception e) {
                logger.debug((Object)("caught exception while adding new FieldPathElement: " + e));
            }
        }
        return new SuperCollection((Object)path.getObject(), factories);
    }

    public static void coalesce(List<FieldPath> paths) {
        int originalSize = paths.size();
        for (int i = paths.size() - 1; i >= 1; --i) {
            if (paths.get(i) == null) continue;
            FieldPath.coalesce(i, paths);
        }
        Iterator<FieldPath> it = paths.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    protected static void coalesce(int index, List<FieldPath> paths) {
        FieldPath f = paths.get(index);
        for (int i = index; i >= 0; --i) {
            if (index == i || paths.get(i) == null || !FieldPath.collapsable(f, paths.get(i))) continue;
            paths.set(i, null);
        }
    }

    protected static boolean collapsable(FieldPath f, FieldPath path) {
        if (f.getLength() == path.getLength()) {
            for (int i = 0; i < f.getLength(); ++i) {
                FieldPathElement e1 = f.getElements().get(i);
                FieldPathElement e2 = path.getElements().get(i);
                if (!e1.getField().equals(e2.getField())) {
                    return false;
                }
                if (e1.getField().getMaxCardinality() <= 1 || e1.getValue().equals(e2.getValue()) || e1.getField().getMaxCardinality() <= 1) continue;
                if (!(e1.getValue() instanceof IdentifiableObject) || !(e2.getValue() instanceof IdentifiableObject)) {
                    return false;
                }
                IdentifiableObject io1 = (IdentifiableObject)e1.getValue();
                IdentifiableObject io2 = (IdentifiableObject)e2.getValue();
                if (io1.getID().equals(io2.getID())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FieldPath(IdentifiedObject object) {
        this.object = object;
    }

    public boolean containsValue(Object value) {
        for (FieldPathElement e : this.getElements()) {
            if (!e.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<FieldPathElement> getElements() {
        return this.elements;
    }

    public int getLength() {
        return this.elements.size();
    }

    public IdentifiedObject getObject() {
        return this.object;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("FieldPath(");
        if (this.getObject() == null) {
            out.append("*");
        } else {
            out.append(this.getObject().getID());
        }
        out.append(" -> ");
        int index = 0;
        for (FieldPathElement e : this.getElements()) {
            if (index > 0) {
                out.append(", ");
            }
            out.append("<" + e.getField() + "," + e.getValue() + ">");
            ++index;
        }
        out.append(")");
        return out.toString();
    }

    public int hashCode() {
        int hash = this.object == null ? 1 : this.object.hashCode();
        for (FieldPathElement e : this.elements) {
            hash += e.getValue().hashCode();
            hash <<= 2;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof FieldPath) {
            FieldPath path = (FieldPath)o;
            if (path.elements.size() != this.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                FieldPathElement e1 = this.elements.get(i);
                FieldPathElement e2 = path.elements.get(i);
                if (ObjectUtil.equals((Object)e1.getValue(), (Object)e2.getValue()) && ObjectUtil.equals((Object)e1.getField(), (Object)e2.getField())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldPathElementIteratorFactory
    implements IteratorFactory<FieldPath, FieldPath> {
        protected FieldPathElement element;

        public FieldPathElementIteratorFactory(FieldPathElement element) {
            this.element = element;
        }

        public Iterator<FieldPath> getIterator(FieldPath p) {
            FieldPathElement object = this.element;
            if (ObjectUtil.equals((Object)object.getValue(), (Object)EMPTY)) {
                return EmptyIterator.emptyIterator();
            }
            if (object.getValue() != null) {
                FieldPath parent = p;
                FieldPath path = new FieldPath(parent, object.getField(), object.getValue());
                return new SingletonIterator((Object)path);
            }
            final FieldPath parent = p;
            final SearchCriterion crit = object.getField();
            Object lastValue = parent.getLastValue();
            Collections.emptySet();
            if (ObjectUtil.equals((Object)lastValue, (Object)EMPTY)) {
                return EmptyIterator.emptyIterator();
            }
            Collection values = crit.getValues(new LinkedList(), lastValue);
            if (values.size() == 0) {
                return new SingletonIterator((Object)new FieldPath(parent, crit, EMPTY));
            }
            return new TransformingIterator(values.iterator(), (VectorTransformer)new VectorTransformer<Object, FieldPath>(){

                public FieldPath transform(Object in) {
                    FieldPath path = new FieldPath(parent, crit, in);
                    return path;
                }
            });
        }
    }

    protected static class FieldPathRootIteratorFactory
    implements IteratorFactory {
        protected LinkDatabase linkDatabase;

        public FieldPathRootIteratorFactory(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public Iterator getIterator(Object object) {
            if (object != null) {
                return new SingletonIterator((Object)new FieldPath((IdentifiedObject)object));
            }
            return new TransformingIterator(this.linkDatabase.getObjects().iterator(), (VectorTransformer)new VectorTransformer<IdentifiedObject, FieldPath>(){

                public FieldPath transform(IdentifiedObject in) {
                    return new FieldPath(in);
                }
            });
        }
    }

    public static class FieldPathElement {
        protected SearchCriterion field;
        protected Object value;

        public FieldPathElement(SearchCriterion field, Object value) {
            this.field = field;
            this.value = value;
        }

        public SearchCriterion getField() {
            return this.field;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

