/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel;

import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Relationship;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.util.TermUtil;

public interface RootAlgorithm {
    public static final Logger logger = Logger.getLogger(RootAlgorithm.class);
    public static final RootAlgorithm STRICT = new AbstractRootAlgorithm(){

        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            for (Relationship relationship : lo.getParents()) {
                if (relationship instanceof Link && ((Link)relationship).getParent() instanceof DanglingObject || relationship instanceof ValueLink && !(((ValueLink)relationship).getValue() instanceof IdentifiedObject) || relationship instanceof Link && (TermUtil.isObsolete(((Link)relationship).getParent()) || TermUtil.isObsolete(((Link)relationship).getType()))) continue;
                return false;
            }
            return GREEDY.isRoot(lo);
        }

        public String toString() {
            return "STRICT";
        }
    };
    public static final RootAlgorithm GREEDY = new AbstractRootAlgorithm(){

        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            Collection<Link> parents = this.linkDatabase.getParents(lo);
            for (Relationship relationship : parents) {
                if (relationship instanceof Link && ((Link)relationship).getParent() instanceof DanglingObject || relationship instanceof Link && (TermUtil.isObsolete(((Link)relationship).getParent()) || TermUtil.isObsolete(((Link)relationship).getType())) || relationship instanceof ValueLink && !(((ValueLink)relationship).getValue() instanceof IdentifiedObject) || !relationship.getType().isTransitive()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "GREEDY";
        }
    };

    public boolean isRoot(LinkedObject var1);

    public void setLinkDatabase(LinkDatabase var1);

    public static abstract class AbstractRootAlgorithm
    implements RootAlgorithm {
        protected LinkDatabase linkDatabase = DefaultLinkDatabase.getDefault();
        protected Iterator sourceSet;

        public void setLinkDatabase(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public void setSources(Iterator sourceSet) {
            this.sourceSet = sourceSet;
        }
    }
}

