/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.TinySet;
import org.obo.datamodel.AnnotatedObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiableObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.TermSubset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedObjectImpl
implements AnnotatedObject,
SubsetObject {
    protected static final Logger logger = Logger.getLogger(AnnotatedObjectImpl.class);
    protected static int internal_id_gen = 0;
    public int internal_id = internal_id_gen++;
    protected String id;
    protected int hashCode;
    protected boolean anonymous = false;
    protected boolean isObsolete = false;
    protected Set considerReplacements = new TinySet();
    protected Set replacements = new TinySet();
    protected Set categories = new TinySet();
    protected Set synonyms = new TinySet();
    protected Set dbxrefs = new TinySet();
    protected Set<String> secondaryIDs = new TinySet();
    protected Set<Dbxref> defReferences = new TinySet();
    protected Set propertyValues = new TinySet();
    protected HashMap categoryExtensionHash;
    protected NestedValue definitionExtension;
    protected String definition = "";
    protected Namespace namespace;
    protected String name;
    protected String comment = "";
    protected NestedValue idExtension;
    protected NestedValue nameExtension;
    protected NestedValue namespaceExtension;
    protected NestedValue commentExtension;
    protected NestedValue obsoleteExtension;
    protected NestedValue anonymousExtension;
    protected NestedValue typeExtension;
    protected HashMap secondaryIDExtensionMap;
    protected HashMap considerExtensionMap;
    protected HashMap replacedByExtensionMap;
    protected String createdBy;
    protected Date creationDate;
    protected String modifiedBy;
    protected Date modificationDate;
    protected NestedValue modificationDateExtension;
    protected NestedValue createdByExtension;
    protected NestedValue modifiedByExtension;
    protected NestedValue creationDateExtension;

    public AnnotatedObjectImpl(String id) {
        this.id = id;
        this.hashCode = id.hashCode();
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public void setIsAnonymous(boolean isAnonymous) {
        this.anonymous = isAnonymous;
    }

    @Override
    public boolean isBuiltIn() {
        return false;
    }

    @Override
    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public Set getReplacedBy() {
        return this.replacements;
    }

    @Override
    public void addReplacedBy(ObsoletableObject replacedBy) {
        this.replacements.add(replacedBy);
    }

    @Override
    public void removeReplacedBy(ObsoletableObject replacedBy) {
        this.replacements.remove(replacedBy);
    }

    public Set getConsiderReplacements() {
        return this.considerReplacements;
    }

    @Override
    public void addConsiderReplacement(ObsoletableObject o) {
        this.considerReplacements.add(o);
    }

    @Override
    public void removeConsiderReplacement(ObsoletableObject o) {
        this.considerReplacements.remove(o);
    }

    public Set getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void addSynonym(Synonym s) {
        this.synonyms.add(s);
    }

    @Override
    public void removeSynonym(Synonym s) {
        this.synonyms.remove(s);
    }

    public Set getDbxrefs() {
        return this.dbxrefs;
    }

    @Override
    public void addDbxref(Dbxref xref) {
        this.dbxrefs.add(xref);
    }

    @Override
    public void removeDbxref(Dbxref xref) {
        Iterator it = this.dbxrefs.iterator();
        while (it.hasNext()) {
            Dbxref ref = (Dbxref)it.next();
            if (!ref.equals(xref)) continue;
            logger.info((Object)("removing matching dbxref " + ref));
            it.remove();
            break;
        }
    }

    @Override
    public void addSecondaryID(String secondaryID) {
        this.secondaryIDs.add(secondaryID);
    }

    @Override
    public void removeSecondaryID(String secondaryID) {
        this.secondaryIDs.remove(secondaryID);
    }

    public Set getSecondaryIDs() {
        return this.secondaryIDs;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setIDExtension(NestedValue nv) {
        this.idExtension = nv;
    }

    @Override
    public void setNameExtension(NestedValue nv) {
        this.nameExtension = nv;
    }

    @Override
    public void setCommentExtension(NestedValue nv) {
        this.commentExtension = nv;
    }

    @Override
    public void setObsoleteExtension(NestedValue nv) {
        this.obsoleteExtension = nv;
    }

    @Override
    public void setAnonymousExtension(NestedValue nv) {
        this.anonymousExtension = nv;
    }

    @Override
    public void setNamespaceExtension(NestedValue nv) {
        this.namespaceExtension = nv;
    }

    @Override
    public void setTypeExtension(NestedValue nv) {
        this.typeExtension = nv;
    }

    @Override
    public void addReplacedByExtension(ObsoletableObject oo, NestedValue nv) {
        if (this.replacedByExtensionMap == null) {
            this.replacedByExtensionMap = new HashMap();
        }
        this.replacedByExtensionMap.put(oo, nv);
    }

    @Override
    public NestedValue getReplacedByExtension(ObsoletableObject oo) {
        if (this.replacedByExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.replacedByExtensionMap.get(oo);
    }

    @Override
    public void addSecondaryIDExtension(String id, NestedValue nv) {
        if (this.secondaryIDExtensionMap == null) {
            this.secondaryIDExtensionMap = new HashMap();
        }
        this.secondaryIDExtensionMap.put(id, nv);
    }

    @Override
    public NestedValue getSecondaryIDExtension(String id) {
        if (this.secondaryIDExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.secondaryIDExtensionMap.get(id);
    }

    @Override
    public void addConsiderExtension(ObsoletableObject o, NestedValue nv) {
        if (this.considerExtensionMap == null) {
            this.considerExtensionMap = new HashMap();
        }
        this.considerExtensionMap.put(o, nv);
    }

    @Override
    public NestedValue getConsiderExtension(ObsoletableObject o) {
        if (this.considerExtensionMap == null) {
            return null;
        }
        return (NestedValue)this.considerExtensionMap.get(o);
    }

    @Override
    public NestedValue getIDExtension() {
        return this.idExtension;
    }

    @Override
    public NestedValue getNameExtension() {
        return this.nameExtension;
    }

    @Override
    public NestedValue getCommentExtension() {
        return this.commentExtension;
    }

    @Override
    public NestedValue getObsoleteExtension() {
        return this.obsoleteExtension;
    }

    @Override
    public NestedValue getAnonymousExtension() {
        return this.anonymousExtension;
    }

    @Override
    public NestedValue getNamespaceExtension() {
        return this.namespaceExtension;
    }

    @Override
    public NestedValue getTypeExtension() {
        return this.typeExtension;
    }

    @Override
    public void addPropertyValue(PropertyValue pv) {
        if (this.propertyValues == null) {
            this.propertyValues = new TinySet();
        }
        this.propertyValues.add(pv);
    }

    @Override
    public Set<Dbxref> getDefDbxrefs() {
        return this.defReferences;
    }

    @Override
    public void addDefDbxref(Dbxref ref) {
        if (ref.getType() != 2) {
            new Exception("adding non-definition dbxref " + ref + " as dbxref.").printStackTrace();
        }
        this.defReferences.add(ref);
    }

    @Override
    public void removeDefDbxref(Dbxref ref) {
        this.defReferences.remove(ref);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @Override
    public void addCategoryExtension(TermSubset category, NestedValue nv) {
        if (this.categoryExtensionHash == null) {
            this.categoryExtensionHash = new HashMap();
        }
        this.categoryExtensionHash.put(category, nv);
    }

    @Override
    public NestedValue getCategoryExtension(TermSubset category) {
        if (this.categoryExtensionHash == null) {
            return null;
        }
        return (NestedValue)this.categoryExtensionHash.get(category);
    }

    @Override
    public void setDefinitionExtension(NestedValue definitionExtension) {
        this.definitionExtension = definitionExtension;
    }

    @Override
    public NestedValue getDefinitionExtension() {
        return this.definitionExtension;
    }

    public Set getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public void removePropertyValue(PropertyValue pv) {
        if (this.propertyValues != null) {
            this.propertyValues.remove(pv);
        }
    }

    @Override
    public void addCategory(TermSubset category) {
        this.categories.add(category);
    }

    @Override
    public void removeCategory(TermSubset category) {
        this.categories.remove(category);
    }

    public Set getSubsets() {
        return this.categories;
    }

    public String toString() {
        return this.getName() + " (" + this.getID() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof IdentifiableObject) {
            IdentifiableObject io = (IdentifiableObject)o;
            return io.getID().equals(this.getID());
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            AnnotatedObjectImpl out = (AnnotatedObjectImpl)super.clone();
            out.internal_id = internal_id_gen++;
            out.synonyms = new TinySet();
            for (Synonym s : this.synonyms) {
                out.addSynonym((Synonym)s.clone());
            }
            out.dbxrefs = new TinySet();
            for (Dbxref d : this.getDbxrefs()) {
                out.addDbxref((Dbxref)d.clone());
            }
            out.defReferences = new TinySet();
            for (Dbxref d : this.getDefDbxrefs()) {
                out.addDefDbxref((Dbxref)d.clone());
            }
            out.categories = new TinySet();
            Iterator<Object> it = this.categories.iterator();
            while (it.hasNext()) {
                out.addCategory((TermSubset)it.next());
            }
            out.secondaryIDs = new TinySet();
            it = this.secondaryIDs.iterator();
            while (it.hasNext()) {
                out.addSecondaryID((String)it.next());
            }
            return out;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public NestedValue getCreationDateExtension() {
        return this.creationDateExtension;
    }

    @Override
    public void setCreationDateExtension(NestedValue creationDateExtension) {
        this.creationDateExtension = creationDateExtension;
    }

    @Override
    public NestedValue getModificationDateExtension() {
        return this.modificationDateExtension;
    }

    @Override
    public void setModificationDateExtension(NestedValue modificationDateExtension) {
        this.modificationDateExtension = modificationDateExtension;
    }

    @Override
    public NestedValue getModifiedByExtension() {
        return this.modifiedByExtension;
    }

    @Override
    public void setModifiedByExtension(NestedValue modifiedByExtension) {
        this.modifiedByExtension = modifiedByExtension;
    }

    @Override
    public NestedValue getCreatedByExtension() {
        return this.createdByExtension;
    }

    @Override
    public void setCreatedByExtension(NestedValue createdByExtension) {
        this.createdByExtension = createdByExtension;
    }
}

