/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.impl.SimpleDatatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDatatype
extends SimpleDatatype<Date> {
    protected static final Logger logger = Logger.getLogger(DateDatatype.class);
    private static final long serialVersionUID = -8087786198895424706L;
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat();

    @Override
    public String getID() {
        return "xsd:date";
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public String getComment() {
        return "Represents a date";
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public Datatype getSupertype() {
        return Datatype.SIMPLE_TYPE;
    }

    @Override
    public boolean isLegalValue(String string) {
        try {
            this.parse(string);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    protected Date parse(String string) throws ParseException {
        return this.simpleDateFormat.parse(string);
    }

    @Override
    public Date getValue(String string) {
        try {
            return this.parse(string);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Cannot convert " + string + "to a date");
        }
    }

    @Override
    public String getString(Date o) {
        return this.simpleDateFormat.format(o);
    }
}

