/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.apache.log4j.Logger;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.impl.SimpleDatatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalDatatype
extends SimpleDatatype<Double> {
    protected static final Logger logger = Logger.getLogger(DecimalDatatype.class);
    private static final long serialVersionUID = 8806419242226244891L;

    @Override
    public String getID() {
        return "xsd:decimal";
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public String getComment() {
        return "Represents a real number";
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public Datatype getSupertype() {
        return Datatype.SIMPLE_TYPE;
    }

    @Override
    public boolean isLegalValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public Double getValue(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal decimal value " + string);
        }
    }

    @Override
    public String getString(Double o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }
}

