/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.apache.log4j.Logger;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;
import org.obo.datamodel.impl.DbxrefImpl;
import org.obo.datamodel.impl.InstanceImpl;
import org.obo.datamodel.impl.LinkedAnnotatedObjectImpl;
import org.obo.datamodel.impl.NestedValueImpl;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.datamodel.impl.OBOPropertyImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.datamodel.impl.PropertyValueImpl;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.datamodel.impl.SynonymTypeImpl;
import org.obo.datamodel.impl.TermCategoryImpl;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryList;

public class DefaultObjectFactory
implements ObjectFactory {
    protected static final Logger logger = Logger.getLogger(DefaultObjectFactory.class);
    private static final long serialVersionUID = 4992712121441282799L;
    protected static DefaultObjectFactory factory = new DefaultObjectFactory();

    public static ObjectFactory getFactory() {
        return factory;
    }

    public OBOSession createSession() {
        return new OBOSessionImpl(this);
    }

    public IdentifiedObject createObject(String id, OBOClass type, boolean isAnonymousID) {
        LinkedAnnotatedObjectImpl out = type.equals(OBOClass.OBO_CLASS) ? new OBOClassImpl(id) : (type.equals(OBOClass.OBO_PROPERTY) ? new OBOPropertyImpl(id) : (type.equals(OBOClass.OBO_INSTANCE) ? new InstanceImpl(id) : new InstanceImpl(id, type)));
        out.setIsAnonymous(isAnonymousID);
        return out;
    }

    public DanglingObject createDanglingObject(String id, boolean isType) {
        if (isType) {
            return new DanglingPropertyImpl(id);
        }
        return new DanglingObjectImpl(id);
    }

    public OBORestriction createOBORestriction(LinkedObject child, OBOProperty type, LinkedObject parent, boolean implied) {
        OBORestrictionImpl restriction = new OBORestrictionImpl(child, type, parent, implied);
        return restriction;
    }

    public SynonymType createSynonymType(String id, String name, int scope) {
        return new SynonymTypeImpl(id, name, scope);
    }

    public TermSubset createSubset(String id, String name) {
        return new TermCategoryImpl(id, name);
    }

    public Namespace createNamespace(String id, String path) {
        return new Namespace(id, path);
    }

    public Synonym createSynonym(String name, int type) {
        return new SynonymImpl(name, type);
    }

    public Dbxref createDbxref(String db, String id, String desc, int type, Synonym synonym) {
        return new DbxrefImpl(db, id, desc, type, synonym);
    }

    public NestedValue createNestedValue() {
        return new NestedValueImpl();
    }

    public PropertyValue createPropertyValue(String property, String value) {
        return new PropertyValueImpl(property, value, null, -1);
    }

    public HistoryList createHistoryList() {
        return new DefaultHistoryList();
    }
}

