/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBORestrictionImpl
implements OBORestriction {
    protected static final Logger logger = Logger.getLogger(OBORestrictionImpl.class);
    private static final long serialVersionUID = -5348272558004398963L;
    protected transient LinkedObject child;
    protected transient LinkedObject parent;
    protected transient OBOProperty type;
    protected NestedValue nv;
    protected boolean implied = false;
    protected OBORestrictionMetaData metadata = null;
    protected List<LinkedObject> additionalArguments;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void insureMetadataObj() {
        if (this.metadata == null) {
            this.metadata = new OBORestrictionMetaData();
        }
    }

    protected void tryMetadataCleanup() {
        if (this.metadata != null && this.metadata.isEmpty()) {
            this.metadata = null;
        }
    }

    @Override
    public void setCardinality(Integer cardinality) {
        this.insureMetadataObj();
        this.metadata.cardinality = cardinality;
        this.tryMetadataCleanup();
    }

    @Override
    public void setMaxCardinality(Integer maxCardinality) {
        this.insureMetadataObj();
        this.metadata.maxCardinality = maxCardinality;
        this.tryMetadataCleanup();
    }

    @Override
    public void setMinCardinality(Integer minCardinality) {
        this.insureMetadataObj();
        this.metadata.minCardinality = minCardinality;
        this.tryMetadataCleanup();
    }

    @Override
    public void setCompletes(boolean completes) {
        this.insureMetadataObj();
        this.metadata.completes = completes;
        this.tryMetadataCleanup();
    }

    @Override
    public void setInverseCompletes(boolean inverseCompletes) {
        this.insureMetadataObj();
        this.metadata.inverseCompletes = inverseCompletes;
        this.tryMetadataCleanup();
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.insureMetadataObj();
        this.metadata.namespace = namespace;
        this.tryMetadataCleanup();
    }

    @Override
    public void setNecessarilyTrue(boolean necessarilyTrue) {
        this.insureMetadataObj();
        this.metadata.necessarilyTrue = necessarilyTrue;
        this.tryMetadataCleanup();
    }

    @Override
    public void setInverseNecessarilyTrue(boolean inverseNecessarilyTrue) {
        this.insureMetadataObj();
        this.metadata.inverseNecessarilyTrue = inverseNecessarilyTrue;
        this.tryMetadataCleanup();
    }

    @Override
    public Integer getCardinality() {
        return this.metadata == null ? null : this.metadata.cardinality;
    }

    @Override
    public Integer getMaxCardinality() {
        return this.metadata == null ? null : this.metadata.maxCardinality;
    }

    @Override
    public Integer getMinCardinality() {
        return this.metadata == null ? null : this.metadata.minCardinality;
    }

    @Override
    public boolean completes() {
        return this.metadata == null ? false : this.metadata.completes;
    }

    @Override
    public boolean inverseCompletes() {
        return this.metadata == null ? false : this.metadata.inverseCompletes;
    }

    @Override
    public void setNestedValue(NestedValue nv) {
        this.nv = nv;
    }

    @Override
    public NestedValue getNestedValue() {
        return this.nv;
    }

    @Override
    public boolean isNecessarilyTrue() {
        return this.metadata == null ? true : this.metadata.necessarilyTrue;
    }

    @Override
    public boolean isInverseNecessarilyTrue() {
        return this.metadata == null ? false : this.metadata.inverseNecessarilyTrue;
    }

    @Override
    public Namespace getNamespace() {
        return this.metadata == null ? null : this.metadata.namespace;
    }

    public OBORestrictionImpl(LinkedObject child) {
        this(child, null, (LinkedObject)null);
    }

    public OBORestrictionImpl(LinkedObject child, OBOProperty type, LinkedObject parent) {
        this(child, type, parent, false);
    }

    public OBORestrictionImpl(LinkedObject child, OBOProperty type, LinkedObject parent, boolean implied) {
        this.child = child;
        this.parent = parent;
        this.type = type;
        this.implied = implied;
    }

    @Override
    public boolean isImplied() {
        return this.implied;
    }

    public OBORestrictionImpl(boolean implied) {
        this(null, null, null, implied);
    }

    public OBORestrictionImpl(Link link) {
        this(link.getChild(), link.getType(), link.getParent());
    }

    public OBORestrictionImpl(Link link, boolean completes) {
        this(link);
        this.setCompletes(completes);
    }

    public OBORestrictionImpl(LinkedObject child, LinkedObject parent, OBOProperty type) {
        this(child, type, parent);
    }

    public OBORestrictionImpl() {
    }

    @Override
    public LinkedObject getChild() {
        return this.child;
    }

    @Override
    public LinkedObject getParent() {
        return this.parent;
    }

    @Override
    public OBOProperty getType() {
        return this.type;
    }

    @Override
    public void setType(OBOProperty in) {
        this.type = in;
    }

    @Override
    public void setChild(LinkedObject child) {
        this.child = child;
        if (ForwardChainingReasoner.checkRecache && child.equals(ForwardChainingReasoner.weirdLink.getChild())) {
            logger.info((Object)"what the hell");
        }
    }

    @Override
    public void setParent(LinkedObject parent) {
        this.parent = parent;
    }

    public int hashCode() {
        int typeHash;
        int childHash = 0;
        int parentHash = 0;
        int n = typeHash = this.type == null ? 0 : this.type.hashCode();
        if (this.child != null) {
            childHash = this.child.hashCode();
        }
        if (this.parent != null) {
            parentHash = this.parent.hashCode();
        }
        int hashCode = childHash + parentHash + typeHash;
        if (this.completes()) {
            hashCode *= 2;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Link) {
            return TermUtil.equals(this, (Link)o);
        }
        return false;
    }

    public String toString() {
        String bar = "--";
        if (this.completes()) {
            bar = "~~";
        } else if (this.isImplied()) {
            bar = "==";
        }
        return this.getChild() + " " + bar + (this.type == null ? "null" : this.type.getID()) + bar + "> " + this.getParent();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.child.getID());
        stream.writeObject(this.type.getID());
        stream.writeObject(this.parent.getID());
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        String childID = (String)stream.readObject();
        String typeID = (String)stream.readObject();
        String parentID = (String)stream.readObject();
        if (OBOSessionImpl.serializingSession == null) {
            throw new IllegalStateException("Could not obtain link deserialization context");
        }
        this.child = (LinkedObject)OBOSessionImpl.serializingSession.getObject(childID);
        this.type = (OBOProperty)OBOSessionImpl.serializingSession.getObject(typeID);
        this.parent = (LinkedObject)OBOSessionImpl.serializingSession.getObject(parentID);
    }

    @Override
    public String getID() {
        char sepChar = '-';
        if (this.completes()) {
            sepChar = '~';
        }
        String childID = "null";
        String typeID = "null";
        String parentID = "null";
        if (this.getChild() != null) {
            childID = this.getChild().getID();
        }
        if (this.getType() != null) {
            typeID = this.getType().getID();
        }
        if (this.getParent() != null) {
            parentID = this.getParent().getID();
        }
        return childID + sepChar + typeID + sepChar + '>' + parentID;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public List<LinkedObject> getAdditionalArguments() {
        return this.additionalArguments;
    }

    @Override
    public void setAdditionalArguments(List<LinkedObject> additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    @Override
    public int getNumberOfAdditionalArguments() {
        if (this.additionalArguments == null) {
            return 0;
        }
        return this.additionalArguments.size();
    }

    @Override
    public int getArity() {
        return this.getNumberOfAdditionalArguments() + 2;
    }

    @Override
    public LinkedObject getAdditionalArgumentAt(int index) {
        return this.additionalArguments.get(index);
    }

    @Override
    public void setAdditionalArgumentAt(int index, LinkedObject lo) {
        if (this.additionalArguments == null) {
            this.additionalArguments = new ArrayList<LinkedObject>();
        }
        ((ArrayList)this.additionalArguments).ensureCapacity(index + 1);
        this.additionalArguments.set(index, lo);
    }

    protected static class OBORestrictionMetaData
    implements Serializable {
        protected boolean necessarilyTrue = true;
        protected boolean inverseNecessarilyTrue = false;
        protected boolean completes = false;
        protected boolean inverseCompletes = false;
        protected Integer maxCardinality;
        protected Integer minCardinality;
        protected Integer cardinality;
        protected Namespace namespace;

        protected OBORestrictionMetaData() {
        }

        public boolean isEmpty() {
            return this.necessarilyTrue && !this.inverseNecessarilyTrue && !this.completes && !this.inverseCompletes && this.cardinality == null && this.maxCardinality == null && this.minCardinality == null && this.namespace == null;
        }
    }
}

