/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.AbstractStringCriterion;
import org.obo.filters.CommentSearchCriterion;
import org.obo.filters.DbxrefSearchCriterion;
import org.obo.filters.DefinitionSearchCriterion;
import org.obo.filters.IDSearchCriterion;
import org.obo.filters.NameSynonymSearchCriterion;
import org.obo.filters.SearchCriterion;

public class KeywordSearchCriterion
extends AbstractStringCriterion {
    protected static final Logger logger = Logger.getLogger(KeywordSearchCriterion.class);
    protected List keywordCriteria = new LinkedList();

    public KeywordSearchCriterion() {
        this.keywordCriteria.add(new NameSynonymSearchCriterion());
        this.keywordCriteria.add(new IDSearchCriterion());
        this.keywordCriteria.add(new CommentSearchCriterion());
        this.keywordCriteria.add(new DefinitionSearchCriterion());
        this.keywordCriteria.add(new DbxrefSearchCriterion());
    }

    public Collection getValues(Collection scratch, Object obj) {
        for (SearchCriterion sc : this.keywordCriteria) {
            LinkedList scratchList = new LinkedList();
            sc.getValues(scratchList, obj);
            Iterator it2 = scratchList.iterator();
            while (it2.hasNext()) {
                String s = it2.next().toString();
                scratch.add(s);
            }
        }
        return scratch;
    }

    public String getID() {
        return "keyword";
    }

    public static void extractKeywords(Collection c, String s) {
        if (s == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, "\t -,+_.!?'\"(){}[]<>;/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() <= 0) continue;
            c.add(token);
        }
    }

    public Class getInputType() {
        return IdentifiedObject.class;
    }

    public String toString() {
        return "Keyword";
    }
}

