/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.obo.filters.AbstractComparison;

public class WildcardComparison
extends AbstractComparison {
    protected static final Logger logger = Logger.getLogger(WildcardComparison.class);
    protected Class[] types = new Class[]{String.class};
    protected Map patternMap = new HashMap();

    public void init() {
        this.patternMap.clear();
    }

    public void cleanup() {
        this.patternMap.clear();
    }

    public Class[] getAcceptedTypes() {
        return this.types;
    }

    public String getID() {
        return "*=";
    }

    protected Pattern getPattern(String value) {
        Pattern pattern = (Pattern)this.patternMap.get(value);
        if (pattern == null) {
            pattern = Pattern.compile(this.getRegexp(value), 2);
            this.patternMap.put(value, pattern);
        }
        return pattern;
    }

    public String getRegexp(String val) {
        boolean escaped = false;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (escaped) {
                escaped = false;
                if (c == '\\' || c == '*') {
                    out.append(c);
                    continue;
                }
                out.append('\\');
                out.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '*') {
                out.append(".*");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public boolean matches(Collection testVals, String value) {
        if (value == null) {
            value = "";
        }
        Pattern p = this.getPattern(value);
        Iterator it = testVals.iterator();
        while (it.hasNext()) {
            String s = it.next().toString();
            Matcher m = p.matcher(s);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "matches wildcard";
    }
}

