/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.DatatypeValue;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.ValueLink;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;

public class DeletePropertyValueHistoryItem
extends HistoryItem {
    protected static final Logger logger = Logger.getLogger(DeletePropertyValueHistoryItem.class);
    private static final long serialVersionUID = 5400055973408890140L;
    protected String propertyID;
    protected String datatypeID;
    protected String value;

    public DeletePropertyValueHistoryItem(ValueLink ipv) {
        this.setTarget(ipv.getChild().getID());
        this.propertyID = ipv.getType().getID();
        if (ipv.getValue() instanceof DatatypeValue) {
            DatatypeValue dv = (DatatypeValue)ipv.getValue();
            this.value = dv.getValue();
            this.datatypeID = dv.getType().getID();
        } else {
            this.value = ((IdentifiedObject)ipv.getValue()).getID();
        }
    }

    public DeletePropertyValueHistoryItem(String targetID, String propertyID, String datatypeID, String value) {
        this.setTarget(targetID);
        this.propertyID = propertyID;
        this.datatypeID = datatypeID;
        this.value = value;
    }

    public String getPropertyID() {
        return this.propertyID;
    }

    public String getDatatypeID() {
        return this.datatypeID;
    }

    public String getValue() {
        return this.value;
    }

    public String getShortName() {
        return "add property value";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletePropertyValueHistoryItem)) {
            return false;
        }
        DeletePropertyValueHistoryItem item = (DeletePropertyValueHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.propertyID, (Object)item.getPropertyID()) && ObjectUtil.equals((Object)this.datatypeID, (Object)item.getDatatypeID()) && ObjectUtil.equals((Object)this.value, (Object)item.getValue());
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

