/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DefaultHistoryList;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.OperationWarning;
import org.obo.history.StringRelationship;
import org.obo.history.SubclassedMacroHistoryItem;

public class LinkTypeHistoryItem
extends SubclassedMacroHistoryItem {
    protected static final Logger logger = Logger.getLogger(LinkTypeHistoryItem.class);
    private static final long serialVersionUID = 4652336581904427325L;
    StringRelationship rel;
    String relType;

    public LinkTypeHistoryItem() {
        this(null, (String)null);
    }

    public LinkTypeHistoryItem(StringRelationship rel, String relType) {
        super("change relationship");
        this.rel = rel;
        this.target = null;
        this.setRelType(relType);
    }

    public LinkTypeHistoryItem(Link tr, OBOProperty relType) {
        super("change relationship");
        this.rel = LinkTypeHistoryItem.createStringRelationship(tr);
        this.target = null;
        this.setRelType(relType);
    }

    public int hashCode() {
        return LinkTypeHistoryItem.getHash(this.rel) ^ LinkTypeHistoryItem.getHash(this.relType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinkTypeHistoryItem)) {
            return false;
        }
        LinkTypeHistoryItem item = (LinkTypeHistoryItem)o;
        return ObjectUtil.equals((Object)this.rel, (Object)item.getRel()) && ObjectUtil.equals((Object)this.relType, (Object)item.getRelationshipType());
    }

    public StringRelationship getRel() {
        return this.rel;
    }

    public void setRel(StringRelationship rel) {
        this.rel = rel;
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

    public void setRelType(OBOProperty type) {
        this.relType = type.getID();
    }

    public String getRelationshipType() {
        return this.relType;
    }

    public String toString() {
        return "Changed relationship of " + this.rel + " to " + this.relType;
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        if (this.rel.canForward(oldID) || ObjectUtil.equals((Object)this.target, (Object)oldID)) {
            DefaultHistoryList out = new DefaultHistoryList();
            Iterator it = newIDs.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                LinkTypeHistoryItem newitem = (LinkTypeHistoryItem)this.clone();
                newitem.getRel().forwardID(oldID, id);
                if (newitem.getRelationshipType().equals(oldID)) {
                    newitem.setRelType(id);
                }
                out.addItem(newitem);
            }
            return out;
        }
        return null;
    }

    protected OperationWarning getItems(OBOSession history, List historyItems) {
        historyItems.add(new DeleteLinkHistoryItem(this.getRel()));
        historyItems.add(new CreateLinkHistoryItem(this.getRel().getChild(), this.relType, this.getRel().getParent()));
        return null;
    }
}

