/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.AddConsiderHistoryItem;
import org.obo.history.AddDbxrefHistoryItem;
import org.obo.history.AddReplacementHistoryItem;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.ChangeSynScopeHistoryItem;
import org.obo.history.CommentChangeHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DefinitionChangeHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DestroyObjectHistoryItem;
import org.obo.history.OperationWarning;
import org.obo.history.RemoveConsiderHistoryItem;
import org.obo.history.RemoveReplacementHistoryItem;
import org.obo.history.SecondaryIDHistoryItem;
import org.obo.history.SubclassedMacroHistoryItem;
import org.obo.util.HistoryUtil;
import org.obo.util.TermUtil;

public class TermMergeHistoryItem
extends SubclassedMacroHistoryItem {
    protected static final Logger logger = Logger.getLogger(TermMergeHistoryItem.class);
    private static final long serialVersionUID = 153351404511268849L;
    protected String slave;
    protected List graphEdits = new Vector();

    public TermMergeHistoryItem(OBOClass masterNode, OBOClass slaveNode) {
        this(masterNode.getID(), slaveNode.getID());
    }

    public TermMergeHistoryItem() {
        this((String)null, (String)null);
    }

    public TermMergeHistoryItem(String masterNode, String slaveNode) {
        super("merge");
        this.setTarget(masterNode);
        this.slave = slaveNode;
    }

    public int hashCode() {
        return TermMergeHistoryItem.getHash(this.target) ^ TermMergeHistoryItem.getHash(this.slave);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermMergeHistoryItem)) {
            return false;
        }
        TermMergeHistoryItem item = (TermMergeHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.slave, (Object)item.getSlave());
    }

    protected OperationWarning getItems(OBOSession history, List out) {
        IdentifiedObject m = history.getObject(this.target);
        IdentifiedObject sio = history.getObject(this.slave);
        if (m == null) {
            return new OperationWarning("Could not merge unrecognized node " + this.target);
        }
        if (sio == null) {
            return new OperationWarning("Could not merge unrecognized node " + this.slave);
        }
        if (!(m instanceof OBOClass)) {
            return new OperationWarning("Could not merge non-class node " + this.target);
        }
        if (!(sio instanceof OBOClass)) {
            return new OperationWarning("Could not merge non-class node " + this.slave);
        }
        OBOClass masterNode = (OBOClass)m;
        OBOClass slaveNode = (OBOClass)sio;
        this.checkSubstitutionTags(out, slaveNode, masterNode, history);
        Collection<LinkedObject> targetDescendants = TermUtil.getDescendants(masterNode, true);
        Collection<LinkedObject> targetAncestors = TermUtil.getAncestors((LinkedObject)masterNode, true);
        for (Link tr : slaveNode.getChildren()) {
            LinkedObject slaveChild = tr.getChild();
            OBORestrictionImpl newtr = new OBORestrictionImpl(tr.getParent(), tr.getType(), slaveChild);
            out.add(new DeleteLinkHistoryItem(tr));
            if (targetAncestors.contains(slaveChild) || HistoryUtil.hasChild(masterNode, tr)) continue;
            out.add(new CreateLinkHistoryItem(slaveChild, tr.getType(), masterNode));
        }
        Vector<Link> slaveParents = new Vector<Link>();
        slaveParents.addAll(slaveNode.getParents());
        for (int i = 0; i < slaveParents.size(); ++i) {
            Link tr = (Link)slaveParents.get(i);
            LinkedObject slaveParent = tr.getParent();
            OBORestrictionImpl newtr = new OBORestrictionImpl((LinkedObject)masterNode, tr.getType(), tr.getParent());
            out.add(new DeleteLinkHistoryItem(tr));
            if (targetDescendants.contains(slaveParent) || HistoryUtil.hasChild(tr.getParent(), newtr)) continue;
            out.add(new CreateLinkHistoryItem(masterNode, tr.getType(), tr.getParent()));
        }
        out.add(new DestroyObjectHistoryItem(slaveNode));
        out.add(new SecondaryIDHistoryItem(masterNode, slaveNode.getID(), false));
        for (String id : slaveNode.getSecondaryIDs()) {
            out.add(new SecondaryIDHistoryItem(masterNode, id, false));
        }
        for (Synonym s : slaveNode.getSynonyms()) {
            Synonym masters = HistoryUtil.findSynonym((SynonymedObject)masterNode, s.getText());
            if (masters == null) {
                out.add(new AddSynonymHistoryItem(masterNode.getID(), s.getText()));
                out.add(new ChangeSynScopeHistoryItem(masterNode.getID(), s.getText(), 0, s.getScope()));
                masters = DefaultObjectFactory.getFactory().createSynonym(s.getText(), 0);
            }
            for (Dbxref ref : s.getXrefs()) {
                if (masters.getXrefs().contains(ref)) continue;
                out.add(new AddDbxrefHistoryItem(masterNode.getID(), ref, false, masters.getText()));
            }
        }
        for (Dbxref ref : slaveNode.getDbxrefs()) {
            if (masterNode.getDbxrefs().contains(ref)) continue;
            out.add(new AddDbxrefHistoryItem(masterNode.getID(), ref, false, null));
        }
        Synonym s = HistoryUtil.findSynonym((SynonymedObject)masterNode, slaveNode.getName());
        if (s == null) {
            out.add(new AddSynonymHistoryItem(masterNode.getID(), slaveNode.getName()));
            out.add(new ChangeSynScopeHistoryItem(masterNode.getID(), slaveNode.getName(), 0, 1));
        }
        String newDef = masterNode.getDefinition().length() == 0 ? slaveNode.getDefinition() : (slaveNode.getDefinition().length() == 0 ? masterNode.getDefinition() : "MERGED DEFINITION:\nTARGET DEFINITION: " + masterNode.getDefinition() + "\n" + "--------------------\n" + "SOURCE DEFINITION: " + slaveNode.getDefinition());
        String newComment = masterNode.getComment().length() == 0 ? slaveNode.getComment() : (slaveNode.getComment().length() == 0 ? masterNode.getComment() : "MERGED COMMENT:\nTARGET COMMENT: " + masterNode.getComment() + "\n" + "--------------------\n" + "SOURCE COMMENT: " + slaveNode.getComment());
        out.add(new DefinitionChangeHistoryItem(masterNode, newDef));
        out.add(new CommentChangeHistoryItem(masterNode, newComment));
        return null;
    }

    private void checkSubstitutionTags(List out, OBOClass slaveNode, OBOClass masterNode, OBOSession history) {
        LinkDatabase ldb = history.getLinkDatabase();
        Collection<ObsoletableObject> obsoletes = TermUtil.getObsoletes(ldb);
        for (ObsoletableObject obsoleteTerm : obsoletes) {
            Set<ObsoletableObject> considerTerms = obsoleteTerm.getConsiderReplacements();
            for (ObsoletableObject considerTerm : considerTerms) {
                System.out.println("TermMergeHistoryItem: obsoletes section: considerTerm = " + considerTerm + " slaveNode = " + slaveNode);
                if (slaveNode != considerTerm) continue;
                this.updateConsiderReplacementOnMerge(out, obsoleteTerm, slaveNode, masterNode);
            }
            Set<ObsoletableObject> replacementTerms = obsoleteTerm.getReplacedBy();
            for (ObsoletableObject replacementTerm : replacementTerms) {
                System.out.println("TermMergeHistoryItem: obsoletes section: replacementTerm = " + replacementTerm + " slaveNode = " + slaveNode);
                if (slaveNode != replacementTerm) continue;
                this.updateReplacedByOnMerge(out, obsoleteTerm, slaveNode, masterNode);
            }
        }
    }

    private List updateConsiderReplacementOnMerge(List out, ObsoletableObject obsoleteTerm, OBOClass slaveNode, OBOClass masterNode) {
        out.add(new AddConsiderHistoryItem(obsoleteTerm, masterNode));
        out.add(new RemoveConsiderHistoryItem(obsoleteTerm, slaveNode));
        return out;
    }

    private List updateReplacedByOnMerge(List out, ObsoletableObject obsoleteTerm, OBOClass slaveNode, OBOClass masterNode) {
        out.add(new RemoveReplacementHistoryItem(obsoleteTerm, slaveNode));
        out.add(new AddReplacementHistoryItem(obsoleteTerm, masterNode));
        return out;
    }

    public String getShortName() {
        return "merge";
    }

    public String getMaster() {
        return this.target;
    }

    public void setSlave(String slave) {
        this.slave = slave;
    }

    public String getSlave() {
        return this.slave;
    }

    public String toString() {
        return "Merged " + this.slave + " into " + this.target;
    }

    public Set getEditedTerms() {
        this.editedTerms.add(this.target);
        this.editedTerms.add(this.slave);
        return super.getEditedTerms();
    }
}

