/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.OperationWarning;
import org.obo.history.StringRelationship;
import org.obo.history.SubclassedMacroHistoryItem;

public class TermMoveHistoryItem
extends SubclassedMacroHistoryItem {
    protected static final Logger logger = Logger.getLogger(TermMoveHistoryItem.class);
    private static final long serialVersionUID = 4038576748144412475L;
    StringRelationship rel;
    String newProp;

    public TermMoveHistoryItem(String target, String newProp, StringRelationship rel) {
        super("move");
        this.target = target;
        this.rel = rel;
        this.newProp = newProp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermMoveHistoryItem)) {
            return false;
        }
        TermMoveHistoryItem item = (TermMoveHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.rel, (Object)item.getRelationship());
    }

    public int hashCode() {
        return TermMoveHistoryItem.getHash(this.rel) ^ TermMoveHistoryItem.getHash(this.target);
    }

    public TermMoveHistoryItem() {
        this((String)null, null, null);
    }

    public void setRel(StringRelationship rel) {
        this.rel = rel;
    }

    public void setNewProp(String newProp) {
        this.newProp = newProp;
    }

    public TermMoveHistoryItem(LinkedObject target, OBOProperty newProp, Link rel) {
        this(target.getID(), newProp.getID(), TermMoveHistoryItem.createStringRelationship(rel));
    }

    public TermMoveHistoryItem(LinkedObject target, Link rel) {
        this(target, rel.getType(), rel);
    }

    protected OperationWarning getItems(OBOSession history, List historyItems) {
        historyItems.add(new CreateLinkHistoryItem(this.rel.getChild(), this.newProp, this.target));
        historyItems.add(new DeleteLinkHistoryItem(this.rel));
        return null;
    }

    public String getShortName() {
        return "move";
    }

    public StringRelationship getRelationship() {
        return this.rel;
    }

    public String toString() {
        if (this.rel == null) {
            return "moved";
        }
        return "Moved " + this.rel.getChild() + " to " + this.target + " from " + this.rel.getParent();
    }

    public Set getEditedTerms() {
        this.editedTerms.add(this.rel.getChild());
        return super.getEditedTerms();
    }
}

