/*
 * Decompiled with CFR 0.152.
 */
package org.obo.identifier;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.identifier.DefaultLinkIDResolution;
import org.obo.identifier.IDResolution;
import org.obo.identifier.IDWarning;
import org.obo.identifier.LinkIDResolution;
import org.obo.identifier.LinkIDWarning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinkIDWarning
implements LinkIDWarning {
    protected static final Logger logger = Logger.getLogger(DefaultLinkIDWarning.class);
    protected Link link;
    protected IDWarning parentWarning;
    protected IDWarning typeWarning;

    public DefaultLinkIDWarning(Link link, IDWarning parentWarning, IDWarning typeWarning) {
        this.link = link;
        this.parentWarning = parentWarning;
        this.typeWarning = typeWarning;
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    @Override
    public IDWarning getParentWarning() {
        return this.parentWarning;
    }

    @Override
    public IDWarning getTypeWarning() {
        return this.typeWarning;
    }

    @Override
    public Collection<LinkIDResolution> getResolutions() {
        LinkedList<LinkIDResolution> resolutions = new LinkedList<LinkIDResolution>();
        if (this.parentWarning != null) {
            for (IDResolution res : this.parentWarning.getResolutions()) {
                resolutions.add(new DefaultLinkIDResolution(this.link, res, null));
            }
        }
        if (this.typeWarning != null) {
            for (IDResolution res : this.typeWarning.getResolutions()) {
                resolutions.add(new DefaultLinkIDResolution(this.link, null, res));
            }
        }
        return resolutions;
    }

    public String toString() {
        return this.link + ", parentWarning=(" + this.parentWarning + "), typeWarning=(" + this.typeWarning + ")";
    }
}

