/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOSession;
import org.obo.history.HistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.nlp.Namer;
import org.obo.nlp.impl.LogicalDefinitionNamer;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamerUtil {
    public static Namer getDefaultNamer() {
        return new LogicalDefinitionNamer();
    }

    public static void nameUnnamedObjects(OBOSession session) {
        NamerUtil.nameUnnamedObjects(session, NamerUtil.getDefaultNamer());
    }

    public static void nameUnnamedObjects(OBOSession session, Namer namer) {
        for (OBOObject io : TermUtil.getOBOObjects(session)) {
            if (io.getName() == null) {
                Collection<String> names = namer.constructNames(io);
                io.setName(names.iterator().next());
            }
            if (io.getName() != null) continue;
            io.setName(io.getID());
        }
    }

    public static Collection<HistoryItem> getNameUnnamedObjectsAction(OBOSession session) {
        return NamerUtil.getNameUnnamedObjectsAction(session, NamerUtil.getDefaultNamer());
    }

    public static Collection<HistoryItem> getNameUnnamedObjectsAction(OBOSession session, Namer namer) {
        LinkedList<HistoryItem> items = new LinkedList<HistoryItem>();
        for (OBOObject io : TermUtil.getOBOObjects(session)) {
            String newName = null;
            if (io.getName() == null) {
                Collection<String> names = namer.constructNames(io);
                Iterator<String> i$ = names.iterator();
                if (i$.hasNext()) {
                    String name;
                    newName = name = i$.next();
                }
                if (newName == null) {
                    newName = io.getID();
                }
            }
            if (newName == null) continue;
            items.add(new NameChangeHistoryItem(io, newName));
        }
        return items;
    }
}

