/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.SynonymedObject;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.DefinitionChangeHistoryItem;
import org.obo.nlp.Namer;
import org.obo.util.ReasonerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamer
implements Namer {
    @Override
    public Collection<String> constructNames(LinkedObject lo) {
        return null;
    }

    @Override
    public Collection<String> constructTextDefs(LinkedObject lo) {
        return null;
    }

    @Override
    public Collection<AddSynonymHistoryItem> generateSynonymChanges(OBOSession session) {
        ArrayList<AddSynonymHistoryItem> items = new ArrayList<AddSynonymHistoryItem>();
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof SynonymedObject)) continue;
            Collection<String> names = this.constructNames((LinkedObject)io);
            for (String name : names) {
                AddSynonymHistoryItem item = new AddSynonymHistoryItem((SynonymedObject)io, name);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public Collection<DefinitionChangeHistoryItem> generateDefinitionChanges(OBOSession session) {
        ArrayList<DefinitionChangeHistoryItem> items = new ArrayList<DefinitionChangeHistoryItem>();
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof DefinedObject) || ((DefinedObject)io).getDefinition() == null) continue;
            Collection<String> defs = this.constructTextDefs((LinkedObject)io);
            for (String def : defs) {
                DefinitionChangeHistoryItem item = new DefinitionChangeHistoryItem((DefinedObject)io, def);
                items.add(item);
            }
        }
        return items;
    }

    protected boolean isSubclassByName(LinkedObject lo, String superName) {
        if (lo.getName().equals(superName)) {
            return true;
        }
        for (Link tr : lo.getParents()) {
            if (!ReasonerUtil.isSubclass(tr.getType(), OBOProperty.IS_A) || !this.isSubclassByName(tr.getParent(), superName)) continue;
            return true;
        }
        return false;
    }
}

