/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.nlp.Namer;
import org.obo.nlp.impl.AbstractNamer;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegulationTermNamer
extends AbstractNamer
implements Namer {
    protected static final Logger logger = Logger.getLogger(RegulationTermNamer.class);

    @Override
    public Collection<String> constructNames(LinkedObject lo) {
        OBOClass genus;
        LinkedList<String> names = new LinkedList<String>();
        if (TermUtil.isIntersection(lo) && this.isSubclassByName(genus = ReasonerUtil.getGenus((OBOClass)lo), "biological regulation")) {
            Collection<String> currentLabels = TermUtil.getLabels(lo);
            Collection<Link> diffs = ReasonerUtil.getDifferentia((OBOClass)lo);
            if (diffs.size() == 1) {
                Link diff = diffs.iterator().next();
                Collection<String> targetLabels = TermUtil.getExactLabels(diff.getParent());
                HashSet<String> bases = new HashSet<String>();
                if (diff.getType().getID().contains("negatively_regulates")) {
                    bases.add("negative regulation of");
                    bases.add("down-regulation of");
                } else if (diff.getType().getID().contains("positively_regulates")) {
                    bases.add("positive regulation of");
                    bases.add("up-regulation of");
                } else {
                    bases.add("regulation of");
                }
                for (String base : bases) {
                    for (String targetLabel : targetLabels) {
                        String newName = base + " " + targetLabel;
                        if (currentLabels.contains(newName)) continue;
                        names.add(newName);
                    }
                }
            }
        }
        return names;
    }

    @Override
    public Collection<String> constructTextDefs(LinkedObject lo) {
        LinkedList<String> defs = new LinkedList<String>();
        if (TermUtil.isIntersection(lo)) {
            OBOClass genus = ReasonerUtil.getGenus((OBOClass)lo);
            Collection<String> currentLabels = TermUtil.getLabels(lo);
            Collection<Link> diffs = ReasonerUtil.getDifferentia((OBOClass)lo);
            if (diffs.size() == 1) {
                String txt = null;
                Link diff = diffs.iterator().next();
                if (diff.getType().getID().contains("negatively_regulates")) {
                    txt = "decreases";
                } else if (diff.getType().getID().contains("positively_regulates")) {
                    txt = "increases";
                } else if (diff.getType().getID().contains("regulates")) {
                    txt = "modulates";
                }
                if (txt != null) {
                    String def = "Any process that " + txt + " the rate, frequency or extent of " + diff.getParent().getName() + ".";
                    defs.add(def);
                }
            }
        }
        return defs;
    }
}

