/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.datamodel.impl;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.AbstractOWLMetadataMapping;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIRNLexMetadataMapping
extends AbstractOWLMetadataMapping {
    protected static final Logger logger = Logger.getLogger(BIRNLexMetadataMapping.class);
    public String ns = "http://purl.org/nbirn/birnlex/ontology/annotation/BIRNLex_annotation_properties.owl#";

    @Override
    public boolean isOboToOWLLossy() {
        return true;
    }

    @Override
    public String getName() {
        return "BIRNLex Annotation Property Mapping";
    }

    @Override
    public String getDesc() {
        return "Uses ";
    }

    @Override
    public Set<OWLAxiom> getOWLAxioms(OWLAdapter adapter, OWLEntity owlEntity, IdentifiedObject io) {
        String comment;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.setFactory(adapter.getOwlFactory());
        if (io instanceof CommentedObject && (comment = ((CommentedObject)io).getComment()) != null && !comment.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), comment));
        }
        return axioms;
    }

    @Override
    public boolean translateOWLAxiom(OWLAnnotationAxiom axiom, IdentifiedObject lo, OWLAdapter adapter) {
        OWLAnnotation owlAnnot = axiom.getAnnotation();
        URI uri = owlAnnot.getAnnotationURI();
        if (!(lo instanceof OBOObject)) {
            return false;
        }
        OBOObject obj = (OBOObject)lo;
        if (owlAnnot instanceof OWLConstantAnnotation) {
            String val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
            if (uri.equals(BIRNLexVocabulary.SYNONYM.getURI())) {
                obj.addSynonym(new SynonymImpl(val));
                return true;
            }
            if (uri.equals(BIRNLexVocabulary.CL_ID.getURI())) {
                this.addDbxref(obj, "CL", val);
                return true;
            }
            if (uri.equals(BIRNLexVocabulary.GO_ID.getURI())) {
                this.addDbxref(obj, "GO", val);
                return true;
            }
            if (uri.equals(BIRNLexVocabulary.UMLS_ID.getURI())) {
                this.addDbxref(obj, "UMLS", val);
                return true;
            }
            if (uri.equals(BIRNLexVocabulary.BONFIRE_ID.getURI())) {
                this.addDbxref(obj, "BONFIRE", val);
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BIRNLexVocabulary {
        CL_ID("cell_ontology_ID"),
        GO_ID("gene_Ontology_ID"),
        UMLS_ID("umls_ID"),
        BONFIRE_ID("bonfireID"),
        NIF_ID("nifID"),
        SYNONYM("synonym");

        URI uri;

        private BIRNLexVocabulary(String uri) {
            this.uri = URI.create(uri);
        }

        public URI getURI() {
            return this.uri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SAONamespaces {
        BIRNLEX_ANNOT("http://purl.org/nbirn/birnlex/ontology/annotation/BIRNLex_annotation_properties.owl#");

        String ns;

        private SAONamespaces(String ns) {
            this.ns = ns;
        }

        public String toString() {
            return this.ns;
        }
    }
}

