/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.datamodel.impl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.AbstractOWLMetadataMapping;
import org.obo.owl.util.IDSpaceRegistry;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCBOOboInOWLMetadataMapping
extends AbstractOWLMetadataMapping {
    protected static final Logger logger = Logger.getLogger(NCBOOboInOWLMetadataMapping.class);
    public static final String HAS_DEFINITION = "hasDefinition";
    public static final String HAS_SYNONYM = "hasSynonym";

    public NCBOOboInOWLMetadataMapping() {
        IDSpaceRegistry registry = IDSpaceRegistry.getInstance();
        registry.registerMapping("http://www.geneontology.org/formats/oboInOwl#", "OboInOWL");
    }

    @Override
    public boolean isOboToOWLLossy() {
        return true;
    }

    @Override
    public String getName() {
        return "NCBO OboInOWL mapping";
    }

    @Override
    public String getDesc() {
        return "See http://www.bioontology.org/wiki/index.php/OboInOwl:Main_Page";
    }

    public static String ns() {
        return "http://www.w3.org/2000/01/rdf-schema";
    }

    public URI getVocabURI(String s) {
        return URI.create(NCBOOboInOWLMetadataMapping.ns() + "#" + s);
    }

    @Override
    public Set<OWLAxiom> getOWLAxioms(OWLAdapter adapter, OWLEntity owlEntity, IdentifiedObject io) {
        String def;
        String comment;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.setFactory(adapter.getOwlFactory());
        OWLDataFactory owlFactory = adapter.getOwlFactory();
        if (io instanceof CommentedObject && (comment = ((CommentedObject)io).getComment()) != null && !comment.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), comment));
        }
        if (io instanceof DefinedObject && (def = ((DefinedObject)io).getDefinition()) != null && !def.equals("")) {
            try {
                OWLIndividual defInst = owlFactory.getOWLIndividual(adapter.getURI(io.getID() + "__def"));
                OWLAnnotationAxiom axiom1 = this.getAnnotationAxiom(owlEntity, this.getVocabURI(HAS_DEFINITION), defInst);
                axioms.add((OWLAxiom)axiom1);
                OWLUntypedConstant defCon = owlFactory.getOWLUntypedConstant(def);
                OWLDataProperty rdfsHasLabel = owlFactory.getOWLDataProperty(OWLRDFVocabulary.RDFS_LABEL.getURI());
                OWLDataPropertyAssertionAxiom axiom2 = owlFactory.getOWLDataPropertyAssertionAxiom(defInst, (OWLDataPropertyExpression)rdfsHasLabel, (OWLConstant)defCon);
                axioms.add((OWLAxiom)axiom2);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                if (!this.isOboToOWLLossy()) {
                    // empty if block
                }
            }
        }
        if (io instanceof SynonymedObject) {
            SynonymedObject so = (SynonymedObject)io;
        }
        if (io instanceof ObsoletableObject) {
            OWLClass obCls = owlFactory.getOWLClass(OboInOWLVocabulary.OBSOLETE_CLASS.uri);
            if (owlEntity instanceof OWLDescription) {
                OWLSubClassAxiom axiom = owlFactory.getOWLSubClassAxiom((OWLDescription)owlEntity, (OWLDescription)obCls);
            } else {
                logger.error((Object)("cannot handle obsolete " + io.getClass()));
                if (!this.isOboToOWLLossy()) {
                    // empty if block
                }
            }
        }
        return axioms;
    }

    @Override
    public boolean translateOWLAxiom(OWLAnnotationAxiom axiom, IdentifiedObject lo, OWLAdapter adapter) {
        String val;
        OWLAnnotation owlAnnot = axiom.getAnnotation();
        URI uri = owlAnnot.getAnnotationURI();
        if (owlAnnot instanceof OWLConstantAnnotation) {
            val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
            if (uri.equals(OboInOWLVocabulary.SYNONYM.getURI())) {
                if (lo instanceof SynonymedObject) {
                    ((SynonymedObject)lo).addSynonym(new SynonymImpl(val));
                }
                return true;
            }
        }
        if (owlAnnot instanceof OWLObjectAnnotation) {
            val = (OWLIndividual)((OWLObjectAnnotation)owlAnnot).getAnnotationValue();
            String instId = adapter.getOboID((OWLEntity)val);
            IdentifiedObject io = adapter.getSession().getObject(instId);
            if (uri.equals(OboInOWLVocabulary.HAS_DEFINITION.getURI())) {
                if (lo instanceof DefinedObject && io != null) {
                    ((DefinedObject)lo).setDefinition(io.getName());
                    adapter.getSession().removeObject(io);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void translateGraph(OBOSession session) {
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
            for (Link link : ((LinkedObject)io).getParents()) {
                if (!link.getParent().getID().equals("OboInOWL:ObsoleteClass")) continue;
                ((LinkedObject)io).removeParent(link);
                ((ObsoletableObject)io).setObsolete(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OboInOWLVocabulary {
        SYNONYM("synonym"),
        HAS_DEFINITION("hasDefinition"),
        OBSOLETE_CLASS("ObsoleteClass");

        URI uri;

        private OboInOWLVocabulary(String uri) {
            this.uri = URI.create((Object)((Object)OboInOWLNamespaces.OboInOWL) + uri);
        }

        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            return this.uri.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OboInOWLNamespaces {
        OboInOWL("http://www.geneontology.org/formats/oboInOwl#");

        String ns;

        private OboInOWLNamespaces(String ns) {
            this.ns = ns;
        }

        public String toString() {
            return this.ns;
        }
    }
}

