/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.datamodel.impl;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.impl.DbxrefImpl;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.AbstractOWLMetadataMapping;
import org.obo.owl.util.IDSpaceRegistry;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBIMetadataMapping
extends AbstractOWLMetadataMapping {
    protected static final Logger logger = Logger.getLogger(OBIMetadataMapping.class);
    public String ns = "http://obi.sourceforge.net/ontology/OBI.owl#";

    @Override
    public boolean isOboToOWLLossy() {
        return true;
    }

    @Override
    public String getName() {
        return "OBI mapping";
    }

    @Override
    public String getDesc() {
        return "Uses OBI annotation properties";
    }

    @Override
    public void registerIDSpaces() {
        IDSpaceRegistry.getInstance().registerMapping("http://obi.sourceforge.net/ontology/OBI.owl#", "obi");
    }

    @Override
    public Set<OWLAxiom> getOWLAxioms(OWLAdapter adapter, OWLEntity owlEntity, IdentifiedObject io) {
        String comment;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.setFactory(adapter.getOwlFactory());
        if (io instanceof CommentedObject && (comment = ((CommentedObject)io).getComment()) != null && !comment.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), comment));
        }
        return axioms;
    }

    @Override
    public boolean translateOWLAxiom(OWLAnnotationAxiom axiom, IdentifiedObject lo, OWLAdapter adapter) {
        OWLAnnotation owlAnnot = axiom.getAnnotation();
        URI uri = owlAnnot.getAnnotationURI();
        if (owlAnnot instanceof OWLConstantAnnotation) {
            String val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
            if (uri.equals(OBIVocabulary.SYNONYM.getURI())) {
                if (lo instanceof OBOObject) {
                    ((OBOObject)lo).addSynonym(new SynonymImpl(val));
                }
                return true;
            }
            if (uri.equals(OBIVocabulary.DEFINITION.getURI())) {
                if (lo instanceof OBOObject) {
                    ((OBOObject)lo).setDefinition(val);
                }
                return true;
            }
            if (uri.equals(OBIVocabulary.DEFINITION_EDITOR.getURI()) || uri.equals(OBIVocabulary.DEFINITION_SOURCE.getURI())) {
                String db = "obi:";
                DbxrefImpl xref = new DbxrefImpl(db, val);
                xref.setType(2);
                if (lo instanceof OBOObject) {
                    ((OBOObject)lo).addDefDbxref(xref);
                }
                return true;
            }
            if (uri.equals(OWLRDFVocabulary.RDFS_COMMENT.getURI())) {
                if (lo instanceof CommentedObject) {
                    ((CommentedObject)lo).setComment(val);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OBIVocabulary {
        DEFINITION("definition"),
        DEFINITION_EDITOR("definition_editor"),
        DEFINITION_SOURCE("definition_source"),
        SYNONYM("alternative_term");

        URI uri;

        private OBIVocabulary(String uri) {
            this.uri = URI.create((Object)((Object)OBINamespaces.OBI) + uri);
        }

        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            return this.uri.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OBINamespaces {
        OBI("http://obi.sourceforge.net/ontology/OBI.owl#");

        String ns;

        private OBINamespaces(String ns) {
            this.ns = ns;
        }

        public String toString() {
            return this.ns;
        }
    }
}

